/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.List;
import java.util.Map;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ContentBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom2.Content;
import org.jdom2.Element;

public class PageBO
extends ContentBO {
    private Boolean hasVanity;
    private String pageTemplate;

    public PageBO(String namePrefix, Map<String, ArticleBO> articles, List<ContentBO> subPages, Boolean hasVanity, String siteKey, String fileName, Integer numberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate, String description, String pageTemplate, String cmisSite, List<String> externalFilePaths, boolean personalized, int minPersonalizationVariants, int maxPersonalizationVariants) {
        super(namePrefix, articles, subPages, siteKey, fileName, numberBigText, acls, idCategory, idTag, visibilityEnabled, visibilityStartDate, visibilityEndDate, description, cmisSite, externalFilePaths, personalized, minPersonalizationVariants, maxPersonalizationVariants);
        this.hasVanity = hasVanity;
        this.pageTemplate = pageTemplate;
        this.buildPageElement();
    }

    private void buildPageElement() {
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_TEST);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_REP);
        this.element.addNamespaceDeclaration(ContentGeneratorCst.NS_WEM);
        this.element.setAttribute("changefreq", "monthly");
        this.element.setAttribute("templateName", this.pageTemplate, ContentGeneratorCst.NS_J);
        this.element.setAttribute("primaryType", "jnt:page", ContentGeneratorCst.NS_JCR);
        this.element.setAttribute("priority", "0.5");
        Object mixinTypes = "jmix:sitemap";
        if (this.hasVanity.booleanValue()) {
            mixinTypes = (String)mixinTypes + " jmix:vanityUrlMapped";
        }
        this.element.setAttribute("mixinTypes", (String)mixinTypes, ContentGeneratorCst.NS_JCR);
        Element listNode = new Element("listA");
        listNode.setAttribute("primaryType", "jnt:contentList", ContentGeneratorCst.NS_JCR);
        this.buildPersonalizedElements(listNode);
        this.element.addContent((Content)listNode);
        if (this.hasVanity.booleanValue()) {
            Element vanityNode = new Element("vanityUrlMapping");
            vanityNode.setAttribute("primaryType", "jnt:vanityUrls", ContentGeneratorCst.NS_JCR);
            Element vanitySubNode = new Element(this.namePrefix);
            vanitySubNode.setAttribute("active", "true", ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("default", "true", ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("url", "/" + this.namePrefix, ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            vanitySubNode.setAttribute("primaryType", "jnt:vanityUrl", ContentGeneratorCst.NS_JCR);
            vanityNode.addContent((Content)vanitySubNode);
            this.element.addContent((Content)vanityNode);
        }
    }
}

