/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.maven.plugin.contentgenerator.bo.AceBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.AclBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.CollectionBO;
import org.jdom2.Content;
import org.jdom2.Element;

public class UserBO {
    private String name;
    private String password;
    private String jcrPath;
    private String email;
    private List<CollectionBO> collections = new ArrayList<CollectionBO>();

    public UserBO(String name, String password) {
        this.name = name;
        this.password = password;
        this.email = this.name + "@example.com";
    }

    public UserBO(String name, String password, String pathJcr, List<CollectionBO> collections) {
        this.name = name;
        this.password = password;
        this.email = this.name + "@example.com";
        this.jcrPath = pathJcr;
        this.collections = collections;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPathJcr() {
        return this.jcrPath;
    }

    public void setPathJcr(String pathJcr) {
        this.jcrPath = pathJcr;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<CollectionBO> getCollections() {
        return this.collections;
    }

    public String getDirectoryName(int indexDir) {
        String dirname = null;
        if (this.jcrPath != null) {
            String[] directories = StringUtils.split((String)this.jcrPath, (String)"/");
            dirname = directories[indexDir];
        }
        return dirname;
    }

    public Element getJcrXml() {
        Element userElement = new Element(this.name);
        userElement.setAttribute("email", this.email);
        userElement.setAttribute("emailNotificationsDisabled", Boolean.FALSE.toString());
        userElement.setAttribute("accountLocked", Boolean.FALSE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("email", this.email, ContentGeneratorCst.NS_J);
        userElement.setAttribute("external", Boolean.FALSE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("firstName", this.name + " firstname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("lastName", this.name + " lastname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("organization", "Organization", ContentGeneratorCst.NS_J);
        userElement.setAttribute("password", this.password, ContentGeneratorCst.NS_J);
        userElement.setAttribute("published", Boolean.TRUE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("firstName", this.name + " firstname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("mixinTypes", "jmix:accessControlled", ContentGeneratorCst.NS_JCR);
        userElement.setAttribute("primaryType", "jnt:user", ContentGeneratorCst.NS_JCR);
        userElement.setAttribute("preferredLanguage", "en");
        if (CollectionUtils.isNotEmpty(this.collections)) {
            Element collectionsElement = new Element("collections");
            collectionsElement.setAttribute("primaryType", "docnt:collections", ContentGeneratorCst.NS_JCR);
            collectionsElement.setAttribute("createdBy", this.name, ContentGeneratorCst.NS_JCR);
            for (CollectionBO collection : this.collections) {
                collectionsElement.addContent((Content)collection.getElement());
            }
            userElement.addContent((Content)collectionsElement);
        }
        Element files = new Element("files");
        files.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
        Element privateElement = new Element("private");
        privateElement.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
        privateElement.setAttribute("mixinTypes", "jmix:accessControlled", ContentGeneratorCst.NS_JCR);
        Element jAcl = new Element("acl", ContentGeneratorCst.NS_J);
        jAcl.setAttribute("primaryType", "jnt:acl", ContentGeneratorCst.NS_JCR);
        AceBO grantUser = new AceBO("user", this.name, "u", "GRANT", "owner");
        jAcl.addContent((Content)grantUser.getElement());
        privateElement.addContent((Content)jAcl);
        Element imports = new Element("imports");
        imports.setAttribute("primaryType", "jnt:importDropBox", ContentGeneratorCst.NS_JCR);
        Element profile = new Element("profile");
        profile.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
        files.addContent((Content)privateElement);
        privateElement.addContent((Content)imports);
        files.addContent((Content)profile);
        Element contents = new Element("contents");
        contents.setAttribute("primaryType", "jnt:contentFolder", ContentGeneratorCst.NS_JCR);
        Element portlets = new Element("portlets");
        portlets.setAttribute("primaryType", "jnt:portletFolder", ContentGeneratorCst.NS_JCR);
        Element preferences = new Element("preferences");
        preferences.setAttribute("primaryType", "jnt:preferences", ContentGeneratorCst.NS_JCR);
        userElement.addContent((Content)preferences);
        userElement.addContent((Content)files);
        userElement.addContent((Content)contents);
        userElement.addContent((Content)portlets);
        ArrayList<AceBO> aces = new ArrayList<AceBO>();
        AceBO aceOwner = new AceBO(this.name, this.name, "u", "GRANT", "owner");
        aces.add(aceOwner);
        AclBO acl = new AclBO(aces);
        userElement.addContent((Content)acl.getElement());
        if (this.jcrPath == null) {
            return userElement;
        }
        String dir1 = this.getDirectoryName(1);
        String dir2 = this.getDirectoryName(2);
        String dir3 = this.getDirectoryName(3);
        Element root = new Element(dir1);
        root.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        Element subElement1 = new Element(dir2);
        subElement1.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        root.addContent((Content)subElement1);
        Element subElement2 = new Element(dir3);
        subElement2.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        subElement1.addContent((Content)subElement2);
        subElement2.addContent((Content)userElement);
        return root;
    }

    public Element getUserMemberXml() {
        Element lightElement = new Element(this.name);
        lightElement.setAttribute("member", this.jcrPath, ContentGeneratorCst.NS_J);
        lightElement.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
        return lightElement;
    }
}

