/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.CategoryService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.SiteService;
import org.jahia.utils.maven.plugin.contentgenerator.TagService;
import org.jahia.utils.maven.plugin.contentgenerator.UserGroupService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.TagBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.UserBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.DocspaceService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.CollectionBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.DocspaceBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FileBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FolderBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.WiseBO;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class WiseService {
    private Log logger = new SystemStreamLog();
    public static WiseService instance;
    private DocspaceService docspaceService = DocspaceService.getInstance();

    private WiseService() {
    }

    public static WiseService getInstance() {
        if (instance == null) {
            instance = new WiseService();
        }
        return instance;
    }

    public WiseBO generateWiseInstance(ExportBO wiseExport, List<UserBO> users) {
        WiseBO wise = null;
        if (wiseExport.getNbDocspaces() > 0) {
            List<DocspaceBO> docspaces = this.docspaceService.generateDocspaces(wiseExport);
            wise = new WiseBO(wiseExport.getSiteKey(), docspaces, users);
        }
        return wise;
    }

    public String generateWise(ExportBO wiseExport) throws IOException {
        OutputService os = new OutputService();
        UserGroupService userGroupService = new UserGroupService();
        SiteService siteService = new SiteService();
        TagService tagService = new TagService();
        ArrayList<File> globalFilesToZip = new ArrayList<File>();
        Document systemSiteRepository = siteService.createSystemSiteRepository();
        Element tagsList = tagService.createTagListElement();
        List<TagBO> tags = tagService.createTagsBO(wiseExport.getNumberOfTags());
        wiseExport.setTags(tags);
        for (TagBO tag : tags) {
            tagsList.addContent((Content)tag.getTagElement());
        }
        List<UserBO> users = userGroupService.generateUsers(wiseExport.getNumberOfUsers(), 0, 0, 0);
        WiseBO wiseInstance = this.generateWiseInstance(wiseExport, users);
        File wiseInstanceOutputDir = new File(wiseExport.getOutputDir() + "/wise");
        File wiseInstanceContentDir = new File(wiseInstanceOutputDir + "/content");
        wiseInstanceOutputDir.mkdir();
        this.logger.info((CharSequence)"Creating repository file");
        this.insertWiseInstanceIntoSiteRepository(systemSiteRepository, wiseInstance.getElement());
        this.insertTagsListIntoWiseInstance(systemSiteRepository, tagsList, wiseExport.getSiteKey());
        CategoryService cs = new CategoryService();
        Element categories = cs.createCategories(wiseExport.getNumberOfCategories(), wiseExport.getNumberOfCategoryLevels(), wiseExport);
        cs.insertCategoriesIntoSiteRepository(systemSiteRepository, categories);
        File repositoryFile = new File(wiseInstanceOutputDir + "/repository.xml");
        os.writeJdomDocumentToFile(systemSiteRepository, repositoryFile);
        this.logger.info((CharSequence)"Creating site properties file");
        siteService.createPropertiesFile(wiseExport.getSiteKey(), wiseExport.getSiteLanguages(), "templates-wise", wiseInstanceOutputDir);
        ArrayList<File> wiseInstanceFiles = new ArrayList<File>(FileUtils.listFiles((File)wiseInstanceOutputDir, null, (boolean)false));
        if (wiseInstanceContentDir.exists()) {
            wiseInstanceFiles.add(wiseInstanceContentDir);
        }
        this.logger.info((CharSequence)"Creating Wise site archive");
        File wiseArchive = os.createSiteArchive("wise.zip", wiseExport.getOutputDir(), wiseInstanceFiles);
        globalFilesToZip.add(wiseArchive);
        Integer nbCollectionsPerUser = wiseExport.getNbCollectionsPerUser();
        Integer nbFilesPerCollection = wiseExport.getNbFilesPerCollection();
        if (nbFilesPerCollection.compareTo(wiseExport.getNbFilesPerFolder()) > 0) {
            nbFilesPerCollection = wiseExport.getNbFilesPerFolder();
        }
        this.logger.info((CharSequence)"Creating users");
        users = userGroupService.generateUsers(wiseExport.getNumberOfUsers(), nbCollectionsPerUser, nbFilesPerCollection, wiseExport.getNbFilesPerFolder());
        File tmpUsers = new File(wiseExport.getOutputDir(), "users");
        tmpUsers.mkdir();
        File repositoryUsers = new File(tmpUsers, "repository.xml");
        Document usersRepositoryDocument = userGroupService.createUsersRepository(users);
        os.writeJdomDocumentToFile(usersRepositoryDocument, repositoryUsers);
        ArrayList<File> filesToZip = new ArrayList<File>();
        File contentUsers = userGroupService.createFileTreeForUsers(users, tmpUsers);
        filesToZip.add(repositoryUsers);
        filesToZip.add(contentUsers);
        File usersArchive = os.createSiteArchive("users.zip", wiseExport.getOutputDir(), filesToZip);
        globalFilesToZip.add(usersArchive);
        this.logger.info((CharSequence)"Creating Wise instance archive");
        File wiseImportArchive = os.createSiteArchive("wise_instance_generated.zip", wiseExport.getOutputDir(), globalFilesToZip);
        this.logger.info((CharSequence)"Generating users, files and tags lists");
        ArrayList<String> userNames = new ArrayList<String>();
        ArrayList<String> collections = new ArrayList<String>();
        for (UserBO user : users) {
            userNames.add(user.getName());
            for (CollectionBO collection : user.getCollections()) {
                collections.add(collection.getTitle());
            }
        }
        File usersFile = new File(wiseExport.getOutputDir(), "users.txt");
        usersFile.delete();
        os.appendPathToFile(usersFile, userNames);
        ArrayList<String> filePaths = new ArrayList<String>();
        for (DocspaceBO docspace : wiseInstance.getDocspaces()) {
            filePaths.addAll(this.getFilePaths(docspace.getFolders()));
        }
        File filePathsFile = new File(wiseExport.getOutputDir(), "files.txt");
        filePathsFile.delete();
        os.appendPathToFile(filePathsFile, filePaths);
        ArrayList<String> tagNames = new ArrayList<String>();
        for (TagBO tag : tags) {
            tagNames.add(tag.getTagName());
        }
        File tagsFile = new File(wiseExport.getOutputDir(), "tags.txt");
        tagsFile.delete();
        os.appendPathToFile(tagsFile, tagNames);
        return wiseImportArchive.getAbsolutePath();
    }

    private Document insertWiseInstanceIntoSiteRepository(Document repository, Element wiseInstance) {
        this.logger.info((CharSequence)"Add Wise instance to the system site repository");
        Element sites = repository.getRootElement().getChild("sites");
        sites.addContent((Content)wiseInstance);
        return repository;
    }

    private Document insertTagsListIntoWiseInstance(Document repository, Element tagsList, String wiseInstanceName) {
        this.logger.info((CharSequence)"Add tags list to the system site repository");
        Element wiseInstanceNode = repository.getRootElement().getChild("sites").getChild(wiseInstanceName);
        wiseInstanceNode.addContent((Content)tagsList);
        return repository;
    }

    private List<String> getFilePaths(List<FolderBO> folders) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(folders)) {
            for (FolderBO folder : folders) {
                filePaths.addAll(this.getFilePaths(folder.getSubFolders()));
                for (FileBO file : folder.getFiles()) {
                    String nodePath = StringUtils.chomp((String)file.getNodePath(), (String)"/");
                    filePaths.add(nodePath);
                }
            }
        }
        return filePaths;
    }
}

