/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.utils.maven.plugin.contentgenerator.bo.AceBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.AclBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom2.Content;
import org.jdom2.Element;

public class FileBO
implements Serializable,
Comparable<FileBO> {
    private static final long serialVersionUID = 1L;
    protected Element fileElement;
    protected String mixinFileType;
    protected String mimeType;
    protected String nodePath;
    protected String fileName;
    protected String jcrFilename;
    protected String creator;
    protected String owner;
    protected String reader;
    protected String editor;
    protected String documentStatus = "draft";
    protected String extractedContent;
    protected String description;
    protected String tag;
    protected String wiseInstanceName;
    protected String creationDate;

    public FileBO(String fileName, String mixinFileType, String mimeType, String nodePath, String creator, String owner, String editor, String reader, String extractedContent, String description, String tag, String wiseInstanceName, String creationDate) {
        this.fileName = fileName;
        this.jcrFilename = ISO9075.encode((String)fileName);
        this.mixinFileType = mixinFileType;
        this.mimeType = mimeType;
        this.nodePath = nodePath;
        this.creator = creator;
        this.owner = owner;
        this.editor = editor;
        this.reader = reader;
        this.extractedContent = extractedContent;
        this.description = description;
        this.tag = tag;
        this.wiseInstanceName = wiseInstanceName;
        this.creationDate = creationDate;
    }

    public FileBO(String fileName, String nodePath) {
        this.fileName = fileName;
        this.nodePath = nodePath;
    }

    public long getSerialVersionUID() {
        return 1L;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getJcrFileName() {
        return this.jcrFilename;
    }

    public String getMixinFileType() {
        return this.mixinFileType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getReader() {
        return this.reader;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getExtractedContent() {
        return this.extractedContent;
    }

    public Element getElement() {
        if (this.fileElement == null) {
            this.fileElement = new Element(this.jcrFilename);
            String mixin = "docmix:docspaceDocument jmix:accessControlled " + this.mixinFileType;
            if (this.tag != null) {
                this.fileElement.setAttribute("tags", "/sites/" + this.wiseInstanceName + "/tags/" + this.tag, ContentGeneratorCst.NS_J);
                mixin = mixin + " jmix:tagged";
            }
            this.fileElement.setAttribute("mixinTypes", mixin, ContentGeneratorCst.NS_JCR);
            this.fileElement.setAttribute("primaryType", "jnt:file", ContentGeneratorCst.NS_JCR);
            this.fileElement.setAttribute("createdBy", this.creator, ContentGeneratorCst.NS_JCR);
            this.fileElement.setAttribute("documentStatus", this.documentStatus);
            this.fileElement.setAttribute("created", this.creationDate, ContentGeneratorCst.NS_JCR);
            Element jTranslation = new Element("translation_en", ContentGeneratorCst.NS_J);
            jTranslation.setAttribute("description", this.description, ContentGeneratorCst.NS_JCR);
            jTranslation.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            jTranslation.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            this.fileElement.addContent((Content)jTranslation);
            Element jcrContentElement = new Element("content", ContentGeneratorCst.NS_JCR);
            jcrContentElement.setAttribute("primaryType", "jnt:resource", ContentGeneratorCst.NS_JCR);
            jcrContentElement.setAttribute("mimeType", this.mimeType, ContentGeneratorCst.NS_JCR);
            jcrContentElement.setAttribute("extractedText", this.extractedContent, ContentGeneratorCst.NS_J);
            jcrContentElement.setAttribute("lastExtractionDate", "2012-08-14T23:35:10.629+02:00", ContentGeneratorCst.NS_J);
            jcrContentElement.setAttribute("lastModified", "2012-08-14T23:35:10.629+02:00", ContentGeneratorCst.NS_JCR);
            this.fileElement.addContent((Content)jcrContentElement);
            AceBO aceOwnerRoot = new AceBO("root", "root", "u", "GRANT", "docspace-owner");
            AceBO aceOwner = new AceBO(this.owner, this.owner, "u", "GRANT", "docspace-owner");
            AceBO aceEditor = new AceBO(this.editor, this.editor, "u", "GRANT", "docspace-editor");
            AceBO aceReader = new AceBO(this.reader, this.reader, "u", "GRANT", "docspace-reader");
            ArrayList<AceBO> aces = new ArrayList<AceBO>();
            aces.add(aceOwner);
            aces.add(aceOwnerRoot);
            aces.add(aceEditor);
            aces.add(aceReader);
            AclBO acl = new AclBO(aces);
            this.fileElement.addContent((Content)acl.getElement());
        }
        return this.fileElement;
    }

    public String toString() {
        return this.fileName + " - description: " + this.description;
    }

    public int hashCode() {
        return this.jcrFilename.charAt(0);
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof FileBO)) {
            return false;
        }
        FileBO f = (FileBO)arg0;
        return this.fileName.intern() == f.getFileName().intern();
    }

    @Override
    public int compareTo(FileBO f) throws NullPointerException {
        int nameDiff = this.fileName.compareToIgnoreCase(f.getFileName());
        return nameDiff;
    }
}

