/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import aQute.bnd.osgi.Jar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.jahia.utils.maven.plugin.osgi.DependenciesMojo;
import org.jahia.utils.osgi.BundleUtils;
import org.jahia.utils.osgi.ManifestValueClause;
import org.jahia.utils.osgi.parsers.PackageInfo;
import org.jahia.utils.osgi.parsers.ParsingContext;

public class CheckDependenciesMojo
extends DependenciesMojo {
    protected String classifier;
    protected boolean failBuildOnSplitPackages = true;
    protected boolean skipCheckDependencies;
    private MavenProjectHelper mavenProjectHelper;
    private ArtifactHandlerManager artifactHandlerManager;
    private ArchiverManager archiverManager;

    @Override
    public void execute() throws MojoExecutionException {
        String artifactFilePath;
        File artifactFile;
        int scanned;
        long timer = System.currentTimeMillis();
        if (this.skipCheckDependencies || !this.isValidPackaging()) {
            return;
        }
        this.initialize();
        ArrayList<PackageInfo> bundlePluginExplicitPackages = null;
        try {
            bundlePluginExplicitPackages = new ArrayList<PackageInfo>();
            this.getBundlePluginExplicitPackageImports(this.projectParsingContext, bundlePluginExplicitPackages, this.originalInstructions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.scanClassesBuildDirectory(this.projectParsingContext);
            this.getLog().info((CharSequence)("Scanned classes directory in " + (System.currentTimeMillis() - timer) + " ms. Found " + this.projectParsingContext.getLocalPackages().size() + " project packages."));
            scanned = this.scanDependencies(this.projectParsingContext);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning dependencies", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error while scanning project packages", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)("Scanned " + scanned + " project dependencies in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + this.projectParsingContext.getLocalPackages().size() + " project packages."));
        this.projectParsingContext.postProcess();
        if (!this.projectParsingContext.getSplitPackages().isEmpty() && this.failBuildOnSplitPackages) {
            StringBuilder splitPackageList = new StringBuilder();
            for (PackageInfo packageInfo : this.projectParsingContext.getSplitPackages()) {
                splitPackageList.append("  ");
                splitPackageList.append(packageInfo.toString());
                splitPackageList.append(" from locations:\n    ");
                splitPackageList.append(StringUtils.join((Collection)packageInfo.getSourceLocations(), (String)"\n    "));
                splitPackageList.append("\n");
            }
            throw new MojoExecutionException("Detected split packages:\n" + splitPackageList.toString());
        }
        String extension = this.project.getPackaging();
        if ("bundle".equals(extension)) {
            extension = "jar";
        }
        if (!(artifactFile = new File(artifactFilePath = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName() + "." + extension)).exists()) {
            throw new MojoExecutionException("No artifact generated for project, was the goal called in the proper phase (should be verify) ?");
        }
        Set<String> allPackages = this.getAvailablePackages();
        try (Jar jarFile = new Jar(artifactFile);){
            allPackages.addAll(jarFile.getPackages());
            Manifest manifest = jarFile.getManifest();
            if (manifest.getMainAttributes() == null) {
                throw new MojoExecutionException("Error reading OSGi bundle manifest data from artifact " + artifactFile);
            }
            String importPackageHeaderValue = manifest.getMainAttributes().getValue("Import-Package");
            TreeSet<String> visitedPackageImports = new TreeSet<String>();
            if (importPackageHeaderValue != null) {
                List importPackageClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)importPackageHeaderValue);
                ArrayList<ManifestValueClause> clausesToRemove = new ArrayList<ManifestValueClause>();
                boolean modifiedImportPackageClauses = false;
                for (ManifestValueClause importPackageClause : importPackageClauses) {
                    for (String importPackagePath : importPackageClause.getPaths()) {
                        PackageInfo info = this.getPackageInfo(this.existingPackageImports, importPackagePath);
                        if (info == null) {
                            info = this.getPackageInfo(bundlePluginExplicitPackages, importPackagePath);
                        }
                        if (info != null) {
                            this.getLog().info((CharSequence)("Explicit package configuration found for " + importPackagePath + "."));
                            if (info.getVersion() != null) {
                                String bndVersion = (String)importPackageClause.getAttributes().get("version");
                                if (bndVersion == null || !bndVersion.equals(info.getVersion())) {
                                    this.getLog().info((CharSequence)("Explicit package configuration version" + info.getVersion() + " is different than BND one " + bndVersion + " for " + importPackagePath + "."));
                                    modifiedImportPackageClauses = true;
                                }
                                importPackageClause.getAttributes().put("version", info.getVersion());
                            }
                            for (Map.Entry<Object, Object> entry : info.getOtherDirectives().entrySet()) {
                                importPackageClause.getDirectives().put((String)entry.getKey(), (String)entry.getValue());
                            }
                        } else if (!"mandatory".equals(importPackageClause.getDirectives().get("resolution")) && !allPackages.contains(importPackagePath)) {
                            importPackageClause.getDirectives().put("resolution", "optional");
                            modifiedImportPackageClauses = true;
                        }
                        if (visitedPackageImports.contains(importPackagePath)) {
                            this.getLog().warn((CharSequence)("Duplicate import detected on package " + importPackagePath + ", will remove duplicate. To remove this warning remove the duplicate import (possibly coming from a explicit import in the maven-bundle-plugin instructions)"));
                            clausesToRemove.add(importPackageClause);
                            modifiedImportPackageClauses = true;
                        }
                        visitedPackageImports.add(importPackagePath);
                    }
                }
                if (modifiedImportPackageClauses) {
                    for (ManifestValueClause clauseToRemove : clausesToRemove) {
                        boolean removeSuccessful = importPackageClauses.remove(clauseToRemove);
                        if (removeSuccessful) continue;
                        this.getLog().warn((CharSequence)("Removal of clause " + clauseToRemove + " was not successful, duplicates may still remain in Manifest !"));
                    }
                    this.updateBundle(manifest, importPackageClauses, artifactFile);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading OSGi bundle manifest data from artifact " + artifactFile, e);
        }
    }

    public void getBundlePluginExplicitPackageImports(ParsingContext projectParsingContext, List<PackageInfo> bundlePluginExplicitPackages, Map<String, String> originalInstructions) throws IOException {
        String importPackageInstruction = originalInstructions.get("Import-Package");
        importPackageInstruction = importPackageInstruction.replaceAll(",(\\s)*\\$\\{.*\\}", "");
        List existingImportValueClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)importPackageInstruction);
        for (ManifestValueClause existingImportValueClause : existingImportValueClauses) {
            String clauseVersion = (String)existingImportValueClause.getAttributes().get("version");
            String clauseResolution = (String)existingImportValueClause.getDirectives().get("resolution");
            boolean optionalClause = false;
            if ("optional".equals(clauseResolution)) {
                optionalClause = true;
            }
            for (String existingImportPath : existingImportValueClause.getPaths()) {
                bundlePluginExplicitPackages.add(new PackageInfo(existingImportPath, clauseVersion, optionalClause, "Maven plugin configuration", projectParsingContext));
            }
        }
    }

    private PackageInfo getPackageInfo(List<PackageInfo> packages, String packageName) {
        for (PackageInfo packageInfo : packages) {
            if (!packageInfo.getName().equals(packageName)) continue;
            return packageInfo;
        }
        return null;
    }

    private void updateBundle(Manifest manifest, List<ManifestValueClause> importPackageClauses, File artifactFile) {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (ManifestValueClause importPackageClause : importPackageClauses) {
            sb.append(separator);
            sb.append(importPackageClause.toString());
            separator = ",";
        }
        manifest.getMainAttributes().putValue("Import-Package", sb.toString());
        File expandedJarDirectory = this.unpackBundle(artifactFile);
        this.getLog().info((CharSequence)("Extract JAR " + artifactFile + " contents to directory " + expandedJarDirectory));
        File manifestFile = new File(expandedJarDirectory, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            this.getLog().info((CharSequence)"Overwriting existing META-INF/MANIFEST file");
        } else {
            this.getLog().warn((CharSequence)"Missing META-INF/MANIFEST.MF file in bundle, how did that happen ?");
        }
        File dumpManifestFile = new File(this.project.getBuild().getOutputDirectory(), "META-INF/MANIFEST.JAHIA.MF");
        try (FileOutputStream dumpManifestFileOutputStream = new FileOutputStream(dumpManifestFile);){
            manifest.write(dumpManifestFileOutputStream);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error dumping new META-INF/MANIFEST.JAHIA.MF file", (Throwable)e);
            return;
        }
        try (FileOutputStream manifestFileOutputStream = new FileOutputStream(manifestFile);){
            manifest.write(manifestFileOutputStream);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing new META-INF/MANIFEST.MF file", (Throwable)e);
            return;
        }
        this.packBundle(artifactFile, manifestFile, expandedJarDirectory);
        try {
            FileUtils.deleteDirectory((File)expandedJarDirectory);
            this.getLog().info((CharSequence)("Deleted temporary JAR extraction directory " + expandedJarDirectory));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error purging temporary extracted JAR directory " + expandedJarDirectory), (Throwable)e);
        }
        Artifact mainArtifact = this.project.getArtifact();
        if ("bundle".equals(mainArtifact.getType())) {
            mainArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        }
        if (null == this.classifier || this.classifier.trim().length() == 0) {
            mainArtifact.setFile(artifactFile);
        } else {
            this.mavenProjectHelper.attachArtifact(this.project, artifactFile, this.classifier);
        }
    }

    private File unpackBundle(File jarFile) {
        File outputDir = new File(this.projectBuildDirectory, jarFile.getName() + "-" + System.currentTimeMillis());
        try {
            outputDir.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
            unArchiver.setDestDirectory(outputDir);
            unArchiver.setSourceFile(jarFile);
            unArchiver.extract();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem unpacking " + jarFile + " to " + outputDir), (Throwable)e);
            return null;
        }
        return outputDir;
    }

    private void packBundle(File jarFile, File manifestFile, File contentDirectory) {
        try {
            JarArchiver archiver = (JarArchiver)this.archiverManager.getArchiver("jar");
            archiver.setManifest(manifestFile);
            archiver.setDestFile(jarFile);
            archiver.addDirectory(contentDirectory, null, null);
            archiver.createArchive();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem packing " + jarFile + " with contents from  " + contentDirectory), (Throwable)e);
        }
    }

    private Set<String> getAvailablePackages() throws MojoExecutionException {
        HashSet<String> allPackages = new HashSet<String>();
        ArrayList<Artifact> inscope = new ArrayList<Artifact>();
        Collection<Artifact> artifacts = this.getSelectedDependencies(this.project.getArtifacts());
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || artifact.getScope().equals("system")) continue;
            inscope.add(artifact);
        }
        for (Artifact artifact : inscope) {
            File file = artifact.getFile();
            if (file == null) continue;
            String directDep = (String)artifact.getDependencyTrail().get(1);
            try (Jar jar = new Jar(artifact.getArtifactId(), file);){
                String value;
                HashSet packages = new HashSet(jar.getPackages());
                if (directDep.startsWith("org.jahia.server:jahia-impl:jar")) {
                    allPackages.addAll(packages);
                    continue;
                }
                if (!"provided".equals(artifact.getScope()) || jar.getManifest() == null || (value = jar.getManifest().getMainAttributes().getValue("Export-Package")) == null) continue;
                List l = BundleUtils.getHeaderClauses((String)"Export-Package", (String)value);
                packages.retainAll(l.stream().flatMap(c -> c.getPaths().stream()).collect(Collectors.toSet()));
                allPackages.addAll(packages);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allPackages;
    }
}

