/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.resources.JavaScriptDictionaryMojo;

public class GWTDictionaryMojo
extends AbstractMojo {
    protected File dest;
    protected String dictionaryName;
    protected String languages;
    protected boolean prettyPrint;
    protected String resourceBundle;
    protected File src;
    protected String targetFileName;

    private static String normalizeKey(String key) {
        String normalized;
        String string = normalized = key.indexOf(46) != -1 ? key.replace('.', '_') : key;
        if (normalized.indexOf(45) != -1) {
            normalized = normalized.replace('-', '_');
        }
        return normalized;
    }

    private void convert(String locale) throws IOException {
        ResourceBundle bundle;
        ResourceBundle defBundle = this.lookupBundle("", "en");
        if (defBundle == null) {
            throw new FileNotFoundException("ERROR : Couldn't find bundle with name " + this.resourceBundle + ".properties nor " + this.resourceBundle + "_en.properties in " + this.src + " folder, skipping...");
        }
        ResourceBundle resourceBundle = bundle = locale != null ? this.lookupBundle(locale) : null;
        if (!this.dest.exists() && !this.dest.mkdirs()) {
            throw new IOException("Unable to create folder " + this.dest);
        }
        File target = new File(this.dest, this.targetFileName + (String)(locale != null ? "_" + locale : "") + ".js");
        this.getLog().info((CharSequence)("Creating " + target + " ..."));
        PrintWriter out = new PrintWriter(target);
        Enumeration<String> keyEnum = defBundle.getKeys();
        LinkedList<String> keys = new LinkedList<String>();
        while (keyEnum.hasMoreElements()) {
            keys.add(keyEnum.nextElement());
        }
        Collections.sort(keys);
        out.print("var ");
        out.print(this.dictionaryName);
        out.print("={");
        if (this.prettyPrint) {
            out.println();
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String value;
            String key = (String)iterator.next();
            String string = value = bundle != null ? JavaScriptDictionaryMojo.getValue(bundle, key) : null;
            if (value == null) {
                value = JavaScriptDictionaryMojo.getValue(defBundle, key);
            }
            if (value == null) continue;
            out.append(GWTDictionaryMojo.normalizeKey(key)).append(":\"").append(JavaScriptDictionaryMojo.escape(value)).append("\"");
            if (iterator.hasNext()) {
                out.append(",");
            }
            if (!this.prettyPrint) continue;
            out.println();
        }
        out.print("};");
        if (this.prettyPrint) {
            out.println();
        }
        out.flush();
        out.close();
        this.getLog().info((CharSequence)"done");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Converting resource bundle " + this.resourceBundle + " into JavaScript files..."));
        try {
            this.getLog().info((CharSequence)"...no locale (default file)");
            this.convert(null);
            for (String lc : StringUtils.split((String)this.languages, (String)" ,")) {
                String l = lc.trim();
                this.getLog().info((CharSequence)("...locale " + l));
                this.convert(l);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.getLog().info((CharSequence)"...conversion done.");
    }

    private ResourceBundle lookupBundle(String ... locales) throws IOException {
        return JavaScriptDictionaryMojo.lookupBundle(this.src, this.resourceBundle, locales);
    }
}

