/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import pl.jalokim.propertiestojson.resolvers.primitives.PrimitiveJsonTypeResolver;
import pl.jalokim.propertiestojson.util.PropertiesToJsonConverter;

public class Properties2JsonMojo
extends AbstractMojo {
    protected boolean addToProjectResources;
    protected boolean prettyPrinting;
    protected File dest;
    protected String excludes;
    protected String includes;
    protected MavenProject project;
    protected File src;

    protected static String toJson(File src, boolean prettyPrinting) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(src);){
            String json = new PropertiesToJsonConverter(new PrimitiveJsonTypeResolver[0]).convertToJson((InputStream)is);
            if (!prettyPrinting) {
                Gson gson = new GsonBuilder().serializeNulls().create();
                JsonParser jp = new JsonParser();
                JsonElement je = jp.parse(json);
                json = gson.toJson(je);
            }
            String string = json;
            return string;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.src == null || !this.src.exists()) {
            this.getLog().info((CharSequence)("Folder " + this.src + " does not exist. Skipping task."));
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.src);
        ds.setIncludes(StringUtils.split((String)this.includes, (String)", "));
        ds.setExcludes(StringUtils.split((String)this.excludes, (String)", "));
        ds.scan();
        for (String f : ds.getIncludedFiles()) {
            File file = new File(this.src, f);
            try {
                String json = Properties2JsonMojo.toJson(file, this.prettyPrinting);
                File outputFile = this.getOutputFile(f);
                FileUtils.writeStringToFile((File)outputFile, (String)json);
                this.getLog().info((CharSequence)("Converted file " + file + " into " + outputFile));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error converting properties file " + file + " to JSON format", (Exception)e);
            }
        }
        if (this.addToProjectResources) {
            Resource resource = new Resource();
            resource.setDirectory(this.dest.getPath());
            this.project.addResource(resource);
        }
    }

    private File getOutputFile(String f) {
        String normalizedFilePath = f.replace('\\', '/');
        return new File(new File(this.dest, StringUtils.substringBeforeLast((String)normalizedFilePath, (String)"/")), StringUtils.substringAfter((String)FilenameUtils.getBaseName((String)StringUtils.substringAfterLast((String)normalizedFilePath, (String)"/")), (String)"_") + ".json");
    }
}

