/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2019 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/GPL OR 2/JSEL
 *
 *     1/ GPL
 *     ==================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE GPL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom2.Element;

public class FolderBO implements java.io.Serializable, Comparable<FolderBO> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	Element folderElement;

	String folderName;

	List<FolderBO> subFolders;

	Set<FileBO> files;

	public FolderBO(String folderName, List<FolderBO> subFolders, Set<FileBO> files) {
		this.folderName = folderName;
		this.subFolders = subFolders;
		this.files = files;
	}
	
	public Set<FileBO> getFiles() {
		return files;
	}
	
	public String getFolderName() {
		return this.folderName;
	}
	
	public List<FolderBO> getSubFolders() {
		return subFolders;
	}

	public Element getElement() {
		if (folderElement == null) {
			folderElement = new Element(folderName);
			folderElement.setAttribute("mixinTypes", "docmix:docspaceFolder", ContentGeneratorCst.NS_JCR);
			folderElement.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);

			if (files != null) {
				for (Iterator<FileBO> iterator = files.iterator(); iterator.hasNext();) {
					FileBO file = iterator.next();
					folderElement.addContent(file.getElement());
				}
			}
			
			if (subFolders != null) {
				for (Iterator<FolderBO> iterator = subFolders.iterator(); iterator.hasNext();) {
					FolderBO subFolder = iterator.next();
					folderElement.addContent(subFolder.getElement());
				}
			}
			
		}
		return folderElement;
	}

	public int compareTo(FolderBO f) throws NullPointerException {
		return this.folderName.compareTo(f.getFolderName());
	}
	
	public String toString() {
		return folderName;
	}
}
