/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.List;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom2.Content;
import org.jdom2.Element;

public class CategoryBO {
    private String categoryNamePrefix = "category";
    private Integer idCategory;
    private String categoryName;
    private Element categoryElement;
    private List<String> siteLanguages;

    public CategoryBO(Integer idCategory, List<String> siteLanguages) {
        this.idCategory = idCategory;
        this.categoryName = this.categoryNamePrefix + idCategory;
        this.siteLanguages = siteLanguages;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public Element getCategoryElement() {
        if (this.categoryElement == null) {
            this.categoryElement = new Element(this.categoryName);
            this.categoryElement.setAttribute("published", "true", ContentGeneratorCst.NS_J);
            this.categoryElement.setAttribute("primaryType", "jnt:category", ContentGeneratorCst.NS_JCR);
            for (String language : this.siteLanguages) {
                Element translation = new Element("translation_" + language, ContentGeneratorCst.NS_J);
                translation.setAttribute("published", "true", ContentGeneratorCst.NS_J);
                translation.setAttribute("language", language, ContentGeneratorCst.NS_JCR);
                translation.setAttribute("mixinTypes", "mix:title", ContentGeneratorCst.NS_JCR);
                translation.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                translation.setAttribute("title", "Category " + this.idCategory + " (" + language + ")", ContentGeneratorCst.NS_JCR);
                this.categoryElement.addContent((Content)translation);
            }
        }
        return this.categoryElement;
    }
}

