/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.mojo;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.mojo.AbstractJahiaSiteMojo;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.WiseService;

public class GenerateWiseMojo
extends AbstractJahiaSiteMojo {
    private Integer nbDocspaces;
    private Integer nbPolls;
    private Integer nbNotes;
    private Integer nbTasks;
    private Integer nbFoldersPerLevel;
    private Integer foldersDepth;
    private Integer nbFilesPerFolder;
    private Integer nbCollectionsPerUser;
    private Integer nbFilesPerCollection;
    protected Integer numberOfOwners;
    protected Integer numberOfEditors;
    protected Integer numberOfCollaborators;
    protected String startCreationDateRange;
    protected String endCreationDateRange;

    @Override
    protected ExportBO initExport() throws MojoExecutionException {
        boolean filesRequired = false;
        ExportBO wiseExport = super.initExport();
        wiseExport.setNbDocspaces(this.nbDocspaces);
        wiseExport.setNbPolls(this.nbPolls);
        wiseExport.setNbNotes(this.nbNotes);
        wiseExport.setNbFoldersPerLevel(this.nbFoldersPerLevel);
        wiseExport.setFoldersDepth(this.foldersDepth);
        wiseExport.setNbFilesPerFolder(this.nbFilesPerFolder);
        wiseExport.setNbTasks(this.nbTasks);
        wiseExport.setNbCollectionsPerUser(this.nbCollectionsPerUser);
        wiseExport.setNbFilesPerCollection(this.nbFilesPerCollection);
        wiseExport.setNumberOfOwners(this.numberOfOwners);
        wiseExport.setNumberOfEditors(this.numberOfEditors);
        wiseExport.setNumberOfCollaborators(this.numberOfCollaborators);
        ArrayList<String> languages = new ArrayList<String>();
        languages.add("en");
        wiseExport.setSiteLanguages(languages);
        SimpleDateFormat df = new SimpleDateFormat(ContentGeneratorCst.DATE_RANGE_FORMAT);
        Date dStartCreationDateRange = null;
        Date dEndCreationDateRange = null;
        try {
            dStartCreationDateRange = df.parse(this.startCreationDateRange);
        }
        catch (ParseException e) {
            throw new MojoExecutionException("startCreationDateRange is malformed, please use this format: " + ContentGeneratorCst.DATE_RANGE_FORMAT);
        }
        try {
            dEndCreationDateRange = df.parse(this.endCreationDateRange);
        }
        catch (ParseException e) {
            throw new MojoExecutionException("endCreationdateRange is malformed, please use this format: " + ContentGeneratorCst.DATE_RANGE_FORMAT);
        }
        wiseExport.setStartCreationDateRange(dStartCreationDateRange);
        wiseExport.setEndCreationDateRange(dEndCreationDateRange);
        return wiseExport;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        WiseService wiseService = WiseService.getInstance();
        ExportBO wiseExport = this.initExport();
        this.getLog().info((CharSequence)"Jahia content generator for Wise starts");
        this.getLog().info((CharSequence)(wiseExport.getSiteKey() + " instance will be created"));
        try {
            int nbOwners = wiseExport.getNumberOfOwners();
            int nbEditors = wiseExport.getNumberOfEditors();
            int nbCollaborators = wiseExport.getNumberOfCollaborators();
            String wiseRepositoryFile = wiseService.generateWise(wiseExport);
            this.getLog().info((CharSequence)("Each word of this list has been used for the description of " + ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS_COUNTER + " files: " + ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS));
            this.getLog().info((CharSequence)("Each word of this list has been used for the description of " + ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS_COUNTER + " files: " + ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS));
            this.getLog().info((CharSequence)(wiseExport.getNumberOfUsers() + " users created:"));
            this.getLog().info((CharSequence)("- user0 to user" + (nbOwners - 1) + " have docspace-owner role (" + nbOwners + " owners)"));
            this.getLog().info((CharSequence)("- user" + nbOwners + " to user" + (nbOwners + nbEditors - 1) + " have docspace-editor role (" + nbEditors + " editors)"));
            this.getLog().info((CharSequence)("- user" + (nbOwners + nbEditors) + " to user" + (nbOwners + nbEditors + nbCollaborators - 1) + " have docspace-collaborator role (" + nbCollaborators + " collaborators)"));
            this.getLog().info((CharSequence)("Wise instance archive created and available here: " + wiseRepositoryFile));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing output file");
            e.printStackTrace();
        }
    }
}

