/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom2.Content;
import org.jdom2.Element;

public class PollBO {
    private Element poll;
    private String question = "Why ?";
    private String questionElementName = "why?";
    private String status = "open";
    private List<String> answers = new ArrayList<String>();

    public PollBO(String question, List<String> answers) {
        OutputService os = new OutputService();
        this.questionElementName = os.formatStringForXml(question);
        this.question = question;
        this.answers = answers;
    }

    public PollBO(String question, String questionElementName, List<String> answers) {
        this.questionElementName = questionElementName;
        this.question = question;
        this.answers = answers;
    }

    public Element getElement() {
        Random rand = new Random();
        if (this.poll == null) {
            this.poll = new Element(this.questionElementName);
            this.poll.setAttribute("mixinTypes", "docmix:docspaceObject", ContentGeneratorCst.NS_JCR);
            this.poll.setAttribute("primaryType", "jnt:poll", ContentGeneratorCst.NS_JCR);
            this.poll.setAttribute("question", this.question);
            this.poll.setAttribute("status", this.status);
            Element answersElement = new Element("answers");
            answersElement.setAttribute("primaryType", "jnt:answersList", ContentGeneratorCst.NS_JCR);
            for (String answer : this.answers) {
                Element answerElement = new Element(answer);
                answerElement.setAttribute("primaryType", "jnt:answer", ContentGeneratorCst.NS_JCR);
                answerElement.setAttribute("label", answer);
                answerElement.setAttribute("nbOfVotes", String.valueOf(rand.nextInt(10)));
                answersElement.addContent((Content)answerElement);
            }
            this.poll.addContent((Content)answersElement);
        }
        return this.poll;
    }
}

