/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.jahia.utils.maven.plugin.support.MavenAetherHelperUtils;
import org.jahia.utils.osgi.parsers.ParsingContext;

public class ParsingContextCache {
    private static final String CACHE_MODEL_VERSION = "0.2";
    private File cacheLocation;
    private Map<String, ParsingContext> parsingContextCache = new TreeMap<String, ParsingContext>();
    private ObjectMapper objectMapper;
    ClassLoader resourceClassLoader = this.getClass().getClassLoader();

    public ParsingContextCache(File cacheLocation, ClassLoader classLoader) {
        if (cacheLocation == null) {
            throw new RuntimeException("Cache location is null, aborting!");
        }
        if (!cacheLocation.exists()) {
            if (!cacheLocation.mkdirs()) {
                throw new RuntimeException("Cache location couldn't be created at " + cacheLocation + ", aborting !");
            }
        } else {
            File cacheInfoFile = new File(cacheLocation, "cache-info.json");
            if (!cacheInfoFile.exists()) {
                this.purgeCacheDirectory(cacheLocation);
                this.writeCacheInfo(cacheInfoFile);
            } else {
                String cacheModelVersion = null;
                try {
                    cacheModelVersion = (String)this.getObjectMapper().readValue(cacheInfoFile, String.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (cacheModelVersion == null || !cacheModelVersion.equals(CACHE_MODEL_VERSION)) {
                    this.purgeCacheDirectory(cacheLocation);
                    this.writeCacheInfo(cacheInfoFile);
                }
            }
        }
        this.cacheLocation = cacheLocation;
        if (classLoader != null) {
            this.resourceClassLoader = classLoader;
        }
    }

    public void writeCacheInfo(File cacheInfoFile) {
        try {
            this.getObjectMapper().writeValue(cacheInfoFile, (Object)CACHE_MODEL_VERSION);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing cache info file " + cacheInfoFile + ", aborting !");
        }
    }

    public void purgeCacheDirectory(File cacheLocation) {
        try {
            FileUtils.deleteDirectory((File)cacheLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Error purging cache directory " + cacheLocation, e);
        }
        if (!cacheLocation.mkdirs()) {
            throw new RuntimeException("Cache location couldn't be created at " + cacheLocation + ", aborting !");
        }
    }

    public ParsingContext get(Artifact artifact) {
        ParsingContext parsingContext = this.parsingContextCache.get(MavenAetherHelperUtils.getCoords(artifact));
        if (parsingContext != null) {
            parsingContext.reconnectPackageInfos();
            return parsingContext;
        }
        File artifactJSONFile = new File(this.cacheLocation, MavenAetherHelperUtils.getDiskPath(artifact) + ".json");
        if (!artifactJSONFile.exists()) {
            URL artifactJSONUrl = this.resourceClassLoader.getResource("dependencyCache/" + MavenAetherHelperUtils.getDiskPath(artifact) + ".json");
            if (artifactJSONUrl == null) {
                return null;
            }
            try {
                parsingContext = (ParsingContext)this.getObjectMapper().readValue(artifactJSONUrl, ParsingContext.class);
                parsingContext.reconnectPackageInfos();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                parsingContext = (ParsingContext)this.getObjectMapper().readValue(artifactJSONFile, ParsingContext.class);
                parsingContext.reconnectPackageInfos();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (parsingContext != null) {
            if (!(artifact.getFile() == null || artifact.getFile().lastModified() == parsingContext.getLastModified() && artifact.getFile().length() == parsingContext.getFileSize() && artifact.getFile().getName().equals(parsingContext.getFileName()) && artifact.getFile().getPath().equals(parsingContext.getFilePath()))) {
                return null;
            }
            this.parsingContextCache.put(MavenAetherHelperUtils.getCoords(artifact), parsingContext);
            return parsingContext;
        }
        return null;
    }

    public ParsingContext put(Artifact artifact, ParsingContext parsingContext) {
        File artifactJSONFile = new File(this.cacheLocation, MavenAetherHelperUtils.getDiskPath(artifact) + ".json");
        if (!artifactJSONFile.getParentFile().exists() && !artifactJSONFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Couldn't create parent directory " + artifactJSONFile.getParentFile() + " to store file " + artifactJSONFile + ", aborting !");
        }
        try {
            parsingContext.setInCache(true);
            this.getObjectMapper().writeValue(artifactJSONFile, (Object)parsingContext);
            ParsingContext previousParsingContext = this.parsingContextCache.put(MavenAetherHelperUtils.getCoords(artifact), parsingContext);
            return previousParsingContext;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        return this.objectMapper;
    }
}

