/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi.models;

import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.utils.version.VersionCleaner;

public class JahiaDepends {
    private String moduleName = "";
    private VersionRange range = null;
    private String parsedString = null;
    private boolean isOptional = false;

    public JahiaDepends(String dependency) {
        this.parsedString = dependency;
        String[] deps = dependency.split("=");
        String string = this.moduleName = StringUtils.isNotBlank((String)deps[0]) ? deps[0].trim() : "";
        if (deps.length > 1 && StringUtils.isNotBlank((String)deps[1])) {
            String rangeStr = deps[1];
            rangeStr = rangeStr.replace(";optional", "");
            boolean bl = this.isOptional = !(rangeStr = rangeStr.replace("optional", "")).equals(deps[1]);
            if (!rangeStr.isEmpty()) {
                this.range = new VersionRange(rangeStr);
            }
        }
    }

    public boolean hasVersion() {
        return StringUtils.isNotEmpty((String)this.getMinVersion()) || StringUtils.isNotEmpty((String)this.getMaxVersion());
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getMinVersion() {
        return this.range != null && this.range.getLow() != null ? this.range.getLow().toString() : "";
    }

    public String getMaxVersion() {
        return this.range != null && this.range.getHigh() != null ? this.range.getHigh().toString() : "";
    }

    public VersionRange getVersionRange() {
        return this.range;
    }

    public boolean inRange(String version) {
        Version v = new Version(JahiaDepends.toOsgiVersion(version));
        return this.range == null || this.range.includes(v);
    }

    public String toFilterString() {
        String verFilter = this.range != null ? this.range.toFilter() : "";
        verFilter = verFilter.replace("version", "moduleVersion");
        String filter = String.format("(%s=%s)", "moduleIdentifier", this.moduleName);
        if (!verFilter.isEmpty()) {
            filter = verFilter.startsWith("(&") ? verFilter.replace("&", "&" + filter) : String.format("(&%s%s)", filter, verFilter);
        }
        return filter;
    }

    public static JahiaDepends parse(String dependency) {
        return new JahiaDepends(dependency);
    }

    public static String toOsgiVersion(String version) {
        return VersionCleaner.clean((String)version);
    }

    public static boolean isOpenClause(String clause) {
        return StringUtils.isNotBlank((String)clause) && (clause.trim().startsWith("[") || clause.trim().startsWith("("));
    }

    public String toString() {
        return this.parsedString;
    }
}

