/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class JavaScriptDictionaryMojo
extends AbstractMojo {
    protected boolean addToProjectResources;
    protected File base;
    protected File dest;
    protected String dictionaryName;
    protected String languages;
    protected boolean prettyPrint;
    protected MavenProject project;
    protected boolean quoteKeys;
    protected String resourceBundle;
    protected File src;
    protected String targetDirName;
    protected String targetFileName;

    protected static String escape(String value) {
        StringBuilder out = new StringBuilder(value.length() * 2);
        int sz = value.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = value.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u" + JavaScriptDictionaryMojo.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0" + JavaScriptDictionaryMojo.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00" + JavaScriptDictionaryMojo.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + JavaScriptDictionaryMojo.hex(ch));
                            break;
                        }
                        out.append("\\u000" + JavaScriptDictionaryMojo.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block13;
                }
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block13;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block13;
                }
                case '/': {
                    out.append('\\');
                    out.append('/');
                    continue block13;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    protected static String getValue(ResourceBundle bundle, String key) {
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    protected static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ResourceBundle lookupBundle(File src, String resourceBundle, String ... locales) throws IOException {
        PropertyResourceBundle rb = null;
        for (String locale : locales) {
            File f = new File(src, resourceBundle + "_" + locale + ".properties");
            if (!f.exists()) continue;
            FileInputStream is = null;
            try {
                is = FileUtils.openInputStream((File)f);
                rb = new PropertyResourceBundle(is);
                break;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return rb;
    }

    protected void convert(String locale) throws IOException {
        ResourceBundle bundle;
        ResourceBundle defBundle = this.lookupBundle("", "en");
        if (defBundle == null) {
            throw new FileNotFoundException("ERROR : Couldn't find bundle with name " + this.resourceBundle + ".properties nor " + this.resourceBundle + "_en.properties in " + this.src + " folder, skipping...");
        }
        ResourceBundle resourceBundle = bundle = locale != null ? this.lookupBundle(locale) : null;
        if (!this.dest.exists() && !this.dest.mkdirs()) {
            throw new IOException("Unable to create folder " + this.dest);
        }
        File target = new File(this.dest, this.targetFileName + (locale != null ? "_" + locale : "") + ".js");
        this.getLog().info((CharSequence)("Creating " + target + " ..."));
        PrintWriter out = new PrintWriter(target);
        Enumeration<String> keyEnum = defBundle.getKeys();
        LinkedList<String> keys = new LinkedList<String>();
        while (keyEnum.hasMoreElements()) {
            keys.add(keyEnum.nextElement());
        }
        Collections.sort(keys);
        out.print("var ");
        out.print(this.dictionaryName);
        out.print("={");
        if (this.prettyPrint) {
            out.println();
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String value;
            String key = (String)iterator.next();
            String string = value = bundle != null ? JavaScriptDictionaryMojo.getValue(bundle, key) : null;
            if (value == null) {
                value = JavaScriptDictionaryMojo.getValue(defBundle, key);
            }
            if (value == null) continue;
            if (this.quoteKeys) {
                out.append("\"");
            }
            out.append(this.processKey(key));
            if (this.quoteKeys) {
                out.append("\"");
            }
            out.append(":\"").append(this.processValue(value)).append("\"");
            if (iterator.hasNext()) {
                out.append(",");
            }
            if (!this.prettyPrint) continue;
            out.println();
        }
        out.print("};");
        if (this.prettyPrint) {
            out.println();
        }
        out.flush();
        out.close();
        this.getLog().info((CharSequence)"done");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        this.getLog().info((CharSequence)("Converting resource bundle " + this.resourceBundle + " into JavaScript files..."));
        try {
            this.getLog().info((CharSequence)"...no locale (default file)");
            this.convert(null);
            for (String lc : StringUtils.split((String)this.languages, (String)" ,")) {
                String l = lc.trim();
                this.getLog().info((CharSequence)("...locale " + l));
                this.convert(l);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.getLog().info((CharSequence)"...conversion done.");
        if (this.addToProjectResources && this.dest.isDirectory()) {
            Resource resource = new Resource();
            resource.setDirectory(this.base.getPath());
            this.project.addResource(resource);
        }
    }

    protected void init() {
        this.base = new File(this.project.getBuild().getDirectory(), "i18n2js");
        this.dest = new File(this.base, this.targetDirName != null && this.targetDirName.length() > 0 ? this.targetDirName : "javascript");
        if (this.resourceBundle == null && new File(this.src, this.project.getArtifactId() + "_en.properties").isFile()) {
            this.resourceBundle = this.project.getArtifactId();
        }
        if (this.resourceBundle == null) {
            throw new IllegalArgumentException("No resource bundle file for conversion specified");
        }
        if (this.targetFileName == null) {
            this.targetFileName = this.project.getArtifactId() + "-i18n";
        }
    }

    protected ResourceBundle lookupBundle(String ... locales) throws IOException {
        return JavaScriptDictionaryMojo.lookupBundle(this.src, this.resourceBundle, locales);
    }

    protected String processKey(String key) {
        return key;
    }

    protected String processValue(String value) {
        return JavaScriptDictionaryMojo.escape(value);
    }
}

