/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.portal.identity.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

import org.jboss.security.auth.spi.DatabaseServerLoginModule;

/**
 * @author <a href="mailto:boleslaw dot dawidowicz at jboss.org">Boleslaw Dawidowicz</a>
 * @version $Revision: 1.1 $
 */
public class DBIdentityLoginModule extends DatabaseServerLoginModule
{
   private String additionalRole;

   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
   {
      super.initialize(subject, callbackHandler, sharedState, options);

      // Get data
      additionalRole = (String)options.get("additionalRole");

      // Some info
      log.trace("additionalRole = " + additionalRole);
   }


   protected Group[] getRoleSets() throws LoginException
   {
      Group[] rolesGroup =  super.getRoleSets();
      if (additionalRole != null)
      {
         try
         {
            for (int i = 0; i < rolesGroup.length; i++)
            {
               Group group = rolesGroup[i];
               if (group.getName().equals("Roles"))
               {
                  group.addMember(createIdentity(additionalRole));
               }
            }
         }
         catch (Exception e)
         {
            //just a try
            log.error("Error when adding additional role: ", e);
         }
      }
      return rolesGroup; 
   }

   /** Subclass to use the PortalPrincipal to make the username easier to retrieve by the portal. */
   protected Principal createIdentity(String username) throws Exception
   {
      return new UserPrincipal(username);
   }
}
