/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.validation;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;

public class ResteasyViolationException
extends WebApplicationException {
    private static final long serialVersionUID = 2623733139912277260L;
    private ViolationsContainer container;
    private List<String> allExceptions;
    private List<String> fieldViolations = new ArrayList<String>();
    private List<String> propertyViolations = new ArrayList<String>();
    private List<String> classViolations = new ArrayList<String>();
    private List<String> parameterViolations = new ArrayList<String>();
    private List<String> returnValueViolations = new ArrayList<String>();

    public ResteasyViolationException() {
        super(500);
    }

    public ResteasyViolationException(ViolationsContainer<?> container) {
        super(500);
        this.container = container;
    }

    public void setExceptions(List<String> exceptions) {
        this.allExceptions = exceptions;
    }

    public List<String> getExceptions() {
        if (this.allExceptions == null) {
            this.allExceptions = new ArrayList<String>();
            this.allExceptions.addAll(this.fieldViolations);
            this.allExceptions.addAll(this.propertyViolations);
            this.allExceptions.addAll(this.classViolations);
            this.allExceptions.addAll(this.parameterViolations);
            this.allExceptions.addAll(this.returnValueViolations);
        }
        return this.allExceptions;
    }

    public List<String> getFieldViolations() {
        return this.fieldViolations;
    }

    public List<String> getPropertyViolations() {
        return this.propertyViolations;
    }

    public List<String> getClassViolations() {
        return this.classViolations;
    }

    public List<String> getParameterViolations() {
        return this.parameterViolations;
    }

    public List<String> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public int size() {
        return this.fieldViolations.size() + this.propertyViolations.size() + this.classViolations.size() + this.parameterViolations.size() + this.returnValueViolations.size();
    }

    protected ViolationsContainer getViolationsContainer() {
        return this.container;
    }

    protected void setViolationsContainer(ViolationsContainer container) {
        this.container = container;
    }

    protected void convertToStrings() {
        for (ConstraintViolation cv : this.container.getFieldViolations()) {
            this.fieldViolations.add(cv.getMessage() + "; " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getPropertyViolations()) {
            this.propertyViolations.add(cv.getMessage() + "; " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getClassViolations()) {
            this.classViolations.add(cv.getMessage() + "; " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getParameterViolations()) {
            this.parameterViolations.add(cv.getMessage() + "; " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getReturnValueViolations()) {
            this.returnValueViolations.add(cv.getMessage() + "; " + cv.getInvalidValue().toString());
        }
    }

    protected String expandDelimiter(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (s.charAt(i) != ':') continue;
            sb.append(':');
        }
        return sb.toString();
    }

    protected String contractDelimiter(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (s.charAt(i) != ':' || s.charAt(i + 1) != ':') continue;
            ++i;
        }
        return sb.toString();
    }
}

