/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class RFC822NameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;

    public RFC822NameAttribute(String value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        String[] parts = value.split("@");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid RFC822Name: " + value);
        }
        this.value = parts[0] + "@" + parts[1].toLowerCase();
    }

    public static RFC822NameAttribute getInstance(Node root) {
        return RFC822NameAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static RFC822NameAttribute getInstance(String value) {
        return new RFC822NameAttribute(value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RFC822NameAttribute)) {
            return false;
        }
        RFC822NameAttribute other = (RFC822NameAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String encode() {
        return this.value;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

