/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reflections {
    private Reflections() {
    }

    public static <T> T newInstance(String className) {
        try {
            return Reflections.classForName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate instance of " + className + " with no-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate instance of " + className + " with no-argument constructor", e);
        }
    }

    public static <T> Class<T> classForName(String name) {
        try {
            Class<?> c;
            if (Thread.currentThread().getContextClassLoader() != null) {
                Class<?> c2;
                Class<?> clazz = c2 = Thread.currentThread().getContextClassLoader().loadClass(name);
                return clazz;
            }
            Class<?> clazz = c = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load class for " + name, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Cannot load class for " + name, e);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... args) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Field findDeclaredField(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static <T> T invokeMethod(Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex.getCause());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), e);
        }
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append((i > 0 ? "," : "") + args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildSetFieldValueErrorMessage(field, instance, value), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildSetFieldValueErrorMessage(field, instance, value));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
    }

    private static String buildSetFieldValueErrorMessage(Field field, Object obj, Object value) {
        return String.format("Exception setting [%s] field on object [%s] to value [%s]", field.getName(), obj, value);
    }

    private static String buildGetFieldValueErrorMessage(Field field, Object obj) {
        return String.format("Exception reading [%s] field from object [%s].", field.getName(), obj);
    }

    public static <T> T getFieldValue(Field field, Object instance, Class<T> expectedType) {
        field.setAccessible(true);
        try {
            return expectedType.cast(field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Reflections.buildGetFieldValueErrorMessage(field, instance), e);
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildGetFieldValueErrorMessage(field, instance));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
    }

    public static ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return Reflections.class.getClassLoader();
    }
}

