/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.Map;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectSaveable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectAction
implements Action,
StaplerProxy {
    public static final String URL_NAME = "injectedEnvVars";
    protected transient Map<String, String> envMap;
    private AbstractBuild build;
    private transient Map<String, String> resultVariables;
    private transient File rootDir;

    public EnvInjectAction(AbstractBuild build, Map<String, String> envMap) {
        this.build = build;
        this.envMap = envMap;
    }

    public void overrideAll(Map<String, String> all) {
        this.envMap.putAll(all);
    }

    public Map<String, String> getEnvMap() {
        return UnmodifiableMap.decorate(this.envMap);
    }

    public String getIconFileName() {
        return "document-properties.gif";
    }

    public String getDisplayName() {
        return "Injected Environment Variables";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            EnvInjectSaveable dao = new EnvInjectSaveable();
            if (this.rootDir == null) {
                dao.saveEnvironment(this.build.getRootDir(), this.envMap);
                return this;
            }
            dao.saveEnvironment(this.rootDir, this.envMap);
            return this;
        }
        catch (EnvInjectException e) {
            throw new ObjectStreamException(e.getMessage()){};
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.resultVariables != null) {
            this.envMap = this.resultVariables;
            return this;
        }
        EnvInjectSaveable dao = new EnvInjectSaveable();
        Map<String, String> resultMap = null;
        try {
            if (this.build != null) {
                resultMap = dao.getEnvironment(this.build.getRootDir());
            } else if (this.rootDir != null) {
                resultMap = dao.getEnvironment(this.rootDir);
            }
            if (resultMap != null) {
                this.envMap = resultMap;
            }
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Object getTarget() {
        throw new UnsupportedOperationException();
    }
}

