/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject.service;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectActionRetriever;
import org.jenkinsci.lib.envinject.service.EnvInjectDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvVarsResolver
implements Serializable {
    public Map<String, String> getPollingEnvVars(AbstractProject project, Node node) throws EnvInjectException {
        EnvInjectDetector detector;
        if (project == null) {
            throw new NullPointerException("A project object must be set.");
        }
        if (node == null) {
            throw new NullPointerException("A node must be set.");
        }
        Run lastBuild = project.getLastBuild();
        if (lastBuild != null && (detector = new EnvInjectDetector()).isEnvInjectPluginInstalled()) {
            return this.getEnVars((AbstractBuild)lastBuild);
        }
        return this.getDefaultEnvVarsJob(project, node);
    }

    public Map<String, String> getEnVars(AbstractBuild build) throws EnvInjectException {
        if (build == null) {
            throw new NullPointerException("A build object must be set.");
        }
        EnvInjectActionRetriever envInjectActionRetriever = new EnvInjectActionRetriever();
        Action envInjectAction = envInjectActionRetriever.getEnvInjectAction(build);
        if (envInjectAction != null) {
            try {
                Method method = envInjectAction.getClass().getMethod("getEnvMap", new Class[0]);
                return (Map)method.invoke((Object)envInjectAction, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new EnvInjectException(e);
            }
            catch (InvocationTargetException e) {
                throw new EnvInjectException(e);
            }
            catch (IllegalAccessException e) {
                throw new EnvInjectException(e);
            }
        }
        return this.getDefaultEnvVarsJob(build.getProject(), build.getBuiltOn());
    }

    public String resolveEnvVars(AbstractBuild build, String value) throws EnvInjectException {
        if (build == null) {
            throw new NullPointerException("A build object must be set.");
        }
        if (value == null) {
            return null;
        }
        return Util.replaceMacro((String)value, this.getEnVars(build));
    }

    private Map<String, String> getDefaultEnvVarsJob(AbstractProject project, Node node) throws EnvInjectException {
        assert (project != null);
        assert (node != null);
        assert (node.getRootPath() != null);
        Map<String, String> result = this.gatherEnvVarsMaster(project);
        result.putAll(this.gatherEnvVarsNode(project, node));
        result.putAll(this.gatherEnvVarsNodeProperties());
        return result;
    }

    private Map<String, String> gatherEnvVarsMaster(AbstractProject project) throws EnvInjectException {
        assert (project != null);
        EnvVars env = new EnvVars();
        env.put("JENKINS_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + Hudson.getInstance().getSecretKey())));
        env.put("HUDSON_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + Hudson.getInstance().getSecretKey())));
        env.put("JOB_NAME", project.getFullName());
        env.put("JENKINS_HOME", Hudson.getInstance().getRootDir().getPath());
        env.put("HUDSON_HOME", Hudson.getInstance().getRootDir().getPath());
        return env;
    }

    private Map<String, String> gatherEnvVarsNodeProperties() throws EnvInjectException {
        EnvVars env = new EnvVars();
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            env.putAll((Map)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        for (NodeProperty nodeProperty : Computer.currentComputer().getNode().getNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            env.putAll((Map)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        return env;
    }

    private Map<String, String> gatherEnvVarsNode(AbstractProject project, Node node) throws EnvInjectException {
        assert (project != null);
        assert (node != null);
        assert (node.getRootPath() != null);
        try {
            Map envVars = (Map)node.getRootPath().act((Callable)new Callable<Map<String, String>, EnvInjectException>(){

                public Map<String, String> call() throws EnvInjectException {
                    return EnvVars.masterEnvVars;
                }
            });
            envVars.put("NODE_NAME", node.getNodeName());
            envVars.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            FilePath wFilePath = project.getSomeWorkspace();
            if (wFilePath != null) {
                envVars.put("WORKSPACE", wFilePath.getRemote());
            }
            return envVars;
        }
        catch (IOException ioe) {
            throw new EnvInjectException(ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException(ie);
        }
    }
}

