/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.client;

import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolConfig {
    private static final int DEFAULT_CORE_POOL_SIZE = 1;
    private static final int DEFAULT_MAX_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 20);
    private static final int DEFAULT_MAX_QUEUE_SIZE = -1;
    private static final int DEFAULT_IDLE_THREAD_KEEP_ALIVE_TIMEOUT = 10;
    private static final ThreadPoolConfig DEFAULT = new ThreadPoolConfig("Tyrus-client", 1, DEFAULT_MAX_POOL_SIZE, null, -1, 10L, TimeUnit.SECONDS, null, 5, true, null);
    private String poolName;
    private int corePoolSize;
    private int maxPoolSize;
    private Queue<Runnable> queue;
    private int queueLimit = -1;
    private long keepAliveTimeMillis;
    private ThreadFactory threadFactory;
    private int priority = 10;
    private boolean isDaemon;
    private ClassLoader initialClassLoader;

    public static ThreadPoolConfig defaultConfig() {
        return DEFAULT.copy();
    }

    private ThreadPoolConfig(String poolName, int corePoolSize, int maxPoolSize, Queue<Runnable> queue, int queueLimit, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, int priority, boolean isDaemon, ClassLoader initialClassLoader) {
        this.poolName = poolName;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.queue = queue;
        this.queueLimit = queueLimit;
        this.keepAliveTimeMillis = keepAliveTime > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTime, timeUnit) : keepAliveTime;
        this.threadFactory = threadFactory;
        this.priority = priority;
        this.isDaemon = isDaemon;
        this.initialClassLoader = initialClassLoader;
    }

    private ThreadPoolConfig(ThreadPoolConfig cfg) {
        this.queue = cfg.queue;
        this.threadFactory = cfg.threadFactory;
        this.poolName = cfg.poolName;
        this.priority = cfg.priority;
        this.isDaemon = cfg.isDaemon;
        this.maxPoolSize = cfg.maxPoolSize;
        this.queueLimit = cfg.queueLimit;
        this.corePoolSize = cfg.corePoolSize;
        this.keepAliveTimeMillis = cfg.keepAliveTimeMillis;
        this.initialClassLoader = cfg.initialClassLoader;
    }

    public ThreadPoolConfig copy() {
        return new ThreadPoolConfig(this);
    }

    public Queue<Runnable> getQueue() {
        return this.queue;
    }

    public ThreadPoolConfig setQueue(Queue<Runnable> queue) {
        this.queue = queue;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ThreadPoolConfig setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public ThreadPoolConfig setPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ThreadPoolConfig setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public ThreadPoolConfig setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ThreadPoolConfig setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 3) {
            throw new IllegalArgumentException("Max thread pool size cannot be smaller than 3");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public ThreadPoolConfig setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("Core thread pool size cannot be smaller than 0");
        }
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getQueueLimit() {
        return this.queueLimit;
    }

    public ThreadPoolConfig setQueueLimit(int queueLimit) {
        this.queueLimit = queueLimit < 0 ? -1 : queueLimit;
        return this;
    }

    public ThreadPoolConfig setKeepAliveTime(long time, TimeUnit unit) {
        this.keepAliveTimeMillis = time < 0L ? -1L : TimeUnit.MILLISECONDS.convert(time, unit);
        return this;
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        if (this.keepAliveTimeMillis == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.keepAliveTimeMillis, TimeUnit.MILLISECONDS);
    }

    public ClassLoader getInitialClassLoader() {
        return this.initialClassLoader;
    }

    public ThreadPoolConfig setInitialClassLoader(ClassLoader initialClassLoader) {
        this.initialClassLoader = initialClassLoader;
        return this;
    }

    public String toString() {
        return ThreadPoolConfig.class.getSimpleName() + " :\r\n" + "  poolName: " + this.poolName + "\r\n" + "  corePoolSize: " + this.corePoolSize + "\r\n" + "  maxPoolSize: " + this.maxPoolSize + "\r\n" + "  queue: " + (this.queue != null ? this.queue.getClass() : "undefined") + "\r\n" + "  queueLimit: " + this.queueLimit + "\r\n" + "  keepAliveTime (millis): " + this.keepAliveTimeMillis + "\r\n" + "  threadFactory: " + this.threadFactory + "\r\n" + "  priority: " + this.priority + "\r\n" + "  isDaemon: " + this.isDaemon + "\r\n" + "  initialClassLoader: " + this.initialClassLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadPoolConfig that = (ThreadPoolConfig)o;
        if (this.corePoolSize != that.corePoolSize) {
            return false;
        }
        if (this.isDaemon != that.isDaemon) {
            return false;
        }
        if (this.keepAliveTimeMillis != that.keepAliveTimeMillis) {
            return false;
        }
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.queueLimit != that.queueLimit) {
            return false;
        }
        if (this.initialClassLoader != null ? !this.initialClassLoader.equals(that.initialClassLoader) : that.initialClassLoader != null) {
            return false;
        }
        if (this.poolName != null ? !this.poolName.equals(that.poolName) : that.poolName != null) {
            return false;
        }
        if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) {
            return false;
        }
        return !(this.threadFactory != null ? !this.threadFactory.equals(that.threadFactory) : that.threadFactory != null);
    }

    public int hashCode() {
        int result = this.poolName != null ? this.poolName.hashCode() : 0;
        result = 31 * result + this.corePoolSize;
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
        result = 31 * result + this.queueLimit;
        result = 31 * result + (int)(this.keepAliveTimeMillis ^ this.keepAliveTimeMillis >>> 32);
        result = 31 * result + (this.threadFactory != null ? this.threadFactory.hashCode() : 0);
        result = 31 * result + this.priority;
        result = 31 * result + (this.isDaemon ? 1 : 0);
        result = 31 * result + (this.initialClassLoader != null ? this.initialClassLoader.hashCode() : 0);
        return result;
    }
}

