/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.certificate;

import io.jenkins.cli.shaded.org.apache.sshd.common.BaseBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificateImpl;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyPairProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.random.JceRandom;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.BuiltinSignatures;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenSshCertificateBuilder {
    protected static final Map<String, String> SIGNATURE_ALGORITHM_MAP = ((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)MapEntryUtils.MapBuilder.builder().put("ssh-rsa", "ssh-rsa-cert-v01@openssh.com")).put("ssh-ed25519", "ssh-ed25519-cert-v01@openssh.com")).put(KeyPairProvider.ECDSA_SHA2_NISTP256, "ecdsa-sha2-nistp256-cert-v01@openssh.com")).put(KeyPairProvider.ECDSA_SHA2_NISTP384, "ecdsa-sha2-nistp384-cert-v01@openssh.com")).put(KeyPairProvider.ECDSA_SHA2_NISTP521, "ecdsa-sha2-nistp521-cert-v01@openssh.com")).build();
    protected final OpenSshCertificate.Type type;
    protected PublicKey publicKey;
    protected long serial;
    protected String id;
    protected Collection<String> principals;
    protected List<OpenSshCertificate.CertificateOption> criticalOptions;
    protected List<OpenSshCertificate.CertificateOption> extensions;
    protected long validAfter = 0L;
    protected long validBefore = -1L;
    protected byte[] nonce;

    protected OpenSshCertificateBuilder(OpenSshCertificate.Type type) {
        this.type = type;
    }

    public static OpenSshCertificateBuilder userCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate.Type.USER);
    }

    public static OpenSshCertificateBuilder hostCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate.Type.HOST);
    }

    public OpenSshCertificateBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public OpenSshCertificateBuilder serial(long serial) {
        this.serial = serial;
        return this;
    }

    public OpenSshCertificateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public OpenSshCertificateBuilder principals(Collection<String> principals) {
        this.principals = principals;
        return this;
    }

    public OpenSshCertificateBuilder criticalOptions(List<OpenSshCertificate.CertificateOption> criticalOptions) {
        this.validateOptions(criticalOptions);
        this.criticalOptions = this.lexicallyOrderOptions(criticalOptions);
        return this;
    }

    public OpenSshCertificateBuilder extensions(List<OpenSshCertificate.CertificateOption> extensions) {
        this.validateOptions(extensions);
        this.extensions = this.lexicallyOrderOptions(extensions);
        return this;
    }

    public OpenSshCertificateBuilder validAfter(long validAfter) {
        this.validAfter = validAfter;
        return this;
    }

    public OpenSshCertificateBuilder nonce(byte[] nonce) {
        this.nonce = nonce;
        return this;
    }

    public OpenSshCertificateBuilder validAfter(Instant validAfter) {
        if (validAfter == null) {
            return this.validAfter(0L);
        }
        if (Instant.EPOCH.compareTo(validAfter) <= 0) {
            return this.validAfter(validAfter.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-after cannot be < epoch");
    }

    public OpenSshCertificateBuilder validBefore(long validBefore) {
        this.validBefore = validBefore;
        return this;
    }

    public OpenSshCertificateBuilder validBefore(Instant validBefore) {
        if (validBefore == null) {
            return this.validBefore(-1L);
        }
        if (Instant.EPOCH.compareTo(validBefore) <= 0) {
            return this.validBefore(validBefore.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-before cannot be < epoch");
    }

    protected void validate() {
        if (this.nonce != null && this.nonce.length != 16 && this.nonce.length != 32) {
            throw new IllegalStateException("'nonce' must be 16 or 32 bytes");
        }
        if (this.type == null) {
            throw new IllegalStateException("'type' is required");
        }
        if (this.id == null) {
            throw new IllegalStateException("'id' is required");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("'publicKey' is required");
        }
    }

    public OpenSshCertificate sign(KeyPair caKeypair) throws Exception {
        return this.sign(caKeypair, null);
    }

    public OpenSshCertificate sign(KeyPair caKeypair, String signatureAlgorithm) throws Exception {
        BuiltinSignatures factory;
        this.validate();
        String publicKeyType = KeyUtils.getKeyType(this.publicKey);
        String certType = SIGNATURE_ALGORITHM_MAP.get(publicKeyType);
        if (certType == null) {
            throw new UnsupportedOperationException("unsupported public key type '" + publicKeyType + "' for OpenSSH Certificate");
        }
        OpenSshCertificateImpl cert = new OpenSshCertificateImpl();
        cert.setKeyType(certType);
        cert.setType(this.type);
        cert.setCertPubKey(this.publicKey);
        cert.setSerial(this.serial);
        cert.setId(this.id);
        if (this.principals != null && !this.principals.isEmpty()) {
            cert.setPrincipals(new ArrayList<String>(this.principals));
        }
        if (this.criticalOptions != null && !this.criticalOptions.isEmpty()) {
            cert.setCriticalOptions(new ArrayList<OpenSshCertificate.CertificateOption>(this.criticalOptions));
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            cert.setExtensions(new ArrayList<OpenSshCertificate.CertificateOption>(this.extensions));
        }
        cert.setValidAfter(this.validAfter);
        cert.setValidBefore(this.validBefore);
        cert.setCaPubKey(caKeypair.getPublic());
        if (this.nonce != null) {
            cert.setNonce(this.nonce);
        } else {
            SecureRandom rand = JceRandom.getGlobalInstance();
            byte[] tempNonce = new byte[32];
            rand.nextBytes(tempNonce);
            cert.setNonce(tempNonce);
        }
        String algo = KeyUtils.getKeyType(caKeypair.getPublic());
        if (signatureAlgorithm != null) {
            ValidateUtils.checkTrue(KeyUtils.getAllEquivalentKeyTypes(algo).contains(signatureAlgorithm), "Invalid CA signature algorithm %s for CA key type %s", signatureAlgorithm, algo);
            algo = signatureAlgorithm;
            factory = BuiltinSignatures.fromFactoryName(algo);
        } else {
            factory = SignatureFactory.resolveSignatureFactory(algo, BaseBuilder.DEFAULT_SIGNATURE_PREFERENCE);
        }
        Signature signer = factory == null ? null : (Signature)factory.create();
        ValidateUtils.checkNotNull(signer, "No signer could be located for signature algorithm=%s", (Object)algo);
        ByteArrayBuffer toBeSignedBuf = new ByteArrayBuffer();
        toBeSignedBuf.putRawPublicKey(cert);
        byte[] toSign = toBeSignedBuf.getCompactData();
        signer.initSigner(null, caKeypair.getPrivate());
        signer.update(null, toSign);
        ByteArrayBuffer tmpBuffer = new ByteArrayBuffer();
        tmpBuffer.putString(factory.getName());
        tmpBuffer.putBytes(signer.sign(null));
        cert.setMessage(toSign);
        cert.setSignature(tmpBuffer.getCompactData());
        return cert;
    }

    private void validateOptions(List<OpenSshCertificate.CertificateOption> options) {
        if (options != null && !options.isEmpty()) {
            HashSet names = new HashSet();
            Set duplicates = options.stream().filter(option -> !names.add(option.getName())).map(OpenSshCertificate.CertificateOption::getName).collect(Collectors.toSet());
            if (!duplicates.isEmpty()) {
                throw new IllegalArgumentException("Duplicate option: " + duplicates);
            }
        }
    }

    private List<OpenSshCertificate.CertificateOption> lexicallyOrderOptions(List<OpenSshCertificate.CertificateOption> options) {
        if (options != null && !options.isEmpty()) {
            return options.stream().sorted(Comparator.comparing(OpenSshCertificate.CertificateOption::getName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

