/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.commons.net.ftp.parser;

import hidden.jth.org.apache.commons.net.ftp.FTPClientConfig;
import hidden.jth.org.apache.commons.net.ftp.FTPFile;
import hidden.jth.org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import hidden.jth.org.apache.commons.net.ftp.parser.FTPTimestampParserImpl;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;

public class UnixFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    static final String DEFAULT_DATE_FORMAT = "MMM d yyyy";
    static final String DEFAULT_RECENT_DATE_FORMAT = "MMM d HH:mm";
    static final String NUMERIC_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String JA_MONTH = "\u6708";
    private static final String JA_DAY = "\u65e5";
    private static final String JA_YEAR = "\u5e74";
    private static final String DEFAULT_DATE_FORMAT_JA = "M'\u6708' d'\u65e5' yyyy'\u5e74'";
    private static final String DEFAULT_RECENT_DATE_FORMAT_JA = "M'\u6708' d'\u65e5' HH:mm";
    private static final Pattern TOTAL_PATTERN = Pattern.compile("^total \\d+$");
    public static final FTPClientConfig NUMERIC_DATE_CONFIG = new FTPClientConfig("UNIX", "yyyy-MM-dd HH:mm", null);
    private static final String REGEX = "([bcdelfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\+?\\s*(\\d+)\\s+(?:(\\S+(?:\\s\\S+)*?)\\s+)?(?:(\\S+(?:\\s\\S+)*)\\s+)?(\\d+(?:,\\s*\\d+)?)\\s+((?:\\d+[-/]\\d+[-/]\\d+)|(?:\\S{3}\\s+\\d{1,2})|(?:\\d{1,2}\\s+\\S{3})|(?:\\d{1,2}\u6708\\s+\\d{1,2}\u65e5))\\s+((?:\\d+(?::\\d+)?)|(?:\\d{4}\u5e74))\\s(.*)";
    final boolean trimLeadingSpaces;

    public UnixFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public UnixFTPEntryParser(FTPClientConfig config) {
        this(config, false);
    }

    public UnixFTPEntryParser(FTPClientConfig config, boolean trimLeadingSpaces) {
        super(REGEX);
        this.configure(config);
        this.trimLeadingSpaces = trimLeadingSpaces;
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("UNIX", DEFAULT_DATE_FORMAT, DEFAULT_RECENT_DATE_FORMAT);
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        boolean isDevice = false;
        if (this.matches(entry)) {
            int type;
            String typeStr = this.group(1);
            String hardLinkCount = this.group(15);
            String usr = this.group(16);
            String grp = this.group(17);
            String filesize = this.group(18);
            String datestr = this.group(19) + " " + this.group(20);
            String name = this.group(21);
            if (this.trimLeadingSpaces) {
                name = name.replaceFirst("^\\s+", "");
            }
            try {
                if (this.group(19).contains(JA_MONTH)) {
                    FTPTimestampParserImpl jaParser = new FTPTimestampParserImpl();
                    jaParser.configure(new FTPClientConfig("UNIX", DEFAULT_DATE_FORMAT_JA, DEFAULT_RECENT_DATE_FORMAT_JA));
                    file.setTimestamp(jaParser.parseTimestamp(datestr));
                } else {
                    file.setTimestamp(super.parseTimestamp(datestr));
                }
            }
            catch (ParseException jaParser) {
                // empty catch block
            }
            switch (typeStr.charAt(0)) {
                case 'd': {
                    type = 1;
                    break;
                }
                case 'e': {
                    type = 2;
                    break;
                }
                case 'l': {
                    type = 2;
                    break;
                }
                case 'b': 
                case 'c': {
                    isDevice = true;
                    type = 0;
                    break;
                }
                case '-': 
                case 'f': {
                    type = 0;
                    break;
                }
                default: {
                    type = 3;
                }
            }
            file.setType(type);
            int g = 4;
            int access2 = 0;
            while (access2 < 3) {
                file.setPermission(access2, 0, !this.group(g).equals("-"));
                file.setPermission(access2, 1, !this.group(g + 1).equals("-"));
                String execPerm = this.group(g + 2);
                file.setPermission(access2, 2, !execPerm.equals("-") && !Character.isUpperCase(execPerm.charAt(0)));
                ++access2;
                g += 4;
            }
            if (!isDevice) {
                try {
                    file.setHardLinkCount(Integer.parseInt(hardLinkCount));
                }
                catch (NumberFormatException access2) {
                    // empty catch block
                }
            }
            file.setUser(usr);
            file.setGroup(grp);
            try {
                file.setSize(Long.parseLong(filesize));
            }
            catch (NumberFormatException access2) {
                // empty catch block
            }
            if (type == 2) {
                int end = name.indexOf(" -> ");
                if (end == -1) {
                    file.setName(name);
                } else {
                    file.setName(name.substring(0, end));
                    file.setLink(name.substring(end + 4));
                }
            } else {
                file.setName(name);
            }
            return file;
        }
        return null;
    }

    @Override
    public List<String> preParse(List<String> original) {
        original.removeIf(entry -> TOTAL_PATTERN.matcher((CharSequence)entry).matches());
        return original;
    }
}

