/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.XHtmlPage;
import org.htmlunit.html.xpath.XPathHelper;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.util.StringUtils;

public abstract class DomNamespaceNode
extends DomNode {
    private String namespaceURI_;
    private String qualifiedName_;
    private final String localName_;
    private final String localNameLC_;
    private String prefix_;

    protected DomNamespaceNode(String namespaceURI, String qualifiedName, SgmlPage page) {
        super(page);
        WebAssert.notNull("qualifiedName", qualifiedName);
        this.qualifiedName_ = qualifiedName;
        if (qualifiedName.indexOf(58) == -1) {
            this.namespaceURI_ = namespaceURI;
            this.localName_ = this.qualifiedName_;
            this.prefix_ = null;
        } else {
            this.namespaceURI_ = namespaceURI;
            int colonPosition = this.qualifiedName_.indexOf(58);
            this.localName_ = this.qualifiedName_.substring(colonPosition + 1);
            this.prefix_ = this.qualifiedName_.substring(0, colonPosition);
        }
        this.localNameLC_ = StringUtils.toRootLowerCase(this.localName_);
    }

    @Override
    public String getNamespaceURI() {
        if (this.getPage().isHtmlPage() && !(this.getPage() instanceof XHtmlPage) && "http://www.w3.org/1999/xhtml".equals(this.namespaceURI_) && XPathHelper.isProcessingXPath()) {
            return null;
        }
        return this.namespaceURI_;
    }

    @Override
    public String getLocalName() {
        boolean caseSensitive = this.getPage().hasCaseSensitiveTagNames();
        if (!caseSensitive && XPathHelper.isProcessingXPath()) {
            return this.localNameLC_;
        }
        return this.localName_;
    }

    public String getLowercaseName() {
        return this.localNameLC_;
    }

    @Override
    public String getPrefix() {
        return this.prefix_;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
        if (this.prefix_ != null && this.localName_ != null) {
            this.qualifiedName_ = this.prefix_ + ":" + this.localName_;
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName_;
    }

    @Override
    public void processImportNode(Document doc) {
        super.processImportNode(doc);
        SgmlPage page = (SgmlPage)doc.getDomNodeOrDie();
        if (page.isHtmlPage() && !(page instanceof XHtmlPage) && "http://www.w3.org/1999/xhtml".equals(this.namespaceURI_)) {
            this.namespaceURI_ = null;
        }
    }
}

