/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;

public class HtmlUrlInput
extends HtmlSelectableTextInput
implements LabelableElement {
    HtmlUrlInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlUrlInput.trimValueAttribute(page, attributes));
    }

    private static Map<String, DomAttr> trimValueAttribute(SgmlPage page, Map<String, DomAttr> attributes) {
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            if (!"value".equalsIgnoreCase(entry.getKey())) continue;
            entry.getValue().setValue(entry.getValue().getValue().trim());
            break;
        }
        return attributes;
    }

    @Override
    public String getValue() {
        String raw = this.getRawValue();
        if (StringUtils.isBlank(raw)) {
            return "";
        }
        return raw;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    protected boolean isBlankPatternValidated() {
        return false;
    }

    @Override
    protected boolean isMinMaxLengthSupported() {
        return true;
    }
}

