/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.serializer;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.List;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebWindow;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlBreak;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlDetails;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlMenu;
import org.htmlunit.html.HtmlNoFrames;
import org.htmlunit.html.HtmlNoScript;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlOrderedList;
import org.htmlunit.html.HtmlPreformattedText;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlSummary;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableFooter;
import org.htmlunit.html.HtmlTableHeader;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTitle;
import org.htmlunit.html.HtmlUnorderedList;
import org.htmlunit.html.TableRowGroup;

public class HtmlSerializerVisibleText {
    public String asText(DomNode node) {
        if (node instanceof HtmlBreak) {
            return "";
        }
        HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
        this.appendNode(builder, node, this.whiteSpaceStyle(node, Mode.WHITE_SPACE_NORMAL));
        return builder.getText();
    }

    protected void appendChildren(HtmlSerializerTextBuilder builder, DomNode node, Mode mode) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child, this.updateWhiteSpaceStyle(node, mode));
        }
    }

    protected void appendNode(HtmlSerializerTextBuilder builder, DomNode node, Mode mode) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node, mode);
        } else if (node instanceof DomComment) {
            this.appendComment(builder, (DomComment)node, mode);
        } else if (node instanceof HtmlBreak) {
            this.appendBreak(builder, (HtmlBreak)node, mode);
        } else if (node instanceof HtmlHiddenInput) {
            this.appendHiddenInput(builder, (HtmlHiddenInput)node, mode);
        } else if (node instanceof HtmlScript) {
            this.appendScript(builder, (HtmlScript)node, mode);
        } else if (node instanceof HtmlStyle) {
            this.appendStyle(builder, (HtmlStyle)node, mode);
        } else if (node instanceof HtmlNoFrames) {
            this.appendNoFrames(builder, (HtmlNoFrames)node, mode);
        } else if (node instanceof HtmlTextArea) {
            this.appendTextArea(builder, (HtmlTextArea)node, mode);
        } else if (node instanceof HtmlTitle) {
            this.appendTitle(builder, (HtmlTitle)node, mode);
        } else if (node instanceof HtmlTableRow) {
            this.appendTableRow(builder, (HtmlTableRow)node, mode);
        } else if (node instanceof HtmlSelect) {
            this.appendSelect(builder, (HtmlSelect)node, mode);
        } else if (node instanceof HtmlOption) {
            this.appendOption(builder, (HtmlOption)node, mode);
        } else if (node instanceof HtmlSubmitInput) {
            this.appendSubmitInput(builder, (HtmlSubmitInput)node, mode);
        } else if (node instanceof HtmlResetInput) {
            this.appendResetInput(builder, (HtmlResetInput)node, mode);
        } else if (node instanceof HtmlCheckBoxInput) {
            this.appendCheckBoxInput(builder, (HtmlCheckBoxInput)node, mode);
        } else if (node instanceof HtmlRadioButtonInput) {
            this.appendRadioButtonInput(builder, (HtmlRadioButtonInput)node, mode);
        } else if (!(node instanceof HtmlInput)) {
            if (node instanceof HtmlTable) {
                this.appendTable(builder, (HtmlTable)node, mode);
            } else if (node instanceof HtmlOrderedList) {
                this.appendOrderedList(builder, (HtmlOrderedList)node, mode);
            } else if (node instanceof HtmlUnorderedList) {
                this.appendUnorderedList(builder, (HtmlUnorderedList)node, mode);
            } else if (node instanceof HtmlPreformattedText) {
                this.appendPreformattedText(builder, (HtmlPreformattedText)node, mode);
            } else if (node instanceof HtmlInlineFrame) {
                this.appendInlineFrame(builder, (HtmlInlineFrame)node, mode);
            } else if (node instanceof HtmlMenu) {
                this.appendMenu(builder, (HtmlMenu)node, mode);
            } else if (node instanceof HtmlDetails) {
                this.appendDetails(builder, (HtmlDetails)node, mode);
            } else if (node instanceof HtmlNoScript && node.getPage().getWebClient().isJavaScriptEnabled()) {
                this.appendNoScript(builder, (HtmlNoScript)node, mode);
            } else {
                this.appendDomNode(builder, node, mode);
            }
        }
    }

    protected void appendDomNode(HtmlSerializerTextBuilder builder, DomNode domNode, Mode mode) {
        boolean block;
        if (domNode instanceof HtmlBody) {
            block = false;
        } else if (domNode instanceof DomElement) {
            WebWindow window = domNode.getPage().getEnclosingWindow();
            String display = window.getComputedStyle((DomElement)domNode, null).getDisplay();
            block = "block".equals(display);
        } else {
            block = false;
        }
        if (block) {
            builder.appendBlockSeparator();
        }
        this.appendChildren(builder, domNode, mode);
        if (block) {
            builder.appendBlockSeparator();
        }
    }

    protected void appendHiddenInput(HtmlSerializerTextBuilder builder, HtmlHiddenInput htmlHiddenInput, Mode mode) {
    }

    protected void appendScript(HtmlSerializerTextBuilder builder, HtmlScript htmlScript, Mode mode) {
    }

    protected void appendStyle(HtmlSerializerTextBuilder builder, HtmlStyle htmlStyle, Mode mode) {
    }

    protected void appendNoScript(HtmlSerializerTextBuilder builder, HtmlNoScript htmlNoScript, Mode mode) {
    }

    protected void appendNoFrames(HtmlSerializerTextBuilder builder, HtmlNoFrames htmlNoFrames, Mode mode) {
    }

    protected void appendSubmitInput(HtmlSerializerTextBuilder builder, HtmlSubmitInput htmlSubmitInput, Mode mode) {
    }

    protected void appendInput(HtmlSerializerTextBuilder builder, HtmlInput htmlInput, Mode mode) {
        builder.append(htmlInput.getValueAttribute(), mode);
    }

    protected void appendResetInput(HtmlSerializerTextBuilder builder, HtmlResetInput htmlResetInput, Mode mode) {
    }

    protected void appendMenu(HtmlSerializerTextBuilder builder, HtmlMenu htmlMenu, Mode mode) {
        builder.appendBlockSeparator();
        boolean first = true;
        for (DomNode item : htmlMenu.getChildren()) {
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendNode(builder, item, mode);
        }
        builder.appendBlockSeparator();
    }

    protected void appendDetails(HtmlSerializerTextBuilder builder, HtmlDetails htmlDetails, Mode mode) {
        if (htmlDetails.isOpen()) {
            this.appendChildren(builder, htmlDetails, mode);
            return;
        }
        for (DomNode child : htmlDetails.getChildren()) {
            if (!(child instanceof HtmlSummary)) continue;
            this.appendNode(builder, child, mode);
        }
    }

    protected void appendTitle(HtmlSerializerTextBuilder builder, HtmlTitle htmlTitle, Mode mode) {
    }

    protected void appendTableRow(HtmlSerializerTextBuilder builder, HtmlTableRow htmlTableRow, Mode mode) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                builder.appendBlank();
            } else {
                first = false;
            }
            this.appendChildren(builder, cell, mode);
        }
    }

    protected boolean isDisplayed(DomNode domNode) {
        return domNode.isDisplayed();
    }

    protected void appendTextArea(HtmlSerializerTextBuilder builder, HtmlTextArea htmlTextArea, Mode mode) {
        if (this.isDisplayed(htmlTextArea)) {
            builder.append(htmlTextArea.getDefaultValue(), this.whiteSpaceStyle(htmlTextArea, Mode.PRE));
            builder.trimRight(Mode.PRE);
        }
    }

    protected void appendTable(HtmlSerializerTextBuilder builder, HtmlTable htmlTable, Mode mode) {
        DomNode firstChild;
        builder.appendBlockSeparator();
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            builder.append(caption, mode);
            builder.appendBlockSeparator();
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendTableRows(builder, mode, tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        List<HtmlTableRow> tableRows = htmlTable.getRows();
        first = this.appendTableRows(builder, mode, tableRows, first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendTableRows(builder, mode, tableFooter.getRows(), first, null, null);
        } else if (tableRows.isEmpty() && (firstChild = htmlTable.getFirstChild()) != null) {
            this.appendNode(builder, firstChild, mode);
        }
        builder.appendBlockSeparator();
    }

    protected boolean appendTableRows(HtmlSerializerTextBuilder builder, Mode mode, List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendTableRow(builder, row, mode);
        }
        return first;
    }

    protected void appendSelect(HtmlSerializerTextBuilder builder, HtmlSelect htmlSelect, Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        Mode selectMode = this.whiteSpaceStyle(htmlSelect, mode);
        for (DomNode item : htmlSelect.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, this.whiteSpaceStyle(item, selectMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendOption(HtmlSerializerTextBuilder builder, HtmlOption htmlOption, Mode mode) {
        builder.ignoreHtmlBreaks();
        this.appendChildren(builder, htmlOption, mode);
        builder.processHtmlBreaks();
    }

    protected void appendOrderedList(HtmlSerializerTextBuilder builder, HtmlOrderedList htmlOrderedList, Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        Mode olMode = this.whiteSpaceStyle(htmlOrderedList, mode);
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, this.whiteSpaceStyle(item, olMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendUnorderedList(HtmlSerializerTextBuilder builder, HtmlUnorderedList htmlUnorderedList, Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        Mode ulMode = this.whiteSpaceStyle(htmlUnorderedList, mode);
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, this.whiteSpaceStyle(item, ulMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendPreformattedText(HtmlSerializerTextBuilder builder, HtmlPreformattedText htmlPreformattedText, Mode mode) {
        if (this.isDisplayed(htmlPreformattedText)) {
            builder.appendBlockSeparator();
            this.appendChildren(builder, htmlPreformattedText, this.whiteSpaceStyle(htmlPreformattedText, Mode.PRE));
            builder.appendBlockSeparator();
        }
    }

    protected void appendInlineFrame(HtmlSerializerTextBuilder builder, HtmlInlineFrame htmlInlineFrame, Mode mode) {
        if (this.isDisplayed(htmlInlineFrame)) {
            builder.appendBlockSeparator();
            Page page = htmlInlineFrame.getEnclosedPage();
            if (page instanceof SgmlPage) {
                builder.append(((SgmlPage)page).asNormalizedText(), mode);
            }
            builder.appendBlockSeparator();
        }
    }

    protected void appendText(HtmlSerializerTextBuilder builder, DomText domText, Mode mode) {
        DomNode parent = domText.getParentNode();
        if (parent instanceof HtmlTitle || parent instanceof HtmlScript) {
            builder.append(domText.getData(), Mode.WHITE_SPACE_PRE_LINE);
        }
        if (parent == null || parent instanceof HtmlTitle || parent instanceof HtmlScript || this.isDisplayed(parent)) {
            builder.append(domText.getData(), mode);
        }
    }

    protected void appendComment(HtmlSerializerTextBuilder builder, DomComment domComment, Mode mode) {
    }

    protected void appendBreak(HtmlSerializerTextBuilder builder, HtmlBreak htmlBreak, Mode mode) {
        builder.appendBreak(mode);
    }

    protected void appendCheckBoxInput(HtmlSerializerTextBuilder builder, HtmlCheckBoxInput htmlCheckBoxInput, Mode mode) {
    }

    protected void appendRadioButtonInput(HtmlSerializerTextBuilder builder, HtmlRadioButtonInput htmlRadioButtonInput, Mode mode) {
    }

    protected Mode whiteSpaceStyle(DomNode domNode, Mode defaultMode) {
        WebWindow window;
        SgmlPage page = domNode.getPage();
        if (page != null && (window = page.getEnclosingWindow()).getWebClient().getOptions().isCssEnabled()) {
            for (DomNode node = domNode; node != null; node = node.getParentNode()) {
                ComputedCssStyleDeclaration style;
                String value;
                if (!(node instanceof DomElement) || !StringUtils.isNoneEmpty(value = (style = window.getComputedStyle((DomElement)node, null)).getStyleAttribute(StyleAttributes.Definition.WHITE_SPACE, false))) continue;
                if ("normal".equalsIgnoreCase(value)) {
                    return Mode.WHITE_SPACE_NORMAL;
                }
                if ("nowrap".equalsIgnoreCase(value)) {
                    return Mode.WHITE_SPACE_NORMAL;
                }
                if ("pre".equalsIgnoreCase(value)) {
                    return Mode.WHITE_SPACE_PRE;
                }
                if ("pre-wrap".equalsIgnoreCase(value)) {
                    return Mode.WHITE_SPACE_PRE;
                }
                if (!"pre-line".equalsIgnoreCase(value)) continue;
                return Mode.WHITE_SPACE_PRE_LINE;
            }
        }
        return defaultMode;
    }

    protected Mode updateWhiteSpaceStyle(DomNode domNode, Mode defaultMode) {
        ComputedCssStyleDeclaration style;
        String value;
        WebWindow window;
        SgmlPage page = domNode.getPage();
        if (page != null && (window = page.getEnclosingWindow()).getWebClient().getOptions().isCssEnabled() && domNode instanceof DomElement && StringUtils.isNoneEmpty(value = (style = window.getComputedStyle((DomElement)domNode, null)).getStyleAttribute(StyleAttributes.Definition.WHITE_SPACE, false))) {
            if ("normal".equalsIgnoreCase(value)) {
                return Mode.WHITE_SPACE_NORMAL;
            }
            if ("nowrap".equalsIgnoreCase(value)) {
                return Mode.WHITE_SPACE_NORMAL;
            }
            if ("pre".equalsIgnoreCase(value)) {
                return Mode.WHITE_SPACE_PRE;
            }
            if ("pre-wrap".equalsIgnoreCase(value)) {
                return Mode.WHITE_SPACE_PRE;
            }
            if ("pre-line".equalsIgnoreCase(value)) {
                return Mode.WHITE_SPACE_PRE_LINE;
            }
        }
        return defaultMode;
    }

    protected static class HtmlSerializerTextBuilder {
        private State state_;
        private final StringBuilder builder_ = new StringBuilder();
        private int trimRightPos_ = 0;
        private boolean contentAdded_;
        private boolean ignoreHtmlBreaks_;

        public HtmlSerializerTextBuilder() {
            this.state_ = State.EMPTY;
        }

        public void append(String content, Mode mode) {
            if (content == null) {
                return;
            }
            int length = content.length();
            if (length == 0) {
                return;
            }
            --length;
            int i = -1;
            for (char c : content.toCharArray()) {
                ++i;
                if (c == '\r') {
                    if (length != i) continue;
                    c = '\n';
                }
                if (c == '\n') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    if (mode == Mode.PRE) {
                        this.builder_.append('\n');
                        this.state_ = State.NEWLINE_AT_END;
                        this.trimRightPos_ = this.builder_.length();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\f') {
                    if (mode == Mode.WHITE_SPACE_PRE || mode == Mode.PRE) {
                        this.appendBlank();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLANK_AT_END: 
                            case BLANK_AT_END_AFTER_NEWLINE: 
                            case BREAK_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\u00a0') {
                    this.appendBlank();
                    if (mode != Mode.WHITE_SPACE_NORMAL && mode != Mode.WHITE_SPACE_PRE_LINE) continue;
                    this.state_ = State.DEFAULT;
                    continue;
                }
                this.builder_.append(c);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
                this.contentAdded_ = true;
            }
        }

        public void appendBlockSeparator() {
            switch (this.state_) {
                case EMPTY: {
                    break;
                }
                case BLANK_AT_END: {
                    this.builder_.setLength(this.trimRightPos_);
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLANK_AT_END_AFTER_NEWLINE: {
                    this.builder_.setLength(this.trimRightPos_ - 1);
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLOCK_SEPARATOR_AT_END: {
                    break;
                }
                case NEWLINE_AT_END: 
                case BREAK_AT_END: {
                    this.builder_.setLength(this.builder_.length() - 1);
                    --this.trimRightPos_;
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                default: {
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                }
            }
        }

        public void appendBreak(Mode mode) {
            if (this.ignoreHtmlBreaks_) {
                return;
            }
            this.builder_.setLength(this.trimRightPos_);
            this.builder_.append('\n');
            this.state_ = State.BREAK_AT_END;
            this.trimRightPos_ = this.builder_.length();
        }

        public void appendBlank() {
            this.builder_.append(' ');
            this.state_ = State.BLANK_AT_END;
            this.trimRightPos_ = this.builder_.length();
        }

        public void trimRight(Mode mode) {
            if (mode == Mode.PRE) {
                switch (this.state_) {
                    case BLOCK_SEPARATOR_AT_END: 
                    case NEWLINE_AT_END: 
                    case BREAK_AT_END: {
                        if (this.trimRightPos_ != this.builder_.length()) break;
                        --this.trimRightPos_;
                        break;
                    }
                }
            }
            this.builder_.setLength(this.trimRightPos_);
            this.state_ = State.DEFAULT;
            if (this.builder_.length() == 0) {
                this.state_ = State.EMPTY;
            }
        }

        public boolean wasContentAdded() {
            return this.contentAdded_;
        }

        public void resetContentAdded() {
            this.contentAdded_ = false;
        }

        public void ignoreHtmlBreaks() {
            this.ignoreHtmlBreaks_ = true;
        }

        public void processHtmlBreaks() {
            this.ignoreHtmlBreaks_ = false;
        }

        public String getText() {
            return this.builder_.substring(0, this.trimRightPos_);
        }

        private static enum State {
            DEFAULT,
            EMPTY,
            BLANK_AT_END,
            BLANK_AT_END_AFTER_NEWLINE,
            NEWLINE_AT_END,
            BREAK_AT_END,
            BLOCK_SEPARATOR_AT_END;

        }
    }

    protected static enum Mode {
        PRE,
        WHITE_SPACE_NORMAL,
        WHITE_SPACE_PRE,
        WHITE_SPACE_PRE_LINE;

    }
}

