/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import java.io.Serializable;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ScriptException;
import org.htmlunit.ScriptPreProcessor;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.ErrorReporter;
import org.htmlunit.corejs.javascript.Evaluator;
import org.htmlunit.corejs.javascript.EvaluatorException;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.debug.Debugger;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.JavaScriptErrorListener;
import org.htmlunit.javascript.TimeoutError;
import org.htmlunit.javascript.regexp.HtmlUnitRegExpProxy;

public class HtmlUnitContextFactory
extends ContextFactory {
    private static final int INSTRUCTION_COUNT_THRESHOLD = 10000;
    private final WebClient webClient_;
    private final BrowserVersion browserVersion_;
    private long timeout_;
    private Debugger debugger_;
    private boolean deminifyFunctionCode_;

    public HtmlUnitContextFactory(WebClient webClient) {
        this.webClient_ = webClient;
        this.browserVersion_ = webClient.getBrowserVersion();
    }

    public void setTimeout(long timeout) {
        this.timeout_ = timeout;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger_ = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger_;
    }

    public void setDeminifyFunctionCode(boolean deminify) {
        this.deminifyFunctionCode_ = deminify;
    }

    public boolean isDeminifyFunctionCode() {
        return this.deminifyFunctionCode_;
    }

    protected String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        String newSourceCode = sourceCode;
        ScriptPreProcessor preProcessor = this.webClient_.getScriptPreProcessor();
        if (preProcessor != null && (newSourceCode = preProcessor.preProcess(htmlPage, sourceCode, sourceName, lineNumber, htmlElement)) == null) {
            newSourceCode = "";
        }
        return newSourceCode;
    }

    @Override
    protected Context makeContext() {
        TimeoutContext cx = new TimeoutContext(this);
        cx.setLanguageVersion(200);
        cx.setLocale(this.browserVersion_.getBrowserLocale());
        cx.setTimeZone(this.browserVersion_.getSystemTimezone());
        cx.setClassShutter(fullClassName -> false);
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        cx.setErrorReporter(new HtmlUnitErrorReporter(this.webClient_.getJavaScriptErrorListener()));
        cx.getWrapFactory().setJavaPrimitiveWrap(false);
        if (this.debugger_ != null) {
            cx.setDebugger(this.debugger_, null);
        }
        ScriptRuntime.setRegExpProxy(cx, new HtmlUnitRegExpProxy(ScriptRuntime.getRegExpProxy(cx)));
        cx.setMaximumInterpreterStackDepth(5000);
        return cx;
    }

    @Override
    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.terminateScriptIfNecessary();
    }

    @Override
    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.startClock();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    public final <T> T callSecured(ContextAction<T> action, HtmlPage page) {
        try {
            return this.call(action);
        }
        catch (StackOverflowError e) {
            this.webClient_.getJavaScriptErrorListener().scriptException(page, new ScriptException(page, (Throwable)e));
            return null;
        }
    }

    @Override
    protected boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 3: {
                return true;
            }
            case 6: {
                return false;
            }
            case 15: {
                return true;
            }
            case 1: {
                return false;
            }
            case 19: {
                return true;
            }
            case 10: {
                return true;
            }
            case 22: {
                return true;
            }
            case 101: {
                return true;
            }
            case 103: {
                return true;
            }
            case 105: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_PROPERTY_DESCRIPTOR_NAME);
            }
            case 106: {
                return false;
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    private static final class HtmlUnitErrorReporter
    implements ErrorReporter,
    Serializable {
        private final JavaScriptErrorListener javaScriptErrorListener_;

        HtmlUnitErrorReporter(JavaScriptErrorListener javaScriptErrorListener) {
            this.javaScriptErrorListener_ = javaScriptErrorListener;
        }

        @Override
        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.javaScriptErrorListener_.warn(message, sourceName, line, lineSource, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        @Override
        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }

    private class TimeoutContext
    extends Context {
        private long startTime_;

        protected TimeoutContext(ContextFactory factory) {
            super(factory);
        }

        public void startClock() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void terminateScriptIfNecessary() {
            long currentTime;
            if (HtmlUnitContextFactory.this.timeout_ > 0L && (currentTime = System.currentTimeMillis()) - this.startTime_ > HtmlUnitContextFactory.this.timeout_) {
                throw new TimeoutError(HtmlUnitContextFactory.this.timeout_, currentTime - this.startTime_);
            }
        }

        @Override
        protected Script compileString(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            boolean isWindowEval;
            boolean bl = isWindowEval = compiler != null;
            if (!isWindowEval) {
                int start;
                int length = source.length();
                for (start = 0; start < length && source.charAt(start) <= ' '; ++start) {
                }
                if (start + 3 < length && source.charAt(start++) == '<' && source.charAt(start++) == '!' && source.charAt(start++) == '-' && source.charAt(start++) == '-') {
                    source = source.replaceFirst("<!--", "// <!--");
                }
            }
            HtmlPage page = (HtmlPage)Context.getCurrentContext().getThreadLocal("startingPage");
            source = HtmlUnitContextFactory.this.preProcess(page, source, sourceName, lineno, null);
            return super.compileString(source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }

        @Override
        protected Function compileFunction(Scriptable scope, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            if (HtmlUnitContextFactory.this.deminifyFunctionCode_) {
                Function f = super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                source = this.decompileFunction(f, 4).trim().replace("\n    ", "\n");
            }
            return super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }
    }
}

