/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.ScriptException;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Interpreter;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeArrayIterator;
import org.htmlunit.corejs.javascript.NativeConsole;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.StackStyle;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.NativeFunctionToStringFunction;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.RecursiveFunctionObject;
import org.htmlunit.javascript.TimeoutError;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptExecutor;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JavaScriptConfiguration;
import org.htmlunit.javascript.configuration.ProxyAutoConfigJavaScriptConfiguration;
import org.htmlunit.javascript.host.ConsoleCustom;
import org.htmlunit.javascript.host.NumberCustom;
import org.htmlunit.javascript.host.URLSearchParams;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.DOMException;
import org.htmlunit.javascript.host.html.HTMLImageElement;
import org.htmlunit.javascript.host.html.HTMLOptionElement;
import org.htmlunit.javascript.host.intl.Intl;
import org.htmlunit.javascript.host.xml.FormData;
import org.htmlunit.javascript.polyfill.Polyfill;

public class JavaScriptEngine
implements AbstractJavaScriptEngine<Script> {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    public static final Object[] emptyArgs = ScriptRuntime.emptyArgs;
    public static final Object Undefined = org.htmlunit.corejs.javascript.Undefined.instance;
    private WebClient webClient_;
    private HtmlUnitContextFactory contextFactory_;
    private JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient boolean shutdownPending_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        if (webClient == null) {
            throw new IllegalArgumentException("JavaScriptEngine ctor requires a webClient");
        }
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
        RhinoException.setStackStyle(StackStyle.MOZILLA_LF);
    }

    private WebClient getWebClient() {
        return this.webClient_;
    }

    @Override
    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    @Override
    public void initialize(WebWindow webWindow, Page page) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.shutdownPending_) {
            return;
        }
        this.getContextFactory().call(cx -> {
            try {
                this.init(webWindow, page, cx);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                throw new ScriptException(null, (Throwable)e);
            }
            return null;
        });
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Page page, Context context) throws Exception {
        WebClient webClient = webWindow.getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        Window window = new Window();
        window.setClassName("Window");
        context.initSafeStandardObjects(window);
        ClassConfiguration windowConfig = this.jsConfig_.getClassConfiguration("Window");
        if (windowConfig.getJsConstructor() != null) {
            RecursiveFunctionObject functionObject = new RecursiveFunctionObject("Window", windowConfig.getJsConstructor().getValue(), window, browserVersion);
            ScriptableObject.defineProperty(window, "constructor", functionObject, 7);
        } else {
            JavaScriptEngine.defineConstructor(window, window, new Window());
        }
        JavaScriptEngine.deleteProperties(window, "Continuation", "StopIteration", "BigInt");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ITERATOR_VISIBLE_IN_WINDOW)) {
            JavaScriptEngine.deleteProperties(window, "Iterator");
        }
        ScriptableObject errorObject = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "Error");
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK_TRACE_LIMIT)) {
            errorObject.defineProperty("stackTraceLimit", (Object)10, 0);
        } else {
            ScriptableObject.deleteProperty((Scriptable)errorObject, "stackTraceLimit");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_CAPTURE_STACK_TRACE)) {
            ScriptableObject.deleteProperty((Scriptable)errorObject, "captureStackTrace");
        }
        URLSearchParams.NativeParamsIterator.init(window, "URLSearchParams Iterator");
        FormData.FormDataIterator.init(window, "FormData Iterator");
        Intl intl = new Intl();
        intl.setParentScope(window);
        window.defineProperty(intl.getClassName(), (Object)intl, 2);
        intl.defineProperties(browserVersion);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_INSTALL_TRIGGER_NULL)) {
            window.put("InstallTrigger", (Scriptable)window, null);
        }
        HashMap<Class<? extends Scriptable>, Scriptable> prototypes = new HashMap<Class<? extends Scriptable>, Scriptable>();
        HashMap<String, Scriptable> prototypesPerJSName = new HashMap<String, Scriptable>();
        String windowClassName = Window.class.getName();
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            HtmlUnitScriptable prototype;
            boolean isWindow = windowClassName.equals(config.getHostClass().getName());
            if (isWindow) {
                JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, window);
                prototype = JavaScriptEngine.configureClass(config, window, browserVersion);
                prototypesPerJSName.put(config.getClassName(), prototype);
                continue;
            }
            prototype = JavaScriptEngine.configureClass(config, window, browserVersion);
            if (config.isJsObject()) {
                HtmlUnitScriptable obj = config.getHostClass().newInstance();
                prototype.defineProperty("__proto__", (Object)prototype, 2);
                obj.defineProperty("prototype", (Object)prototype, 2);
                obj.setParentScope(window);
                obj.setClassName(config.getClassName());
                ScriptableObject.defineProperty(window, obj.getClassName(), obj, 2);
                JavaScriptEngine.configureConstants(config, obj);
            }
            prototypes.put(config.getHostClass(), prototype);
            prototypesPerJSName.put(config.getClassName(), prototype);
        }
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            BaseFunction function;
            block20: {
                Map.Entry<String, Member> jsConstructor = config.getJsConstructor();
                String jsClassName = config.getClassName();
                Scriptable prototype = (Scriptable)prototypesPerJSName.get(jsClassName);
                if (prototype == null || !config.isJsObject()) continue;
                if (jsConstructor == null) {
                    ScriptableObject constructor;
                    if ("Window".equals(jsClassName)) {
                        constructor = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "constructor");
                    } else {
                        constructor = config.getHostClass().newInstance();
                        ((HtmlUnitScriptable)constructor).setClassName(jsClassName);
                    }
                    JavaScriptEngine.defineConstructor(window, prototype, constructor);
                    JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(config, constructor);
                    continue;
                }
                function = "Window".equals(jsClassName) ? (BaseFunction)ScriptableObject.getProperty((Scriptable)window, "constructor") : new RecursiveFunctionObject(jsConstructor.getKey(), jsConstructor.getValue(), window, browserVersion);
                if (function instanceof FunctionObject) {
                    try {
                        ((FunctionObject)function).addAsConstructor(window, prototype, 2);
                        String alias = config.getJsConstructorAlias();
                        if (alias != null) {
                            ScriptableObject.defineProperty(window, alias, function, 2);
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block20;
                        String newline = System.lineSeparator();
                        LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
                    }
                }
            }
            JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(config, function);
        }
        window.setPrototype((Scriptable)prototypesPerJSName.get(Window.class.getSimpleName()));
        Method imageCtor = HTMLImageElement.class.getDeclaredMethod("jsConstructorImage", new Class[0]);
        JavaScriptEngine.additionalCtor(window, prototypesPerJSName, imageCtor, "Image", "HTMLImageElement");
        Method optionCtor = HTMLOptionElement.class.getDeclaredMethod("jsConstructorOption", Object.class, String.class, Boolean.TYPE, Boolean.TYPE);
        JavaScriptEngine.additionalCtor(window, prototypesPerJSName, optionCtor, "Option", "HTMLOptionElement");
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype(window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
            Scriptable prototype = (Scriptable)entry.getValue();
            if (!StringUtils.isEmpty(config.getExtendedClassName())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(objectPrototype);
        }
        JavaScriptEngine.configureRhino(webClient, browserVersion, window);
        window.setPrototypes(prototypes);
        window.initialize(webWindow, page);
        JavaScriptEngine.applyPolyfills(webClient, browserVersion, context, window);
    }

    private static void additionalCtor(Window window, Map<String, Scriptable> prototypesPerJSName, Method ctorMethod, String prop, String clazzName) throws Exception {
        Object prototypeProperty;
        FunctionObject function;
        block2: {
            function = new FunctionObject(prop, ctorMethod, window);
            Scriptable proto = prototypesPerJSName.get(clazzName);
            prototypeProperty = ScriptableObject.getProperty((Scriptable)window, clazzName);
            try {
                function.addAsConstructor(window, proto, 2);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                String newline = System.lineSeparator();
                LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + proto.getClassName()));
            }
        }
        ScriptableObject.defineProperty(window, prop, function, 2);
        ScriptableObject.defineProperty(window, clazzName, prototypeProperty, 2);
    }

    public static void configureRhino(WebClient webClient, BrowserVersion browserVersion, HtmlUnitScriptable scriptable) {
        NativeConsole.init(scriptable, false, webClient.getWebConsole());
        ScriptableObject console = (ScriptableObject)ScriptableObject.getProperty((Scriptable)scriptable, "console");
        console.defineFunctionProperties(new String[]{"timeStamp"}, ConsoleCustom.class, 2);
        ScriptableObject stringPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "String");
        JavaScriptEngine.deleteProperties(stringPrototype, "equals", "equalsIgnoreCase", "toSource");
        ScriptableObject numberPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "Number");
        JavaScriptEngine.deleteProperties(numberPrototype, "toSource");
        ScriptableObject datePrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "Date");
        JavaScriptEngine.deleteProperties(datePrototype, "toSource");
        JavaScriptEngine.deleteProperties(scriptable, "uneval");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Object", "toSource");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Array", "toSource");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Function", "toSource");
        JavaScriptEngine.deleteProperties(scriptable, "isXMLName");
        NativeFunctionToStringFunction.installFix(scriptable, browserVersion);
        numberPrototype.defineFunctionProperties(new String[]{"toLocaleString"}, NumberCustom.class, 2);
        if (!webClient.getOptions().isWebSocketEnabled()) {
            JavaScriptEngine.deleteProperties(scriptable, "WebSocket");
        }
    }

    public static void applyPolyfills(WebClient webClient, BrowserVersion browserVersion, Context context, HtmlUnitScriptable scriptable) throws IOException {
        if (webClient.getOptions().isFetchPolyfillEnabled()) {
            Polyfill.getFetchPolyfill().apply(context, scriptable);
        }
    }

    private static void defineConstructor(Window window, Scriptable prototype, ScriptableObject constructor) {
        block5: {
            String newline;
            block4: {
                constructor.setParentScope(window);
                try {
                    ScriptableObject.defineProperty(prototype, "constructor", constructor, 7);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    newline = System.lineSeparator();
                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
                }
            }
            try {
                ScriptableObject.defineProperty(constructor, "prototype", prototype, 7);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block5;
                newline = System.lineSeparator();
                LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
            }
        }
        window.defineProperty(constructor.getClassName(), (Object)constructor, 2);
    }

    private static void deleteProperties(Scriptable scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    private static void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype(scope, className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    public static HtmlUnitScriptable configureClass(ClassConfiguration config, Scriptable window, BrowserVersion browserVersion) throws InstantiationException, IllegalAccessException {
        HtmlUnitScriptable prototype = config.getHostClass().newInstance();
        prototype.setParentScope(window);
        prototype.setClassName(config.getClassName());
        JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private static void configureConstantsStaticPropertiesAndStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureStaticProperties(config, scriptable);
        JavaScriptEngine.configureStaticFunctions(config, scriptable);
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureProperties(config, scriptable);
        JavaScriptEngine.configureFunctions(config, scriptable);
        JavaScriptEngine.configureSymbolConstants(config, scriptable);
        JavaScriptEngine.configureSymbols(config, scriptable);
    }

    private static void configureFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, Method> functionMap = config.getFunctionMap();
        if (functionMap != null) {
            for (Map.Entry<String, Method> functionInfo : functionMap.entrySet()) {
                String functionName = functionInfo.getKey();
                Method method = functionInfo.getValue();
                FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
                scriptable.defineProperty(functionName, (Object)functionObject, 0);
            }
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        List<ClassConfiguration.ConstantInfo> constants = config.getConstants();
        if (constants != null) {
            for (ClassConfiguration.ConstantInfo constantInfo : constants) {
                scriptable.defineProperty(constantInfo.getName(), constantInfo.getValue(), constantInfo.getFlag());
            }
        }
    }

    private static void configureProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> propertyMap = config.getPropertyMap();
        if (propertyMap != null) {
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : propertyMap.entrySet()) {
                ClassConfiguration.PropertyInfo info = propertyEntry.getValue();
                Method readMethod = info.getReadMethod();
                Method writeMethod = info.getWriteMethod();
                scriptable.defineProperty(propertyEntry.getKey(), null, readMethod, writeMethod, 0);
            }
        }
    }

    private static void configureStaticProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> staticPropertyMap = config.getStaticPropertyMap();
        if (staticPropertyMap != null) {
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : staticPropertyMap.entrySet()) {
                String propertyName = propertyEntry.getKey();
                Method readMethod = propertyEntry.getValue().getReadMethod();
                Method writeMethod = propertyEntry.getValue().getWriteMethod();
                boolean flag = false;
                scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
            }
        }
    }

    private static void configureStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, Method> staticFunctionMap = config.getStaticFunctionMap();
        if (staticFunctionMap != null) {
            for (Map.Entry<String, Method> staticFunctionInfo : staticFunctionMap.entrySet()) {
                String functionName = staticFunctionInfo.getKey();
                Method method = staticFunctionInfo.getValue();
                FunctionObject staticFunctionObject = new FunctionObject(functionName, method, scriptable);
                scriptable.defineProperty(functionName, (Object)staticFunctionObject, 0);
            }
        }
    }

    private static void configureSymbolConstants(ClassConfiguration config, ScriptableObject scriptable) {
        Map<Symbol, String> symbolConstantMap = config.getSymbolConstantMap();
        if (symbolConstantMap != null) {
            for (Map.Entry<Symbol, String> symbolInfo : symbolConstantMap.entrySet()) {
                scriptable.defineProperty(symbolInfo.getKey(), (Object)symbolInfo.getValue(), 3);
            }
        }
    }

    private static void configureSymbols(ClassConfiguration config, ScriptableObject scriptable) {
        Map<Symbol, Method> symbolMap = config.getSymbolMap();
        if (symbolMap != null) {
            for (Map.Entry<Symbol, Method> symbolInfo : symbolMap.entrySet()) {
                Symbol symbol = symbolInfo.getKey();
                Method method = symbolInfo.getValue();
                String methodName = method.getName();
                Callable symbolFunction = scriptable.has(methodName, (Scriptable)scriptable) ? (Callable)scriptable.get(methodName, (Scriptable)scriptable) : new FunctionObject(methodName, method, scriptable);
                scriptable.defineProperty(symbol, (Object)symbolFunction, 2);
            }
        }
    }

    @Override
    public synchronized void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.shutdownPending_) {
            return;
        }
        WebClient webClient = this.getWebClient();
        if (webClient != null) {
            if (this.javaScriptExecutor_ == null) {
                this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(webClient);
            }
            this.javaScriptExecutor_.addWindow(webWindow);
        }
    }

    @Override
    public void prepareShutdown() {
        this.shutdownPending_ = true;
    }

    @Override
    public void shutdown() {
        this.webClient_ = null;
        this.contextFactory_ = null;
        this.jsConfig_ = null;
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
        if (this.postponedActions_ != null) {
            this.postponedActions_.remove();
        }
        if (this.javaScriptRunning_ != null) {
            this.javaScriptRunning_.remove();
        }
        this.holdPostponedActions_ = false;
    }

    @Override
    public Script compile(HtmlPage owningPage, Scriptable scope, final String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.lineSeparator();
            LOG.trace((Object)("Javascript compile " + sourceName + newline + sourceCode + newline));
        }
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, owningPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(sourceCode, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return sourceCode;
            }
        };
        return (Script)this.getContextFactory().callSecured(action, owningPage);
    }

    @Override
    @Deprecated
    public Script compile(HtmlPage owningPage, String sourceCode, String sourceName, int startLine) {
        return this.compile(owningPage, (Scriptable)owningPage.getEnclosingWindow().getScriptableObject(), sourceCode, sourceName, startLine);
    }

    public final <T> T callSecured(ContextAction<T> action, HtmlPage page) {
        if (this.shutdownPending_ || this.webClient_ == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"execute() called after the shutdown of the Javascript engine and therefore not processed");
            }
            return null;
        }
        return this.getContextFactory().callSecured(action, page);
    }

    @Override
    public Object execute(HtmlPage page, Scriptable scope, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(page, scope, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(page, scope, script);
    }

    @Override
    @Deprecated
    public Object execute(HtmlPage page, String sourceCode, String sourceName, int startLine) {
        return this.execute(page, (Scriptable)page.getEnclosingWindow().getScriptableObject(), sourceCode, sourceName, startLine);
    }

    @Override
    public Object execute(HtmlPage page, final Scriptable scope, final Script script) {
        if (this.shutdownPending_ || this.webClient_ == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"execute() called after the shutdown of the Javascript engine and therefore not processed");
            }
            return null;
        }
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().callSecured(action, page);
    }

    @Override
    @Deprecated
    public Object execute(HtmlPage page, Script script) {
        return this.execute(page, (Scriptable)page.getEnclosingWindow().getScriptableObject(), script);
    }

    public Object callFunction(HtmlPage page, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode node) {
        Scriptable scope = JavaScriptEngine.getScope(page, node);
        return this.callFunction(page, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(HtmlPage page, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        if (this.shutdownPending_ || this.webClient_ == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"callFunction() called after the shutdown of the Javascript engine and therefore not processed");
            }
            return null;
        }
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                if (ScriptRuntime.hasTopCall(cx)) {
                    return function.call(cx, scope, thisObject, args);
                }
                return ScriptRuntime.doTopCall(function, cx, scope, thisObject, args, cx.isStrictMode());
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().callSecured(action, page);
    }

    private static Scriptable getScope(HtmlPage page, DomNode node) {
        if (node != null) {
            return node.getScriptableObject();
        }
        return (Scriptable)page.getEnclosingWindow().getScriptableObject();
    }

    @Override
    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            this.postponedActions_.set(null);
            return;
        }
        try {
            webClient.loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Processing PostponedAction " + action));
                    }
                    if (!action.isStillAlive()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
            }
        }
    }

    @Override
    public void addPostponedAction(PostponedAction action) {
        if (this.shutdownPending_) {
            return;
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        Window w;
        WebWindow window;
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("handleJavaScriptException('" + scriptException.getMessage() + "') called after the shutdown of the Javascript engine - exception ignored."));
            }
            return;
        }
        HtmlPage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptableObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        webClient.getJavaScriptErrorListener().scriptException(page, scriptException);
        if (webClient.getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
    }

    protected void handleJavaScriptTimeoutError(HtmlPage page, TimeoutError e) {
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Caught script timeout error after the shutdown of the Javascript engine - ignored.");
            }
            return;
        }
        webClient.getJavaScriptErrorListener().timeoutError(page, e.getAllowedTime(), e.getExecutionTime());
        if (webClient.getOptions().isThrowExceptionOnScriptError()) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)"Caught script timeout error", (Throwable)e);
    }

    @Override
    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    @Override
    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
        this.shutdownPending_ = false;
    }

    public Class<? extends HtmlUnitScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMappingFor(c);
    }

    @Override
    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    @Override
    public long getJavaScriptTimeout() {
        return this.getContextFactory().getTimeout();
    }

    @Override
    public void setJavaScriptTimeout(long timeout) {
        this.getContextFactory().setTimeout(timeout);
    }

    public static double toNumber(Object value) {
        return ScriptRuntime.toNumber(value);
    }

    public static String toString(Object value) {
        return ScriptRuntime.toString(value);
    }

    public static boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(value);
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable e) {
        throw Context.throwAsScriptRuntimeEx(e);
    }

    public static RuntimeException reportRuntimeError(String message) {
        throw Context.reportRuntimeError(message);
    }

    public static EcmaError typeError(String message) {
        return ScriptRuntime.typeError(message);
    }

    public static EcmaError networkError(String message) {
        return ScriptRuntime.networkError(message);
    }

    public static EcmaError rangeError(String message) {
        return ScriptRuntime.rangeError(message);
    }

    public static EcmaError constructError(String error, String message) {
        return ScriptRuntime.constructError(error, message);
    }

    public static RhinoException asJavaScriptException(Window window, DOMException exception) {
        exception.setParentScope(window);
        exception.setPrototype(window.getPrototype(exception.getClass()));
        if (Context.getCurrentContext().getOptimizationLevel() != -1) {
            throw new Error("HtmlUnit not ready to run in compiled mode");
        }
        int[] linep = new int[1];
        String sourceName = new Interpreter().getSourcePositionFromStack(Context.getCurrentContext(), linep);
        String fileName = sourceName.replaceFirst("script in (.*) from .*", "$1");
        int lineNumber = linep[0];
        exception.setLocation(fileName, lineNumber);
        return new JavaScriptException(exception, fileName, lineNumber);
    }

    public static Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(length);
        ScriptRuntime.setBuiltinProtoAndParent(result, scope, TopLevel.Builtins.Array);
        return result;
    }

    public static Scriptable newArrayIteratorTypeKeys(Scriptable scope, Scriptable arrayLike) {
        return new NativeArrayIterator(scope, arrayLike, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
    }

    public static Scriptable newArrayIteratorTypeValues(Scriptable scope, Scriptable arrayLike) {
        return new NativeArrayIterator(scope, arrayLike, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
    }

    public static Scriptable newArrayIteratorTypeEntries(Scriptable scope, Scriptable arrayLike) {
        return new NativeArrayIterator(scope, arrayLike, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
    }

    public static Scriptable newArray(Scriptable scope, Object[] elements) {
        if (elements.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray result = new NativeArray(elements);
        ScriptRuntime.setBuiltinProtoAndParent(result, scope, TopLevel.Builtins.Array);
        return result;
    }

    public static int toInt32(Object o) {
        return ScriptRuntime.toInt32(o);
    }

    public static double toInteger(Object o) {
        return ScriptRuntime.toInteger(o);
    }

    public static double toInteger(Object[] args, int index) {
        return ScriptRuntime.toInteger(args, index);
    }

    public static boolean isUndefined(Object obj) {
        return org.htmlunit.corejs.javascript.Undefined.isUndefined(obj);
    }

    public static boolean isNaN(Object obj) {
        return ScriptRuntime.isNaN(obj);
    }

    public static String uncompressJavaScript(String scriptSource, String scriptName) {
        ContextFactory factory = new ContextFactory();
        ContextAction<Object> action = cx -> {
            cx.setOptimizationLevel(-1);
            Script script = cx.compileString(scriptSource, scriptName, 0, null);
            return cx.decompileScript(script, 4);
        };
        return (String)factory.call(action);
    }

    public static String evaluateProxyAutoConfig(BrowserVersion browserVersion, String content, URL url) {
        try (Context cx = Context.enter();){
            ProxyAutoConfigJavaScriptConfiguration jsConfig = ProxyAutoConfigJavaScriptConfiguration.getInstance(browserVersion);
            ScriptableObject scope = cx.initSafeStandardObjects();
            for (ClassConfiguration config : jsConfig.getAll()) {
                JavaScriptEngine.configureFunctions(config, scope);
            }
            cx.evaluateString(scope, "var ProxyConfig = function() {}; ProxyConfig.bindings = {}", "<init>", 1, null);
            cx.evaluateString(scope, content, "<Proxy Auto-Config>", 1, null);
            Object[] functionArgs = new Object[]{url.toExternalForm(), url.getHost()};
            NativeFunction f = (NativeFunction)scope.get("FindProxyForURL", (Scriptable)scope);
            Object result = f.call(cx, scope, scope, functionArgs);
            String string = JavaScriptEngine.toString(result);
            return string;
        }
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction<Object> {
        private final Scriptable scope_;
        private final HtmlPage page_;

        HtmlUnitContextAction(Scriptable scope, HtmlPage page) {
            this.scope_ = scope;
            this.page_ = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Object object;
                ArrayDeque<Scriptable> stack = (ArrayDeque<Scriptable>)cx.getThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new ArrayDeque<Scriptable>();
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_PAGE, this.page_);
                    object = this.page_;
                    synchronized (object) {
                        block18: {
                            if (this.page_ == this.page_.getEnclosingWindow().getEnclosedPage()) break block18;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                    cx.processMicrotasks();
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.page_, e, this.getSourceCode(cx)), true);
                Object var4_9 = null;
                return var4_9;
            }
            catch (TimeoutError e) {
                JavaScriptEngine.this.handleJavaScriptTimeoutError(this.page_, e);
                Object var4_10 = null;
                return var4_10;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

