/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import javax.xml.transform.TransformerException;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.xpath.HtmlUnitPrefixResolver;
import org.htmlunit.html.xpath.XPathAdapter;
import org.htmlunit.html.xpath.XPathHelper;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.XPathResult;
import org.htmlunit.xpath.xml.utils.PrefixResolver;

@JsxClass
public class XPathExpression
extends HtmlUnitScriptable {
    private final XPathAdapter xpath_;
    private final PrefixResolver prefixResolver_;

    public XPathExpression() {
        this.xpath_ = null;
        this.prefixResolver_ = null;
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    XPathExpression(String expression, PrefixResolver prefixResolver, DomNode node) throws TransformerException {
        PrefixResolver resolver = prefixResolver;
        if (resolver == null) {
            resolver = new HtmlUnitPrefixResolver(node);
        }
        this.prefixResolver_ = resolver;
        boolean caseSensitive = node.getPage().hasCaseSensitiveTagNames();
        this.xpath_ = new XPathAdapter(expression, prefixResolver, caseSensitive);
    }

    @JsxFunction
    public static XPathResult evaluate(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw JavaScriptEngine.reportRuntimeError("Missing 'contextNode' parameter");
        }
        int type = 0;
        if (args.length > 1) {
            type = (int)JavaScriptEngine.toInteger(args[1]);
        }
        Object result = null;
        if (args.length > 2) {
            result = args[2];
        }
        try {
            XPathResult xPathResult;
            XPathExpression expression = (XPathExpression)thisObj;
            Object contextNodeObj = args[0];
            if (!(contextNodeObj instanceof Node)) {
                throw JavaScriptEngine.reportRuntimeError("Illegal value for parameter 'context'");
            }
            DomNode contextNode = ((Node)contextNodeObj).getDomNodeOrDie();
            if (result instanceof XPathResult) {
                xPathResult = (XPathResult)result;
            } else {
                xPathResult = new XPathResult();
                xPathResult.setParentScope(expression.getParentScope());
                xPathResult.setPrototype(expression.getPrototype(xPathResult.getClass()));
            }
            xPathResult.init(XPathHelper.getByXPath((org.w3c.dom.Node)contextNode, expression.xpath_, expression.prefixResolver_), type);
            return xPathResult;
        }
        catch (Exception e) {
            throw JavaScriptEngine.reportRuntimeError("Failed to execute 'evaluate': " + e.getMessage());
        }
    }
}

