/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.worker;

import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.worker.DedicatedWorkerGlobalScope;

@JsxClass
public class Worker
extends EventTarget {
    private final DedicatedWorkerGlobalScope workerScope_;

    public Worker() {
        this.workerScope_ = null;
    }

    private Worker(Context cx, Window owningWindow, String url) throws Exception {
        this.setParentScope(owningWindow);
        this.setPrototype(this.getPrototype(this.getClass()));
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        this.workerScope_ = new DedicatedWorkerGlobalScope(owningWindow, cx, webClient, this);
        this.workerScope_.loadAndExecute(webClient, url, null, false);
    }

    @JsxConstructor
    public static Worker jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (args.length < 1 || args.length > 2) {
            throw JavaScriptEngine.reportRuntimeError("Worker Error: constructor must have one or two String parameters.");
        }
        String url = JavaScriptEngine.toString(args[0]);
        return new Worker(cx, Worker.getWindow(ctorObj), url);
    }

    @JsxFunction
    public void postMessage(Object message) {
        this.workerScope_.messagePosted(message);
    }

    @JsxFunction
    public void terminate() {
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.getEventListenersContainer().setEventHandler("message", onmessage);
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getEventListenersContainer().getEventHandler("message");
    }
}

