/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.xml;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.DocumentFragment;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.xml.XMLDocument;
import org.htmlunit.util.EncodingSniffer;
import org.htmlunit.util.XmlUtils;
import org.htmlunit.xml.XmlPage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@JsxClass
public class XSLTProcessor
extends HtmlUnitScriptable {
    private Node style_;
    private final Map<String, Object> parameters_ = new HashMap<String, Object>();

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public void importStylesheet(Node style) {
        this.style_ = style;
    }

    @JsxFunction
    public XMLDocument transformToDocument(Node source) {
        org.w3c.dom.Node node;
        XMLDocument doc = new XMLDocument();
        doc.setPrototype(this.getPrototype(doc.getClass()));
        doc.setParentScope(this.getParentScope());
        Object transformResult = this.transform(source);
        if (transformResult instanceof org.w3c.dom.Node) {
            org.w3c.dom.Node transformedDoc = (org.w3c.dom.Node)transformResult;
            node = transformedDoc.getFirstChild();
        } else {
            node = null;
        }
        XmlPage page = new XmlPage(node, this.getWindow().getWebWindow());
        doc.setDomNode(page);
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object transform(Node source) {
        try {
            Object indentNode;
            DomNode outputNode;
            DomNode sourceDomNode = source.getDomNodeOrDie();
            DOMSource xmlSource = new DOMSource(sourceDomNode);
            DomNode xsltDomNode = this.style_.getDomNodeOrDie();
            DOMSource xsltSource = new DOMSource(xsltDomNode);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SgmlPage page = sourceDomNode.getPage();
            if (page != null && page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XSLT_TRANSFORM_INDENT) && (outputNode = XSLTProcessor.findOutputNode(xsltDomNode)) != null && (indentNode = outputNode.getAttributes().getNamedItem("indent")) != null && "yes".equalsIgnoreCase(indentNode.getNodeValue())) {
                try {
                    transformerFactory.setAttribute("indent-number", 2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                final Transformer transformer = transformerFactory.newTransformer(xsltSource);
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                for (Map.Entry<String, Object> entry : this.parameters_.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
                Throwable throwable = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    transformer.transform(xmlSource, new StreamResult(out));
                    WebResponseData data = new WebResponseData(out.toByteArray(), 200, "OK", Collections.emptyList());
                    WebResponse response = new WebResponse(data, null, 0L){

                        @Override
                        public Charset getContentCharset() {
                            Charset cs = EncodingSniffer.toCharset(transformer.getOutputProperty("encoding"));
                            if (cs == null) {
                                return StandardCharsets.UTF_8;
                            }
                            return cs;
                        }
                    };
                    org.w3c.dom.Document document = XmlUtils.buildDocument(response);
                    return document;
                }
                catch (Throwable data) {
                    Throwable throwable2 = data;
                    throw data;
                }
            }
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            for (Map.Entry entry : this.parameters_.entrySet()) {
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            Element containerElement = document.createElement("container");
            document.appendChild(containerElement);
            DOMResult dOMResult = new DOMResult(containerElement);
            transformer.transform(xmlSource, dOMResult);
            org.w3c.dom.Node transformedNode = dOMResult.getNode();
            org.w3c.dom.Node transformedFirstChild = transformedNode.getFirstChild();
            if (transformedFirstChild != null && transformedFirstChild.getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new DOMSource(source.getDomNodeOrDie());
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                transformer.transform(xmlSource, new StreamResult(out));
                Charset cs = EncodingSniffer.toCharset(transformer.getOutputProperty("encoding"));
                if (cs == null) {
                    String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
                    return string;
                }
                String string = new String(out.toByteArray(), cs);
                return string;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw JavaScriptEngine.reportRuntimeError("Exception: " + e);
        }
    }

    @JsxFunction
    public DocumentFragment transformToFragment(Node source, Object output) {
        SgmlPage page = (SgmlPage)((Document)output).getDomNodeOrDie();
        DomDocumentFragment fragment = page.createDocumentFragment();
        DocumentFragment rv = new DocumentFragment();
        rv.setPrototype(this.getPrototype(rv.getClass()));
        rv.setParentScope(this.getParentScope());
        rv.setDomNode(fragment);
        Object result = this.transform(source);
        if (result instanceof org.w3c.dom.Node) {
            SgmlPage parentPage = fragment.getPage();
            NodeList children = ((org.w3c.dom.Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtils.appendChild(parentPage, fragment, children.item(i), true);
            }
        } else {
            DomText text = new DomText(fragment.getPage(), (String)result);
            fragment.appendChild(text);
        }
        return rv;
    }

    @JsxFunction
    public void setParameter(String namespaceURI, String localName, Object value) {
        this.parameters_.put(XSLTProcessor.getQualifiedName(namespaceURI, localName), value);
    }

    @JsxFunction
    public Object getParameter(String namespaceURI, String localName) {
        return this.parameters_.get(XSLTProcessor.getQualifiedName(namespaceURI, localName));
    }

    private static String getQualifiedName(String namespaceURI, String localName) {
        String qualifiedName = namespaceURI != null && !namespaceURI.isEmpty() && !"null".equals(namespaceURI) ? '{' + namespaceURI + '}' + localName : localName;
        return qualifiedName;
    }

    private static DomNode findOutputNode(DomNode xsltDomNode) {
        for (DomNode child : xsltDomNode.getChildren()) {
            if ("output".equals(child.getLocalName())) {
                return child;
            }
            for (DomNode child1 : child.getChildren()) {
                if (!"output".equals(child1.getLocalName())) continue;
                return child1;
            }
        }
        return null;
    }
}

