/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.commons.net.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

abstract class DelegateSocket
extends Socket {
    protected final Socket delegate;

    DelegateSocket(Socket delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.delegate.bind(bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.delegate.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.delegate.connect(endpoint, timeout);
    }

    @Override
    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new InflaterInputStream(this.delegate.getInputStream());
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegate.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.delegate.getOOBInline();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new DeflaterOutputStream(this.delegate.getOutputStream());
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.delegate.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegate.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegate.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.delegate.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.delegate.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.delegate.setOOBInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.delegate.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.delegate.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.delegate.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.delegate.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

