/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.htmlunit.ProxyConfig;
import org.htmlunit.WebAssert;

public class WebClientOptions
implements Serializable {
    private static final int DEFAULT_SCRREN_WIDTH = 1920;
    private static final int DEFAULT_SCRREN_HEIGHT = 1080;
    private boolean javaScriptEnabled_ = true;
    private boolean cssEnabled_ = true;
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private boolean throwExceptionOnScriptError_ = true;
    private boolean popupBlockerEnabled_;
    private boolean isRedirectEnabled_ = true;
    private File tempFileDirectory_;
    private KeyStore sslClientCertificateStore_;
    private char[] sslClientCertificatePassword_;
    private KeyStore sslTrustStore_;
    private String[] sslClientProtocols_;
    private String[] sslClientCipherSuites_;
    private transient SSLContext sslContext_;
    private boolean useInsecureSSL_;
    private String sslInsecureProtocol_;
    private boolean doNotTrackEnabled_;
    private String homePage_ = "https://www.htmlunit.org/";
    private ProxyConfig proxyConfig_;
    private int timeout_ = 90000;
    private long connectionTimeToLive_ = -1L;
    private boolean fileProtocolForXMLHttpRequestsAllowed_;
    private int maxInMemory_ = 512000;
    private int historySizeLimit_ = 50;
    private int historyPageCacheLimit_ = Integer.MAX_VALUE;
    private InetAddress localAddress_;
    private boolean downloadImages_;
    private int screenWidth_ = 1920;
    private int screenHeight_ = 1080;
    private boolean geolocationEnabled_;
    private Geolocation geolocation_;
    private boolean webSocketEnabled_ = true;
    private int webSocketMaxTextMessageSize_ = -1;
    private int webSocketMaxTextMessageBufferSize_ = -1;
    private int webSocketMaxBinaryMessageSize_ = -1;
    private int webSocketMaxBinaryMessageBufferSize_ = -1;
    private boolean isFetchPolyfillEnabled_;

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext_ = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext_;
    }

    public void setUseInsecureSSL(boolean useInsecureSSL) {
        this.useInsecureSSL_ = useInsecureSSL;
    }

    public boolean isUseInsecureSSL() {
        return this.useInsecureSSL_;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public File getTempFileDirectory() {
        return this.tempFileDirectory_;
    }

    public void setTempFileDirectory(File tempFileDirectory) throws IOException {
        if (tempFileDirectory != null) {
            if (tempFileDirectory.exists() && !tempFileDirectory.isDirectory()) {
                throw new IllegalArgumentException("The provided file '" + tempFileDirectory + "' points to an already existing file");
            }
            if (!tempFileDirectory.exists()) {
                FileUtils.forceMkdir((File)tempFileDirectory);
            }
        }
        this.tempFileDirectory_ = tempFileDirectory;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setSSLClientCertificateKeyStore(KeyStore keyStore, char[] keyStorePassword) {
        this.sslClientCertificateStore_ = keyStore;
        this.sslClientCertificatePassword_ = keyStorePassword;
    }

    public void setSSLClientCertificateKeyStore(URL keyStoreUrl, String keyStorePassword, String keyStoreType) {
        try (InputStream is = keyStoreUrl.openStream();){
            this.sslClientCertificateStore_ = WebClientOptions.getKeyStore(is, keyStorePassword, keyStoreType);
            this.sslClientCertificatePassword_ = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSSLClientCertificateKeyStore(InputStream keyStoreInputStream, String keyStorePassword, String keyStoreType) {
        try {
            this.setSSLClientCertificateKeyStore(WebClientOptions.getKeyStore(keyStoreInputStream, keyStorePassword, keyStoreType), keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStore getSSLClientCertificateStore() {
        return this.sslClientCertificateStore_;
    }

    public char[] getSSLClientCertificatePassword() {
        return this.sslClientCertificatePassword_;
    }

    public String[] getSSLClientProtocols() {
        return this.sslClientProtocols_;
    }

    public void setSSLClientProtocols(String ... sslClientProtocols) {
        this.sslClientProtocols_ = sslClientProtocols;
    }

    public String[] getSSLClientCipherSuites() {
        return this.sslClientCipherSuites_;
    }

    public void setSSLClientCipherSuites(String ... sslClientCipherSuites) {
        this.sslClientCipherSuites_ = sslClientCipherSuites;
    }

    public void setJavaScriptEnabled(boolean enabled) {
        this.javaScriptEnabled_ = enabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_;
    }

    public void setCssEnabled(boolean enabled) {
        this.cssEnabled_ = enabled;
    }

    public boolean isCssEnabled() {
        return this.cssEnabled_;
    }

    public void setPopupBlockerEnabled(boolean enabled) {
        this.popupBlockerEnabled_ = enabled;
    }

    public boolean isPopupBlockerEnabled() {
        return this.popupBlockerEnabled_;
    }

    public void setDoNotTrackEnabled(boolean enabled) {
        this.doNotTrackEnabled_ = enabled;
    }

    public boolean isDoNotTrackEnabled() {
        return this.doNotTrackEnabled_;
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean isPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean isThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public boolean isThrowExceptionOnScriptError() {
        return this.throwExceptionOnScriptError_;
    }

    public void setThrowExceptionOnScriptError(boolean enabled) {
        this.throwExceptionOnScriptError_ = enabled;
    }

    public String getHomePage() {
        return this.homePage_;
    }

    public void setHomePage(String homePage) {
        this.homePage_ = homePage;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig_;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        WebAssert.notNull("proxyConfig", proxyConfig);
        this.proxyConfig_ = proxyConfig;
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public long getConnectionTimeToLive() {
        return this.connectionTimeToLive_;
    }

    public void setConnectionTimeToLive(long connectionTimeToLive) {
        this.connectionTimeToLive_ = connectionTimeToLive;
    }

    public void setSSLInsecureProtocol(String sslInsecureProtocol) {
        this.sslInsecureProtocol_ = sslInsecureProtocol;
    }

    public String getSSLInsecureProtocol() {
        return this.sslInsecureProtocol_;
    }

    public void setSSLTrustStore(URL sslTrustStoreUrl, String sslTrustStorePassword, String sslTrustStoreType) {
        try (InputStream is = sslTrustStoreUrl.openStream();){
            this.sslTrustStore_ = WebClientOptions.getKeyStore(is, sslTrustStorePassword, sslTrustStoreType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setSSLTrustStore(KeyStore keyStore) {
        this.sslTrustStore_ = keyStore;
    }

    public KeyStore getSSLTrustStore() {
        return this.sslTrustStore_;
    }

    private static KeyStore getKeyStore(InputStream inputStream, String keystorePassword, String keystoreType) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (inputStream == null) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        char[] passwordChars = keystorePassword == null ? null : keystorePassword.toCharArray();
        keyStore.load(inputStream, passwordChars);
        return keyStore;
    }

    public int getMaxInMemory() {
        return this.maxInMemory_;
    }

    public void setMaxInMemory(int maxInMemory) {
        this.maxInMemory_ = maxInMemory;
    }

    public int getHistorySizeLimit() {
        return this.historySizeLimit_;
    }

    public void setHistorySizeLimit(int historySizeLimit) {
        this.historySizeLimit_ = historySizeLimit;
    }

    public int getHistoryPageCacheLimit() {
        return this.historyPageCacheLimit_;
    }

    public void setHistoryPageCacheLimit(int historyPageCacheLimit) {
        this.historyPageCacheLimit_ = historyPageCacheLimit;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress_;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress_ = localAddress;
    }

    public void setDownloadImages(boolean downloadImages) {
        this.downloadImages_ = downloadImages;
    }

    public boolean isDownloadImages() {
        return this.downloadImages_;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth_ = screenWidth;
    }

    public int getScreenWidth() {
        return this.screenWidth_;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight_ = screenHeight;
    }

    public int getScreenHeight() {
        return this.screenHeight_;
    }

    public void setWebSocketEnabled(boolean enabled) {
        this.webSocketEnabled_ = enabled;
    }

    public boolean isWebSocketEnabled() {
        return this.webSocketEnabled_;
    }

    public int getWebSocketMaxTextMessageSize() {
        return this.webSocketMaxTextMessageSize_;
    }

    public void setWebSocketMaxTextMessageSize(int webSocketMaxTextMessageSize) {
        this.webSocketMaxTextMessageSize_ = webSocketMaxTextMessageSize;
    }

    public int getWebSocketMaxTextMessageBufferSize() {
        return this.webSocketMaxTextMessageBufferSize_;
    }

    public void setWebSocketMaxTextMessageBufferSize(int webSocketMaxTextMessageBufferSize) {
        this.webSocketMaxTextMessageBufferSize_ = webSocketMaxTextMessageBufferSize;
    }

    public int getWebSocketMaxBinaryMessageSize() {
        return this.webSocketMaxBinaryMessageSize_;
    }

    public void setWebSocketMaxBinaryMessageSize(int webSocketMaxBinaryMessageSize) {
        this.webSocketMaxBinaryMessageSize_ = webSocketMaxBinaryMessageSize;
    }

    public int getWebSocketMaxBinaryMessageBufferSize() {
        return this.webSocketMaxBinaryMessageBufferSize_;
    }

    public void setWebSocketMaxBinaryMessageBufferSize(int webSocketMaxBinaryMessageBufferSize) {
        this.webSocketMaxBinaryMessageBufferSize_ = webSocketMaxBinaryMessageBufferSize;
    }

    public void setFetchPolyfillEnabled(boolean enabled) {
        this.isFetchPolyfillEnabled_ = enabled;
    }

    public boolean isFetchPolyfillEnabled() {
        return this.isFetchPolyfillEnabled_;
    }

    public void setGeolocationEnabled(boolean enabled) {
        this.geolocationEnabled_ = enabled;
    }

    public boolean isGeolocationEnabled() {
        return this.geolocationEnabled_;
    }

    public Geolocation getGeolocation() {
        return this.geolocation_;
    }

    public void setGeolocation(Geolocation geolocation) {
        this.geolocation_ = geolocation;
    }

    public void setFileProtocolForXMLHttpRequestsAllowed(boolean fileProtocolForXMLHttpRequestsAllowed) {
        this.fileProtocolForXMLHttpRequestsAllowed_ = fileProtocolForXMLHttpRequestsAllowed;
    }

    public boolean isFileProtocolForXMLHttpRequestsAllowed() {
        return this.fileProtocolForXMLHttpRequestsAllowed_;
    }

    public static class Geolocation {
        private final double accuracy_;
        private final double latitude_;
        private final double longitude_;
        private final Double altitude_;
        private final Double altitudeAccuracy_;
        private final Double heading_;
        private final Double speed_;

        public Geolocation(double latitude, double longitude, double accuracy, Double altitude, Double altitudeAccuracy, Double heading, Double speed) {
            this.latitude_ = latitude;
            this.longitude_ = longitude;
            this.accuracy_ = accuracy;
            this.altitude_ = altitude;
            this.altitudeAccuracy_ = altitudeAccuracy;
            this.heading_ = heading;
            this.speed_ = speed;
        }

        public double getAccuracy() {
            return this.accuracy_;
        }

        public double getLatitude() {
            return this.latitude_;
        }

        public double getLongitude() {
            return this.longitude_;
        }

        public Double getAltitude() {
            return this.altitude_;
        }

        public Double getAltitudeAccuracy() {
            return this.altitudeAccuracy_;
        }

        public Double getHeading() {
            return this.heading_;
        }

        public Double getSpeed() {
            return this.speed_;
        }
    }
}

