/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.CssColors;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.impl.Color;
import org.htmlunit.util.StringUtils;

public abstract class AbstractCssStyleDeclaration
implements Serializable {
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(\\s*[\"']?(.*?)[\"']?\\s*\\)");
    private static final Pattern POSITION_PATTERN = Pattern.compile("(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex))\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN2 = Pattern.compile("(left|right|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN3 = Pattern.compile("(top|bottom|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|left|right|center)");

    public abstract String getStylePriority(String var1);

    public abstract String getCssText();

    public abstract String getStyleAttribute(String var1);

    public abstract String getStyleAttribute(StyleAttributes.Definition var1, boolean var2);

    public abstract boolean hasFeature(BrowserVersionFeatures var1);

    public abstract BrowserVersion getBrowserVersion();

    public String getStyleAttribute(StyleAttributes.Definition definition1, StyleAttributes.Definition definition2) {
        StyleElement element1 = this.getStyleElement(definition1.getAttributeName());
        StyleElement element2 = this.getStyleElement(definition2.getAttributeName());
        if (element2 == null) {
            if (element1 == null) {
                return "";
            }
            return element1.getValue();
        }
        if (element1 != null && element1.compareTo(element2) > 0) {
            return element1.getValue();
        }
        String[] values = StringUtils.splitAtJavaWhitespace(element2.getValue());
        if (definition1.name().contains("TOP")) {
            if (values.length > 0) {
                return values[0];
            }
            return "";
        }
        if (definition1.name().contains("RIGHT")) {
            if (values.length > 1) {
                return values[1];
            }
            if (values.length > 0) {
                return values[0];
            }
            return "";
        }
        if (definition1.name().contains("BOTTOM")) {
            if (values.length > 2) {
                return values[2];
            }
            if (values.length > 0) {
                return values[0];
            }
            return "";
        }
        if (definition1.name().contains("LEFT")) {
            if (values.length > 3) {
                return values[3];
            }
            if (values.length > 1) {
                return values[1];
            }
            if (values.length > 0) {
                return values[0];
            }
            return "";
        }
        throw new IllegalStateException("Unsupported definition: " + (Object)((Object)definition1));
    }

    public abstract void setCssText(String var1);

    public abstract void setStyleAttribute(String var1, String var2, String var3);

    public abstract String removeStyleAttribute(String var1);

    public abstract int getLength();

    public abstract String item(int var1);

    public abstract AbstractCSSRuleImpl getParentRule();

    public abstract StyleElement getStyleElement(String var1);

    public abstract StyleElement getStyleElementCaseInSensitive(String var1);

    public abstract Map<String, StyleElement> getStyleMap();

    public boolean isComputed() {
        return false;
    }

    public String getBackgroundAttachment() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_ATTACHMENT, false);
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, true);
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(bg)) {
                value = AbstractCssStyleDeclaration.findAttachment(bg);
                if (value == null) {
                    if (this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && !this.isComputed()) {
                        return "initial";
                    }
                    return "scroll";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    public String getBackgroundColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_COLOR, false);
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(bg)) {
                return "";
            }
            value = AbstractCssStyleDeclaration.findColor(bg);
            if (value == null) {
                if (this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
                    if (!this.isComputed()) {
                        return "initial";
                    }
                    return "rgba(0, 0, 0, 0)";
                }
                if (this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_RGBA)) {
                    return "rgba(0, 0, 0, 0)";
                }
                return "transparent";
            }
            return value;
        }
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            return "";
        }
        return value;
    }

    public String getBackgroundImage() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_IMAGE, false);
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(bg)) {
                value = AbstractCssStyleDeclaration.findImageUrl(bg);
                boolean backgroundInitial = this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                if (value == null) {
                    return backgroundInitial && !this.isComputed() ? "initial" : "none";
                }
                if (this.isComputed()) {
                    try {
                        value = value.substring(5, value.length() - 2);
                        DomElement domElement = ((ComputedCssStyleDeclaration)this).getDomElement();
                        return "url(\"" + domElement.getHtmlPageOrNull().getFullyQualifiedUrl(value) + "\")";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return value;
            }
            return "";
        }
        return value;
    }

    public String getBackgroundPosition() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_POSITION, false);
        if (value == null) {
            return null;
        }
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (bg == null) {
                return null;
            }
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(bg)) {
                value = AbstractCssStyleDeclaration.findPosition(bg);
                boolean isInitial = this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                if (value == null) {
                    if (isInitial) {
                        return this.isComputed() ? "" : "initial";
                    }
                    return "0% 0%";
                }
                if (this.isComputed()) {
                    String[] values = StringUtils.splitAtBlank(value);
                    switch (values[0]) {
                        case "left": {
                            values[0] = "0%";
                            break;
                        }
                        case "center": {
                            values[0] = "50%";
                            break;
                        }
                        case "right": {
                            values[0] = "100%";
                            break;
                        }
                    }
                    switch (values[1]) {
                        case "top": {
                            values[1] = "0%";
                            break;
                        }
                        case "center": {
                            values[1] = "50%";
                            break;
                        }
                        case "bottom": {
                            values[1] = "100%";
                            break;
                        }
                    }
                    value = values[0] + ' ' + values[1];
                }
                return value;
            }
            return "";
        }
        return value;
    }

    public String getBackgroundRepeat() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_REPEAT, false);
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(bg)) {
                value = AbstractCssStyleDeclaration.findRepeat(bg);
                if (value == null) {
                    if (this.hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && !this.isComputed()) {
                        return "initial";
                    }
                    return "repeat";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    public String getBorderBottomColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_COLOR, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderBottomStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_STYLE, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderBottomWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_BOTTOM_WIDTH, StyleAttributes.Definition.BORDER_BOTTOM);
    }

    public String getBorderLeftColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_COLOR, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderLeftStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_STYLE, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderLeftWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_LEFT_WIDTH, StyleAttributes.Definition.BORDER_LEFT);
    }

    private String getBorderWidth(StyleAttributes.Definition borderSideWidth, StyleAttributes.Definition borderSide) {
        String value = this.getStyleAttribute(borderSideWidth, false);
        if (value.isEmpty()) {
            String borderWidth;
            value = AbstractCssStyleDeclaration.findBorderWidth(this.getStyleAttribute(borderSide, false));
            if (value == null && !hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(borderWidth = this.getStyleAttribute(StyleAttributes.Definition.BORDER_WIDTH, false))) {
                String[] values = StringUtils.splitAtJavaWhitespace(borderWidth);
                int index = values.length;
                if (borderSideWidth.name().contains("TOP")) {
                    index = 0;
                } else if (borderSideWidth.name().contains("RIGHT")) {
                    index = 1;
                } else if (borderSideWidth.name().contains("BOTTOM")) {
                    index = 2;
                } else if (borderSideWidth.name().contains("LEFT")) {
                    index = 3;
                }
                if (index < values.length) {
                    value = values[index];
                }
            }
            if (value == null) {
                value = AbstractCssStyleDeclaration.findBorderWidth(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderRightColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_COLOR, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderRightStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_STYLE, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderRightWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_RIGHT_WIDTH, StyleAttributes.Definition.BORDER_RIGHT);
    }

    public String getBorderTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP, true);
    }

    public String getBorderTopColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP_COLOR, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderTopStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP_STYLE, false);
        if (value.isEmpty()) {
            value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP, false));
            if (value == null) {
                value = AbstractCssStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getBorderTopWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_TOP_WIDTH, StyleAttributes.Definition.BORDER_TOP);
    }

    public String getBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.BOTTOM, true);
    }

    public String getColor() {
        return this.getStyleAttribute(StyleAttributes.Definition.COLOR, true);
    }

    public String getCssFloat() {
        return this.getStyleAttribute(StyleAttributes.Definition.FLOAT, true);
    }

    public String getDisplay() {
        return this.getStyleAttribute(StyleAttributes.Definition.DISPLAY, true);
    }

    public String getFont() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT, true);
    }

    public String getFontFamily() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT_FAMILY, true);
    }

    public String getFontSize() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT_SIZE, true);
    }

    public String getHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
    }

    public String getLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.LEFT, true);
    }

    public String getLetterSpacing() {
        return this.getStyleAttribute(StyleAttributes.Definition.LETTER_SPACING, true);
    }

    public String getLineHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT, true);
    }

    public String getMargin() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN, true);
    }

    public String getMarginBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_BOTTOM, StyleAttributes.Definition.MARGIN);
    }

    public String getMarginLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_LEFT, StyleAttributes.Definition.MARGIN);
    }

    public String getMarginRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_RIGHT, StyleAttributes.Definition.MARGIN);
    }

    public String getMarginTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_TOP, StyleAttributes.Definition.MARGIN);
    }

    public String getMaxHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MAX_HEIGHT, true);
    }

    public String getMaxWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.MAX_WIDTH, true);
    }

    public String getMinHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MIN_HEIGHT, true);
    }

    public String getMinWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.MIN_WIDTH, true);
    }

    public String getOpacity() {
        String opacity = this.getStyleAttribute(StyleAttributes.Definition.OPACITY, false);
        if (opacity == null || opacity.isEmpty()) {
            return "";
        }
        String trimedOpacity = opacity.trim();
        try {
            double value = Double.parseDouble(trimedOpacity);
            if (value % 1.0 == 0.0) {
                return Integer.toString((int)value);
            }
            return Double.toString(value);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    public String getOrphans() {
        return this.getStyleAttribute(StyleAttributes.Definition.ORPHANS, true);
    }

    public String getOutline() {
        return this.getStyleAttribute(StyleAttributes.Definition.OUTLINE, true);
    }

    public String getOutlineWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.OUTLINE_WIDTH, true);
    }

    public String getPadding() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING, true);
    }

    public String getPaddingBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_BOTTOM, StyleAttributes.Definition.PADDING);
    }

    public String getPaddingLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_LEFT, StyleAttributes.Definition.PADDING);
    }

    public String getPaddingRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_RIGHT, StyleAttributes.Definition.PADDING);
    }

    public String getPaddingTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_TOP, StyleAttributes.Definition.PADDING);
    }

    public String getPosition() {
        return this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
    }

    public String getRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.RIGHT, true);
    }

    public String getRubyAlign() {
        return this.getStyleAttribute(StyleAttributes.Definition.RUBY_ALIGN, true);
    }

    public String getSize() {
        return this.getStyleAttribute(StyleAttributes.Definition.SIZE, true);
    }

    public String getTextIndent() {
        return this.getStyleAttribute(StyleAttributes.Definition.TEXT_INDENT, true);
    }

    public String getTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.TOP, true);
    }

    public String getVerticalAlign() {
        return this.getStyleAttribute(StyleAttributes.Definition.VERTICAL_ALIGN, true);
    }

    public String getWidows() {
        return this.getStyleAttribute(StyleAttributes.Definition.WIDOWS, true);
    }

    public String getWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
    }

    public String getWordSpacing() {
        return this.getStyleAttribute(StyleAttributes.Definition.WORD_SPACING, true);
    }

    public Object getZIndex() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.Z_INDEX_, true);
        try {
            Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String findAttachment(String text) {
        if (text.contains("scroll")) {
            return "scroll";
        }
        if (text.contains("fixed")) {
            return "fixed";
        }
        return null;
    }

    private static String findColor(String text) {
        String[] tokens;
        Color tmpColor = StringUtils.findColorRGB(text);
        if (tmpColor != null) {
            return StringUtils.formatColor(tmpColor);
        }
        for (String token : tokens = StringUtils.splitAtBlank(text)) {
            if (CssColors.isColorKeyword(token)) {
                return token;
            }
            tmpColor = StringUtils.asColorHexadecimal(token);
            if (tmpColor == null) continue;
            return StringUtils.formatColor(tmpColor);
        }
        return null;
    }

    private static String findImageUrl(String text) {
        Matcher m = URL_PATTERN.matcher(text);
        if (m.find()) {
            return "url(\"" + m.group(1) + "\")";
        }
        return null;
    }

    private static String findPosition(String text) {
        Matcher m = POSITION_PATTERN.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(3);
        }
        m = POSITION_PATTERN2.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(2);
        }
        m = POSITION_PATTERN3.matcher(text);
        if (m.find()) {
            return m.group(2) + " " + m.group(1);
        }
        return null;
    }

    private static String findRepeat(String text) {
        if (text.contains("repeat-x")) {
            return "repeat-x";
        }
        if (text.contains("repeat-y")) {
            return "repeat-y";
        }
        if (text.contains("no-repeat")) {
            return "no-repeat";
        }
        if (text.contains("repeat")) {
            return "repeat";
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : StringUtils.splitAtBlank(text)) {
            if (!AbstractCssStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isBorderStyle(String token) {
        return "none".equalsIgnoreCase(token) || "hidden".equalsIgnoreCase(token) || "dotted".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token) || "solid".equalsIgnoreCase(token) || "double".equalsIgnoreCase(token) || "groove".equalsIgnoreCase(token) || "ridge".equalsIgnoreCase(token) || "inset".equalsIgnoreCase(token) || "outset".equalsIgnoreCase(token);
    }

    private static String findBorderWidth(String text) {
        for (String token : StringUtils.splitAtBlank(text)) {
            if (!AbstractCssStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isBorderWidth(String token) {
        return "thin".equalsIgnoreCase(token) || "medium".equalsIgnoreCase(token) || "thick".equalsIgnoreCase(token) || AbstractCssStyleDeclaration.isLength(token);
    }

    static boolean isLength(String token) {
        if (token.endsWith("%")) {
            try {
                Double.parseDouble(token.substring(0, token.length() - 1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc")) {
            try {
                Double.parseDouble(token.substring(0, token.length() - 2));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }
}

