/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import org.htmlunit.BrowserVersion;

abstract class BrowserConfiguration {
    private final String defaultValue_;

    BrowserConfiguration(String defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    String getDefaultValue() {
        return this.defaultValue_;
    }

    abstract boolean matches(BrowserVersion var1);

    public boolean isIterable() {
        return true;
    }

    static BrowserConfiguration getMatchingConfiguration(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        for (BrowserConfiguration browserConfiguration : browserConfigurations) {
            if (!browserConfiguration.matches(browserVersion)) continue;
            return browserConfiguration;
        }
        return null;
    }

    static BrowserConfiguration chromeAndEdgeAuto() {
        return new ChromeAndEdge("auto");
    }

    static BrowserConfiguration chromeAndEdgeNone() {
        return new ChromeAndEdge("none");
    }

    static BrowserConfiguration chromeAndEdgeNormal() {
        return new ChromeAndEdge("normal");
    }

    static BrowserConfiguration chromeAndEdgeEmpty() {
        return new ChromeAndEdge("");
    }

    static BrowserConfiguration chromeAndEdge(String defaultValue) {
        return new ChromeAndEdge(defaultValue);
    }

    static BrowserConfiguration chrome(String defaultValue) {
        return new Chrome(defaultValue);
    }

    static BrowserConfiguration edge(String defaultValue) {
        return new Edge(defaultValue);
    }

    static BrowserConfiguration chromeAndEdgeAndFirefox(String defaultValue) {
        return new ChromeAndEdgeAndFirefox(defaultValue);
    }

    static BrowserConfiguration chromeAndEdgeNotIterable(String defaultValue) {
        return new ChromeAndEdgeNotIterable(defaultValue);
    }

    static BrowserConfiguration ffNone() {
        return new FF("none");
    }

    static BrowserConfiguration ffNormal() {
        return new FF("normal");
    }

    static BrowserConfiguration ff(String defaultValue) {
        return new FF(defaultValue);
    }

    static BrowserConfiguration ffNotIterable(String defaultValue) {
        return new FFNotIterable(defaultValue);
    }

    static BrowserConfiguration ffLatest(String defaultValue) {
        return new FFLatest(defaultValue);
    }

    static BrowserConfiguration ffEsr(String defaultValue) {
        return new FFESR(defaultValue);
    }

    private static class FFLatest
    extends BrowserConfiguration {
        FFLatest(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() > BrowserVersion.FIREFOX_ESR.getBrowserVersionNumeric();
        }
    }

    private static class FFESR
    extends BrowserConfiguration {
        FFESR(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() == BrowserVersion.FIREFOX_ESR.getBrowserVersionNumeric();
        }
    }

    private static class FFNotIterable
    extends BrowserConfiguration {
        FFNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }

        @Override
        public boolean isIterable() {
            return false;
        }
    }

    private static class FF
    extends BrowserConfiguration {
        FF(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }
    }

    private static class ChromeAndEdgeAndFirefox
    extends BrowserConfiguration {
        ChromeAndEdgeAndFirefox(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion.isEdge() || browserVersion.isFirefox();
        }
    }

    private static class ChromeAndEdge
    extends BrowserConfiguration {
        ChromeAndEdge(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion.isEdge();
        }
    }

    private static class Edge
    extends BrowserConfiguration {
        Edge(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isEdge();
        }
    }

    private static class Chrome
    extends BrowserConfiguration {
        Chrome(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome();
        }
    }

    static class ChromeAndEdgeNotIterable
    extends BrowserConfiguration {
        ChromeAndEdgeNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion.isEdge();
        }

        @Override
        public boolean isIterable() {
            return false;
        }
    }
}

