/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.serializer.HtmlSerializerNormalizedText;
import org.htmlunit.javascript.host.event.Event;
import org.w3c.dom.Node;

public class HtmlOption
extends HtmlElement
implements DisabledElement {
    public static final String TAG_NAME = "option";
    private boolean selected_;

    HtmlOption(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.reset();
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public Page setSelected(boolean selected) {
        this.setSelected(selected, true, false, false, false);
        return this.getPage();
    }

    public void setSelectedFromJavaScript(boolean selected) {
        this.setSelected(selected, false, false, true, false);
    }

    private void setSelected(boolean selected, boolean invokeOnFocus, boolean isClick, boolean shiftKey, boolean ctrlKey) {
        if (selected == this.isSelected()) {
            return;
        }
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            select.setSelectedAttribute(this, selected, invokeOnFocus, shiftKey, ctrlKey, isClick);
            return;
        }
        this.setSelectedInternal(selected);
    }

    @Override
    public void insertBefore(DomNode newNode) {
        HtmlOption option;
        super.insertBefore(newNode);
        if (newNode instanceof HtmlOption && (option = (HtmlOption)newNode).isSelected()) {
            this.getEnclosingSelect().setSelectedAttribute(option, true);
        }
    }

    public HtmlSelect getEnclosingSelect() {
        return (HtmlSelect)this.getEnclosingElement("select");
    }

    public void reset() {
        this.setSelectedInternal(this.hasAttribute("selected"));
    }

    public final String getSelectedAttribute() {
        return this.getAttributeDirect("selected");
    }

    public final boolean isDefaultSelected() {
        return this.hasAttribute("selected");
    }

    @Override
    public final boolean isDisabled() {
        if (this.hasAttribute("disabled")) {
            return true;
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof DisabledElement) || !((DisabledElement)((Object)node)).isDisabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttributeDirect("label");
    }

    public final void setLabelAttribute(String newLabel) {
        this.setAttribute("label", newLabel);
    }

    public final String getValueAttribute() {
        String value = this.getAttributeDirect("value");
        if (ATTRIBUTE_NOT_DEFINED == value) {
            value = this.getText();
        }
        return value;
    }

    public final void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        boolean changed = false;
        if (!this.isSelected()) {
            this.setSelected(true, true, true, shiftKey, ctrlKey);
            changed = true;
        } else if (this.getEnclosingSelect().isMultipleSelectEnabled()) {
            if (ctrlKey) {
                this.setSelected(false, true, true, shiftKey, ctrlKey);
                changed = true;
            } else {
                this.getEnclosingSelect().setOnlySelected(this, true);
            }
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return changed;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        super.printOpeningTagContentAsXml(printWriter);
        if (this.selected_ && this.getAttributeDirect("selected") == ATTRIBUTE_NOT_DEFINED) {
            printWriter.print(" selected=\"selected\"");
        }
    }

    void setSelectedInternal(boolean selected) {
        this.selected_ = selected;
    }

    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.removeAllChildren();
        } else {
            DomNode child = this.getFirstChild();
            if (child == null) {
                this.appendChild(new DomText(this.getPage(), text));
            } else {
                child.setNodeValue(text);
            }
        }
    }

    public String getText() {
        HtmlSerializerNormalizedText ser = new HtmlSerializerNormalizedText();
        ser.setIgnoreMaskedElements(false);
        return ser.asText(this);
    }

    @Override
    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        this.getEnclosingSelect().mouseOver(shiftKey, ctrlKey, altKey, button);
        return super.mouseOver(shiftKey, ctrlKey, altKey, button);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.BLOCK;
    }

    @Override
    public boolean handles(Event event) {
        if ("mouseover".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }

    @Override
    protected void basicRemove() {
        DomNode parent = this.getParentNode();
        super.basicRemove();
        if (parent != null && this.isSelected()) {
            parent.onAllChildrenAddedToPage(false);
        }
    }
}

