/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;

public class HtmlTitle
extends HtmlElement {
    public static final String TAG_NAME = "title";

    HtmlTitle(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setNodeValue(String message) {
        DomNode child = this.getFirstChild();
        if (child == null) {
            DomText textNode = new DomText(this.getPage(), message);
            this.appendChild(textNode);
        } else if (child instanceof DomText) {
            ((DomText)child).setData(message);
        } else {
            throw new IllegalStateException("For title tag, this should be a text node");
        }
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    public String getText() {
        DomNode firstChild = this.getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return "";
    }

    public void setText(String text) {
        DomNode firstChild = this.getFirstChild();
        if (firstChild == null) {
            firstChild = new DomText(this.getPage(), text);
            this.appendChild(firstChild);
        } else {
            firstChild.setNodeValue(text);
        }
    }
}

