/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import hidden.jth.org.apache.commons.lang3.function.FailableSupplier;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.javascript.HtmlUnitScriptableProxy;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLUnknownElement;

public class HtmlUnitScriptable
extends ScriptableObject
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(HtmlUnitScriptable.class);
    private DomNode domNode_;
    private String className_;

    @Override
    public String getClassName() {
        if (this.className_ != null) {
            return this.className_;
        }
        if (this.getPrototype() != null) {
            return this.getPrototype().getClassName();
        }
        String className = this.getClass().getSimpleName();
        if (className.isEmpty()) {
            className = this.getClass().getSuperclass().getSimpleName();
        }
        return className;
    }

    public void setClassName(String className) {
        this.className_ = className;
    }

    @Override
    public void setParentScope(Scriptable m) {
        if (m == this) {
            throw new IllegalArgumentException("Object can't be its own parentScope");
        }
        super.setParentScope(m);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        try {
            super.put(name, start, value);
        }
        catch (IllegalArgumentException e) {
            throw JavaScriptEngine.reportRuntimeError("'set " + name + "' called on an object that does not implement interface " + this.getClassName());
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            response = this.getWithPreemption(name);
        }
        if (response == NOT_FOUND && start instanceof Window) {
            response = ((Window)start).getWithFallback(name);
        }
        return response;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        Object found = this.get(index, start);
        if (Scriptable.NOT_FOUND != found && !JavaScriptEngine.isUndefined(found)) {
            return true;
        }
        return super.has(index, start);
    }

    public DomNode getDomNodeOrDie() {
        if (this.domNode_ == null) {
            throw new IllegalStateException("DomNode has not been set for this HtmlUnitScriptable: " + this.getClass().getName());
        }
        return this.domNode_;
    }

    public DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    public void setDomNode(DomNode domNode, boolean assignScriptObject) {
        WebAssert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptableObject(this);
        }
    }

    protected HtmlUnitScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (HtmlUnitScriptable)((WebWindow)object).getScriptableObject();
        }
        DomNode domNode = (DomNode)object;
        Object scriptObject = domNode.getScriptableObject();
        if (scriptObject != null) {
            return scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public HtmlUnitScriptable makeScriptableFor(DomNode domNode) {
        HtmlUnitScriptable scriptable;
        Class javaScriptClass = null;
        if (domNode instanceof HtmlImage && "image".equals(((HtmlImage)domNode).getOriginalQualifiedName()) && ((HtmlImage)domNode).wasCreatedByJavascript()) {
            if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT)) {
                javaScriptClass = HTMLElement.class;
            } else if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT)) {
                javaScriptClass = HTMLUnknownElement.class;
            }
        }
        if (javaScriptClass == null) {
            JavaScriptEngine javaScriptEngine = (JavaScriptEngine)this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine();
            for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
                javaScriptClass = javaScriptEngine.getJavaScriptClass(c);
            }
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No JavaScript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
            }
        } else {
            try {
                scriptable = (HtmlUnitScriptable)javaScriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, HtmlUnitScriptable scriptable) {
        SgmlPage page = domNode.getPage();
        WebWindow enclosingWindow = page.getEnclosingWindow();
        if (enclosingWindow != null && enclosingWindow.getEnclosedPage() == page) {
            scriptable.setParentScope((Scriptable)enclosingWindow.getScriptableObject());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope(page.getScriptableObject()));
        }
    }

    public Scriptable getPrototype(Class<? extends HtmlUnitScriptable> javaScriptClass) {
        Scriptable prototype = this.getWindow().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != HtmlUnitScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    public Window getWindow() throws RuntimeException {
        return HtmlUnitScriptable.getWindow(this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope(s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected static Window getWindowFromTopCallScope() throws RuntimeException {
        Scriptable top = JavaScriptEngine.getTopCallScope();
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window in scope");
    }

    public BrowserVersion getBrowserVersion() {
        WebWindow webWindow;
        DomNode node = this.getDomNodeOrNull();
        if (node != null) {
            return node.getPage().getWebClient().getBrowserVersion();
        }
        Window window = this.getWindow();
        if (window != null && (webWindow = window.getWebWindow()) != null) {
            return webWindow.getWebClient().getBrowserVersion();
        }
        return null;
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        if (this.getPrototype() == null) {
            Object prototype = this.get("prototype", (Scriptable)this);
            if (!(prototype instanceof ScriptableObject)) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(new Exception("Null prototype"));
            }
            return ((ScriptableObject)prototype).hasInstance(instance);
        }
        return super.hasInstance(instance);
    }

    @Override
    protected Object equivalentValues(Object value) {
        if (value instanceof HtmlUnitScriptableProxy) {
            value = ((HtmlUnitScriptableProxy)value).getDelegee();
        }
        return super.equivalentValues(value);
    }

    public HtmlUnitScriptable clone() {
        try {
            return (HtmlUnitScriptable)super.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    protected Object setupPromise(FailableSupplier<Object, IOException> resolver) {
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        LambdaConstructor ctor = (LambdaConstructor)HtmlUnitScriptable.getProperty(scope, "Promise");
        try {
            LambdaFunction resolve = (LambdaFunction)HtmlUnitScriptable.getProperty((Scriptable)ctor, "resolve");
            return resolve.call(Context.getCurrentContext(), this, ctor, new Object[]{resolver.get()});
        }
        catch (IOException e) {
            LambdaFunction reject = (LambdaFunction)HtmlUnitScriptable.getProperty((Scriptable)ctor, "reject");
            return reject.call(Context.getCurrentContext(), this, ctor, new Object[]{e.getMessage()});
        }
    }

    protected Object setupRejectedPromise(Supplier<Object> resolver) {
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        LambdaConstructor ctor = (LambdaConstructor)HtmlUnitScriptable.getProperty(scope, "Promise");
        LambdaFunction reject = (LambdaFunction)HtmlUnitScriptable.getProperty((Scriptable)ctor, "reject");
        return reject.call(Context.getCurrentContext(), this, ctor, new Object[]{resolver.get()});
    }
}

