/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import hidden.jth.org.apache.commons.lang3.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.css.AbstractCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.css.WrappedCssStyleDeclaration;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.css.ComputedFont;
import org.htmlunit.util.StringUtils;

@JsxClass
public class CSSStyleDeclaration
extends HtmlUnitScriptable {
    private static final Set<String> LENGTH_PROPERTIES_FFFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.BORDER_TOP_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_LEFT_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_RIGHT_WIDTH.getAttributeName(), StyleAttributes.Definition.LETTER_SPACING.getAttributeName()));
    private static final Set<String> LENGTH_PROPERTIES_TTFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.HEIGHT.getAttributeName(), StyleAttributes.Definition.WIDTH.getAttributeName(), StyleAttributes.Definition.TOP.getAttributeName(), StyleAttributes.Definition.LEFT.getAttributeName(), StyleAttributes.Definition.BOTTOM.getAttributeName(), StyleAttributes.Definition.RIGHT.getAttributeName(), StyleAttributes.Definition.MARGIN_TOP.getAttributeName(), StyleAttributes.Definition.MARGIN_LEFT.getAttributeName(), StyleAttributes.Definition.MARGIN_BOTTOM.getAttributeName(), StyleAttributes.Definition.MARGIN_RIGHT.getAttributeName(), StyleAttributes.Definition.MIN_HEIGHT.getAttributeName(), StyleAttributes.Definition.MIN_WIDTH.getAttributeName()));
    private static final Set<String> LENGTH_PROPERTIES_FTFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), StyleAttributes.Definition.TEXT_INDENT.getAttributeName(), StyleAttributes.Definition.PADDING_TOP.getAttributeName(), StyleAttributes.Definition.PADDING_LEFT.getAttributeName(), StyleAttributes.Definition.PADDING_BOTTOM.getAttributeName(), StyleAttributes.Definition.PADDING_RIGHT.getAttributeName(), StyleAttributes.Definition.MAX_HEIGHT.getAttributeName(), StyleAttributes.Definition.MAX_WIDTH.getAttributeName()));
    private static final String[] THIN_MED_THICK = new String[]{"thin", "medium", "thick"};
    private static final String[] ALIGN_KEYWORDS = new String[]{"baseline", "sub", "super", "text-top", "text-bottom", "middle", "top", "bottom", "inherit", "initial", "revert", "unset"};
    private AbstractCssStyleDeclaration styleDeclaration_;

    public CSSStyleDeclaration() {
    }

    @JsxConstructor
    public void jsConstructor(String type, ScriptableObject details) {
        throw JavaScriptEngine.typeError("CSSStyleDeclaration ctor is not available");
    }

    public CSSStyleDeclaration(Element element, AbstractCssStyleDeclaration styleDeclaration) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.setDomNode(element.getDomNodeOrNull(), false);
        if (styleDeclaration == null) {
            throw new IllegalStateException("styleDeclaration can't be null");
        }
        this.styleDeclaration_ = styleDeclaration;
    }

    CSSStyleDeclaration(CSSStyleSheet parentStyleSheet, WrappedCssStyleDeclaration styleDeclaration) {
        this.setParentScope(parentStyleSheet);
        this.setPrototype(this.getPrototype(this.getClass()));
        if (styleDeclaration == null) {
            throw new IllegalStateException("styleDeclaration can't be null");
        }
        this.styleDeclaration_ = styleDeclaration;
    }

    protected AbstractCssStyleDeclaration getCssStyleDeclaration() {
        return this.styleDeclaration_;
    }

    protected String getStylePriority(String name) {
        return this.styleDeclaration_.getStylePriority(name);
    }

    protected void setStyleAttribute(String name, String newValue) {
        this.setStyleAttribute(name, newValue, "");
    }

    protected void setStyleAttribute(String name, String newValue, String important) {
        if (null == newValue || "null".equals(newValue)) {
            newValue = "";
        }
        this.styleDeclaration_.setStyleAttribute(name, newValue, important);
    }

    private String removeStyleAttribute(String name) {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.removeStyleAttribute(name);
    }

    private Map<String, StyleElement> getStyleMap() {
        if (this.styleDeclaration_ == null) {
            return Collections.emptyMap();
        }
        return this.styleDeclaration_.getStyleMap();
    }

    @JsxGetter
    public String getBackgroundAttachment() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBackgroundAttachment();
    }

    @JsxSetter
    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_ATTACHMENT.getAttributeName(), backgroundAttachment);
    }

    @JsxGetter
    public String getBackgroundColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBackgroundColor();
    }

    @JsxSetter
    public void setBackgroundColor(String backgroundColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_COLOR.getAttributeName(), backgroundColor);
    }

    @JsxGetter
    public String getBackgroundImage() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBackgroundImage();
    }

    @JsxSetter
    public void setBackgroundImage(String backgroundImage) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_IMAGE.getAttributeName(), backgroundImage);
    }

    @JsxGetter
    public String getBackgroundPosition() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBackgroundPosition();
    }

    @JsxSetter
    public void setBackgroundPosition(String backgroundPosition) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_POSITION.getAttributeName(), backgroundPosition);
    }

    @JsxGetter
    public String getBackgroundRepeat() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBackgroundRepeat();
    }

    @JsxSetter
    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_REPEAT.getAttributeName(), backgroundRepeat);
    }

    @JsxGetter
    public String getBorderBottomColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderBottomColor();
    }

    @JsxSetter
    public void setBorderBottomColor(String borderBottomColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_COLOR.getAttributeName(), borderBottomColor);
    }

    @JsxGetter
    public String getBorderBottomStyle() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderBottomStyle();
    }

    @JsxSetter
    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_STYLE.getAttributeName(), borderBottomStyle);
    }

    @JsxGetter
    public String getBorderBottomWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderBottomWidth();
    }

    @JsxSetter
    public void setBorderBottomWidth(Object borderBottomWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_BOTTOM_WIDTH.getAttributeName(), borderBottomWidth, "", false, false, false, null);
    }

    @JsxGetter
    public String getBorderLeftColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderLeftColor();
    }

    @JsxSetter
    public void setBorderLeftColor(String borderLeftColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_COLOR.getAttributeName(), borderLeftColor);
    }

    @JsxGetter
    public String getBorderLeftStyle() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderLeftStyle();
    }

    @JsxSetter
    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_STYLE.getAttributeName(), borderLeftStyle);
    }

    @JsxGetter
    public String getBorderLeftWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderLeftWidth();
    }

    @JsxSetter
    public void setBorderLeftWidth(Object borderLeftWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_LEFT_WIDTH.getAttributeName(), borderLeftWidth, "", false, false, false, null);
    }

    @JsxGetter
    public String getBorderRightColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderRightColor();
    }

    @JsxSetter
    public void setBorderRightColor(String borderRightColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_COLOR.getAttributeName(), borderRightColor);
    }

    @JsxGetter
    public String getBorderRightStyle() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderRightStyle();
    }

    @JsxSetter
    public void setBorderRightStyle(String borderRightStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_STYLE.getAttributeName(), borderRightStyle);
    }

    @JsxGetter
    public String getBorderRightWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderRightWidth();
    }

    @JsxSetter
    public void setBorderRightWidth(Object borderRightWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_RIGHT_WIDTH.getAttributeName(), borderRightWidth, "", false, false, false, null);
    }

    @JsxGetter
    public String getBorderTop() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderTop();
    }

    @JsxSetter
    public void setBorderTop(String borderTop) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP.getAttributeName(), borderTop);
    }

    @JsxGetter
    public String getBorderTopColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderTopColor();
    }

    @JsxSetter
    public void setBorderTopColor(String borderTopColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP_COLOR.getAttributeName(), borderTopColor);
    }

    @JsxGetter
    public String getBorderTopStyle() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderTopStyle();
    }

    @JsxSetter
    public void setBorderTopStyle(String borderTopStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP_STYLE.getAttributeName(), borderTopStyle);
    }

    @JsxGetter
    public String getBorderTopWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBorderTopWidth();
    }

    @JsxSetter
    public void setBorderTopWidth(Object borderTopWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_TOP_WIDTH.getAttributeName(), borderTopWidth, "", false, false, false, null);
    }

    @JsxGetter
    public String getBottom() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getBottom();
    }

    @JsxSetter
    public void setBottom(Object bottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BOTTOM.getAttributeName(), bottom, "", true, true, false, null);
    }

    @JsxGetter
    public String getColor() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getColor();
    }

    @JsxSetter
    public void setColor(String color) {
        this.setStyleAttribute(StyleAttributes.Definition.COLOR.getAttributeName(), color);
    }

    @JsxGetter
    public String getCssFloat() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getCssFloat();
    }

    @JsxSetter
    public void setCssFloat(String value) {
        this.setStyleAttribute(StyleAttributes.Definition.FLOAT.getAttributeName(), value);
    }

    @JsxGetter
    public String getCssText() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getCssText();
    }

    @JsxSetter
    public void setCssText(String value) {
        String fixedValue = value;
        if (fixedValue == null || "null".equals(fixedValue)) {
            fixedValue = "";
        }
        this.styleDeclaration_.setCssText(fixedValue);
    }

    @JsxGetter
    public String getDisplay() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getDisplay();
    }

    @JsxSetter
    public void setDisplay(String display) {
        this.setStyleAttribute(StyleAttributes.Definition.DISPLAY.getAttributeName(), display);
    }

    @JsxGetter
    public String getFontSize() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getFontSize();
    }

    @JsxSetter
    public void setFontSize(Object fontSize) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), fontSize, "", false, true, false, null);
        this.updateFont(this.getFont(), false);
    }

    @JsxGetter
    public String getLineHeight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getLineHeight();
    }

    @JsxSetter
    public void setLineHeight(String lineHeight) {
        this.setStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT.getAttributeName(), lineHeight);
        this.updateFont(this.getFont(), false);
    }

    @JsxGetter
    public String getFontFamily() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getFontFamily();
    }

    @JsxSetter
    public void setFontFamily(String fontFamily) {
        this.setStyleAttribute(StyleAttributes.Definition.FONT_FAMILY.getAttributeName(), fontFamily);
        this.updateFont(this.getFont(), false);
    }

    private void updateFont(String font, boolean force) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        String[] details = ComputedFont.getDetails(font);
        if (details != null || force) {
            StringBuilder newFont = new StringBuilder();
            newFont.append(this.getFontSize());
            String lineHeight = this.getLineHeight();
            String defaultLineHeight = StyleAttributes.Definition.LINE_HEIGHT.getDefaultComputedValue(browserVersion);
            if (lineHeight.isEmpty()) {
                lineHeight = defaultLineHeight;
            }
            if (!lineHeight.equals(defaultLineHeight)) {
                newFont.append('/');
                if (lineHeight.equals(defaultLineHeight)) {
                    newFont.append(StyleAttributes.Definition.LINE_HEIGHT.getDefaultComputedValue(browserVersion));
                } else {
                    newFont.append(lineHeight);
                }
            }
            newFont.append(' ').append(this.getFontFamily());
            this.setStyleAttribute(StyleAttributes.Definition.FONT.getAttributeName(), newFont.toString());
        }
    }

    @JsxGetter
    public String getFont() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getFont();
    }

    @JsxSetter
    public void setFont(String font) {
        String[] details = ComputedFont.getDetails(font);
        if (details != null) {
            this.setStyleAttribute(StyleAttributes.Definition.FONT_FAMILY.getAttributeName(), details[5]);
            String fontSize = details[3];
            if (details[4] != null) {
                this.setStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT.getAttributeName(), details[4]);
            }
            this.setStyleAttribute(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), fontSize);
            this.updateFont(font, true);
        }
    }

    @JsxGetter
    public String getHeight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getHeight();
    }

    @JsxSetter
    public void setHeight(Object height) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.HEIGHT.getAttributeName(), height, "", true, true, false, null);
    }

    @JsxGetter
    public String getLeft() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getLeft();
    }

    @JsxSetter
    public void setLeft(Object left) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.LEFT.getAttributeName(), left, "", true, true, false, null);
    }

    @JsxGetter
    public int getLength() {
        if (this.styleDeclaration_ == null) {
            return 0;
        }
        return this.styleDeclaration_.getLength();
    }

    @JsxFunction
    public String item(int index) {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.item(index);
    }

    @JsxSymbol(symbolName="iterator")
    public Scriptable values() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }

    @JsxGetter
    public String getLetterSpacing() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getLetterSpacing();
    }

    @JsxSetter
    public void setLetterSpacing(Object letterSpacing) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.LETTER_SPACING.getAttributeName(), letterSpacing, "", false, false, false, null);
    }

    @JsxGetter
    public String getMargin() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMargin();
    }

    @JsxSetter
    public void setMargin(String margin) {
        this.setStyleAttribute(StyleAttributes.Definition.MARGIN.getAttributeName(), margin);
    }

    @JsxGetter
    public String getMarginBottom() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMarginBottom();
    }

    @JsxSetter
    public void setMarginBottom(Object marginBottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_BOTTOM.getAttributeName(), marginBottom, "", true, true, false, null);
    }

    @JsxGetter
    public String getMarginLeft() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMarginLeft();
    }

    @JsxSetter
    public void setMarginLeft(Object marginLeft) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_LEFT.getAttributeName(), marginLeft, "", true, true, false, null);
    }

    @JsxGetter
    public String getMarginRight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMarginRight();
    }

    @JsxSetter
    public void setMarginRight(Object marginRight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_RIGHT.getAttributeName(), marginRight, "", true, true, false, null);
    }

    @JsxGetter
    public String getMarginTop() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMarginTop();
    }

    @JsxSetter
    public void setMarginTop(Object marginTop) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_TOP.getAttributeName(), marginTop, "", true, true, false, null);
    }

    @JsxGetter
    public String getMaxHeight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMaxHeight();
    }

    @JsxSetter
    public void setMaxHeight(Object maxHeight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MAX_HEIGHT.getAttributeName(), maxHeight, "", false, true, false, null);
    }

    @JsxGetter
    public String getMaxWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMaxWidth();
    }

    @JsxSetter
    public void setMaxWidth(Object maxWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MAX_WIDTH.getAttributeName(), maxWidth, "", false, true, false, null);
    }

    @JsxGetter
    public String getMinHeight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMinHeight();
    }

    @JsxSetter
    public void setMinHeight(Object minHeight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MIN_HEIGHT.getAttributeName(), minHeight, "", true, true, false, null);
    }

    @JsxGetter
    public String getMinWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getMinWidth();
    }

    @JsxSetter
    public void setMinWidth(Object minWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MIN_WIDTH.getAttributeName(), minWidth, "", true, true, false, null);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this != start) {
            return super.get(name, start);
        }
        for (Scriptable prototype = this.getPrototype(); prototype != null; prototype = prototype.getPrototype()) {
            Object value = prototype.get(name, start);
            if (value != Scriptable.NOT_FOUND) {
                return value;
            }
            String camel = StringUtils.cssCamelize(name);
            if (name.equals(camel) || (value = prototype.get(camel, start)) == Scriptable.NOT_FOUND) continue;
            return value;
        }
        StyleAttributes.Definition style = StyleAttributes.getDefinition(name, this.getBrowserVersion());
        if (style != null) {
            return this.getStyleAttribute(style);
        }
        return super.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (index < 0) {
            return JavaScriptEngine.UNDEFINED;
        }
        Map<String, StyleElement> style = this.getStyleMap();
        int size = style.size();
        if (index >= size) {
            return JavaScriptEngine.UNDEFINED;
        }
        return style.keySet().toArray(new String[0])[index];
    }

    public final String getStyleAttribute(StyleAttributes.Definition definition) {
        return this.getStyleAttribute(definition, true);
    }

    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        if (this.styleDeclaration_ == null) {
            return "";
        }
        return this.styleDeclaration_.getStyleAttribute(definition, getDefaultValueIfEmpty);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        StyleAttributes.Definition style;
        if (this != start) {
            super.put(name, start, value);
            return;
        }
        Scriptable prototype = this.getPrototype();
        if (prototype != null && !"constructor".equals(name)) {
            if (prototype.get(name, start) != Scriptable.NOT_FOUND) {
                prototype.put(name, start, value);
                return;
            }
            String camel = StringUtils.cssCamelize(name);
            if (!name.equals(camel) && prototype.get(camel, start) != Scriptable.NOT_FOUND) {
                prototype.put(camel, start, value);
                return;
            }
        }
        if (this.getDomNodeOrNull() != null && (style = StyleAttributes.getDefinition(name, this.getBrowserVersion())) != null) {
            String stringValue = JavaScriptEngine.toString(value);
            this.setStyleAttribute(style.getAttributeName(), stringValue);
            return;
        }
        super.put(name, start, value);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        StyleAttributes.Definition style;
        if (this != start) {
            return super.has(name, start);
        }
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion != null && (style = StyleAttributes.getDefinition(name, this.getBrowserVersion())) != null) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public Object[] getIds() {
        Object[] normalIds;
        ArrayList<Object> ids = new ArrayList<Object>();
        for (StyleAttributes.Definition styleAttribute : StyleAttributes.getDefinitions(this.getBrowserVersion())) {
            ids.add(styleAttribute.getPropertyName());
        }
        for (Object o : normalIds = super.getIds()) {
            if (ids.contains(o)) continue;
            ids.add(o);
        }
        return ids.toArray();
    }

    @JsxGetter
    public String getOpacity() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getOpacity();
    }

    @JsxSetter
    public void setOpacity(Object opacity) {
        double doubleValue;
        if (JavaScriptEngine.isNaN(opacity)) {
            return;
        }
        if (opacity instanceof Number) {
            doubleValue = ((Number)opacity).doubleValue();
        } else {
            String valueString = JavaScriptEngine.toString(opacity);
            if (valueString.isEmpty()) {
                this.setStyleAttribute(StyleAttributes.Definition.OPACITY.getAttributeName(), valueString);
                return;
            }
            valueString = valueString.trim();
            try {
                doubleValue = Double.parseDouble(valueString);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return;
        }
        this.setStyleAttribute(StyleAttributes.Definition.OPACITY.getAttributeName(), Double.toString(doubleValue));
    }

    @JsxGetter
    public String getOutline() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getOutline();
    }

    @JsxSetter
    public void setOutline(String outline) {
        this.setStyleAttribute(StyleAttributes.Definition.OUTLINE.getAttributeName(), outline);
    }

    @JsxGetter
    public String getOutlineWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getOutlineWidth();
    }

    @JsxSetter
    public void setOutlineWidth(Object outlineWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName(), outlineWidth, "", false, false, true, THIN_MED_THICK);
    }

    @JsxGetter
    public String getPadding() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPadding();
    }

    @JsxSetter
    public void setPadding(String padding) {
        this.setStyleAttribute(StyleAttributes.Definition.PADDING.getAttributeName(), padding);
    }

    @JsxGetter
    public String getPaddingBottom() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPaddingBottom();
    }

    @JsxSetter
    public void setPaddingBottom(Object paddingBottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_BOTTOM.getAttributeName(), paddingBottom, "", false, true, false, null);
    }

    @JsxGetter
    public String getPaddingLeft() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPaddingLeft();
    }

    @JsxSetter
    public void setPaddingLeft(Object paddingLeft) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_LEFT.getAttributeName(), paddingLeft, "", false, true, false, null);
    }

    @JsxGetter
    public String getPaddingRight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPaddingRight();
    }

    @JsxSetter
    public void setPaddingRight(Object paddingRight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_RIGHT.getAttributeName(), paddingRight, "", false, true, false, null);
    }

    @JsxGetter
    public String getPaddingTop() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPaddingTop();
    }

    @JsxSetter
    public void setPaddingTop(Object paddingTop) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_TOP.getAttributeName(), paddingTop, "", false, true, false, null);
    }

    @JsxGetter
    public CSSRule getParentRule() {
        AbstractCSSRuleImpl parentRule = this.styleDeclaration_.getParentRule();
        if (parentRule != null) {
            return CSSRule.create((CSSStyleSheet)this.getParentScope(), parentRule);
        }
        return null;
    }

    @JsxSetter
    public void setParentRule(CSSRule parentRule) {
    }

    @JsxGetter
    public String getRight() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getRight();
    }

    @JsxSetter
    public void setRight(Object right) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.RIGHT.getAttributeName(), right, "", true, true, false, null);
    }

    @JsxGetter
    public String getRubyAlign() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getRubyAlign();
    }

    @JsxSetter
    public void setRubyAlign(String rubyAlign) {
        this.setStyleAttribute(StyleAttributes.Definition.RUBY_ALIGN.getAttributeName(), rubyAlign);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getSize() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getSize();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setSize(String size) {
        this.setStyleAttribute(StyleAttributes.Definition.SIZE.getAttributeName(), size);
    }

    @JsxGetter
    public String getTextIndent() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getTextIndent();
    }

    @JsxSetter
    public void setTextIndent(Object textIndent) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.TEXT_INDENT.getAttributeName(), textIndent, "", false, true, false, null);
    }

    @JsxGetter
    public String getTop() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getTop();
    }

    @JsxSetter
    public void setTop(Object top) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.TOP.getAttributeName(), top, "", true, true, false, null);
    }

    @JsxGetter
    public String getVerticalAlign() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getVerticalAlign();
    }

    @JsxSetter
    public void setVerticalAlign(Object verticalAlign) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName(), verticalAlign, "", false, true, false, ALIGN_KEYWORDS);
    }

    @JsxGetter
    public String getWidth() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getWidth();
    }

    @JsxSetter
    public void setWidth(Object width) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.WIDTH.getAttributeName(), width, "", true, true, false, null);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getWidows() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getWidows();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setWidows(String widows) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
            try {
                if (Integer.parseInt(widows) <= 0) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.setStyleAttribute(StyleAttributes.Definition.WIDOWS.getAttributeName(), widows);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getOrphans() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getOrphans();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOrphans(String orphans) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
            try {
                if (Integer.parseInt(orphans) <= 0) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.setStyleAttribute(StyleAttributes.Definition.ORPHANS.getAttributeName(), orphans);
    }

    @JsxGetter
    public String getPosition() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getPosition();
    }

    @JsxSetter
    public void setPosition(String position) {
        if (position.isEmpty() || "static".equalsIgnoreCase(position) || "absolute".equalsIgnoreCase(position) || "fixed".equalsIgnoreCase(position) || "relative".equalsIgnoreCase(position) || "initial".equalsIgnoreCase(position) || "inherit".equalsIgnoreCase(position)) {
            this.setStyleAttribute(StyleAttributes.Definition.POSITION.getAttributeName(), position.toLowerCase(Locale.ROOT));
        }
    }

    @JsxGetter
    public String getWordSpacing() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getWordSpacing();
    }

    @JsxSetter
    public void setWordSpacing(Object wordSpacing) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.WORD_SPACING.getAttributeName(), wordSpacing, "", false, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WORD_SPACING_ACCEPTS_PERCENT), false, null);
    }

    @JsxGetter
    public Object getZIndex() {
        if (this.styleDeclaration_ == null) {
            return null;
        }
        return this.styleDeclaration_.getZIndex();
    }

    @JsxSetter
    public void setZIndex(Object zIndex) {
        if (zIndex == null || hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(zIndex.toString())) {
            this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), "");
            return;
        }
        if (JavaScriptEngine.isUndefined(zIndex)) {
            return;
        }
        if (zIndex instanceof Number) {
            Number number = (Number)zIndex;
            if (number.doubleValue() % 1.0 == 0.0) {
                this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), Integer.toString(number.intValue()));
            }
            return;
        }
        try {
            int i = Integer.parseInt(zIndex.toString());
            this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), Integer.toString(i));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxFunction
    public String getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, StringUtils.cssCamelize(name))) instanceof String) {
            return (String)value;
        }
        return this.styleDeclaration_.getStyleAttribute(name);
    }

    @JsxFunction
    public String getPropertyPriority(String name) {
        return this.getStylePriority(name);
    }

    @JsxFunction
    public void setProperty(String name, Object value, String important) {
        String imp = "";
        if (!hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(important) && !"null".equals(important)) {
            if (!"important".equalsIgnoreCase(important)) {
                return;
            }
            imp = "important";
        }
        if (LENGTH_PROPERTIES_FFFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, false, false, false, null);
        } else if (LENGTH_PROPERTIES_TTFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, true, true, false, null);
        } else if (LENGTH_PROPERTIES_FTFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, false, true, false, null);
        } else if (StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName().equals(name)) {
            this.setStyleLengthAttribute(StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName(), value, imp, false, false, true, THIN_MED_THICK);
        } else if (StyleAttributes.Definition.WORD_SPACING.getAttributeName().equals(name)) {
            this.setStyleLengthAttribute(StyleAttributes.Definition.WORD_SPACING.getAttributeName(), value, imp, false, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WORD_SPACING_ACCEPTS_PERCENT), false, null);
        } else if (StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName().equals(name)) {
            this.setStyleLengthAttribute(StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName(), value, imp, false, true, false, null);
        } else {
            this.setStyleAttribute(name, JavaScriptEngine.toString(value), imp);
        }
    }

    @JsxFunction
    public String removeProperty(Object name) {
        return this.removeStyleAttribute(JavaScriptEngine.toString(name));
    }

    static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Double.parseDouble(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        if (this.styleDeclaration_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        return "CSSStyleDeclaration for '" + this.styleDeclaration_ + "'";
    }

    private void setStyleLengthAttribute(String name, Object value, String important, boolean auto, boolean percent, boolean unitRequired, String[] validValues) {
        String valueString;
        double doubleValue;
        if (JavaScriptEngine.isNaN(value)) {
            return;
        }
        String unit = "px";
        if (value instanceof Number) {
            if (unitRequired) {
                return;
            }
            doubleValue = ((Number)value).doubleValue();
        } else {
            valueString = JavaScriptEngine.toString(value);
            if (null == value) {
                valueString = "";
            }
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (auto && "auto".equals(valueString) || "initial".equals(valueString) || "inherit".equals(valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (validValues != null && ArrayUtils.contains(validValues, valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (percent && valueString.endsWith("%")) {
                unit = valueString.substring(valueString.length() - 1);
                valueString = valueString.substring(0, valueString.length() - 1);
            } else if (valueString.endsWith("px") || valueString.endsWith("em") || valueString.endsWith("ex") || valueString.endsWith("pt") || valueString.endsWith("cm") || valueString.endsWith("mm") || valueString.endsWith("in") || valueString.endsWith("pc") || valueString.endsWith("ch") || valueString.endsWith("vh") || valueString.endsWith("vw")) {
                unit = valueString.substring(valueString.length() - 2);
                valueString = valueString.substring(0, valueString.length() - 2);
            } else if (valueString.endsWith("rem") || valueString.endsWith("vmin") || valueString.endsWith("vmax")) {
                unit = valueString.substring(valueString.length() - 3);
                valueString = valueString.substring(0, valueString.length() - 3);
            } else if (unitRequired) {
                return;
            }
            if (!valueString.equals(valueString.trim())) {
                return;
            }
            doubleValue = JavaScriptEngine.toNumber(valueString);
        }
        try {
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                return;
            }
            valueString = doubleValue % 1.0 == 0.0 ? (int)doubleValue + unit : doubleValue + unit;
            this.setStyleAttribute(name, valueString, important);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

