/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class DOMTokenList
extends HtmlUnitScriptable {
    private static final String WHITESPACE_CHARS = " \t\r\n\f";
    private String attributeName_;

    public DOMTokenList() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public String getValue() {
        DomAttr attr;
        DomNode node = this.getDomNodeOrNull();
        if (node != null && (attr = (DomAttr)node.getAttributes().getNamedItem(this.attributeName_)) != null) {
            return attr.getValue();
        }
        return null;
    }

    @JsxSetter
    public void setValue(String value) {
        DomNode node = this.getDomNodeOrNull();
        if (node != null) {
            this.updateAttribute(value);
        }
    }

    @JsxGetter
    public int getLength() {
        String value = this.getValue();
        if (StringUtils.isBlank(value)) {
            return 0;
        }
        return DOMTokenList.split(value).size();
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        if (this.getPrototype() == null) {
            return (String)super.getDefaultValue(hint);
        }
        String value = this.getValue();
        if (value != null) {
            return String.join((CharSequence)" ", StringUtils.split(value, WHITESPACE_CHARS));
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (StringUtils.isEmpty(token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        List<String> parts = DOMTokenList.split(this.getValue());
        if (!parts.contains(token)) {
            parts.add(token);
        }
        this.updateAttribute(String.join((CharSequence)" ", parts));
    }

    @JsxFunction
    public void remove(String token) {
        if (StringUtils.isEmpty(token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        String value = this.getValue();
        if (value == null) {
            return;
        }
        List<String> parts = DOMTokenList.split(value);
        parts.remove(token);
        this.updateAttribute(String.join((CharSequence)" ", parts));
    }

    @JsxFunction
    public boolean replace(String oldToken, String newToken) {
        if (StringUtils.isEmpty(oldToken)) {
            throw JavaScriptEngine.reportRuntimeError("Empty oldToken not allowed");
        }
        if (StringUtils.containsAny((CharSequence)oldToken, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("oldToken contains whitespace");
        }
        if (StringUtils.isEmpty(newToken)) {
            throw JavaScriptEngine.reportRuntimeError("Empty newToken not allowed");
        }
        if (StringUtils.containsAny((CharSequence)newToken, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("newToken contains whitespace");
        }
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        List<String> parts = DOMTokenList.split(value);
        int pos = parts.indexOf(oldToken);
        if (pos == -1) {
            return false;
        }
        parts.set(pos, newToken);
        this.updateAttribute(String.join((CharSequence)" ", parts));
        return true;
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (StringUtils.isEmpty(token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("token contains whitespace");
        }
        List<String> parts = DOMTokenList.split(this.getValue());
        if (parts.contains(token)) {
            parts.remove(token);
            this.updateAttribute(String.join((CharSequence)" ", parts));
            return false;
        }
        parts.add(token);
        this.updateAttribute(String.join((CharSequence)" ", parts));
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        if (StringUtils.isBlank(token)) {
            return false;
        }
        if (StringUtils.isEmpty(token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("token contains whitespace");
        }
        List<String> parts = DOMTokenList.split(this.getValue());
        return parts.contains(token);
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            return null;
        }
        String value = this.getValue();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        List<String> parts = DOMTokenList.split(value);
        if (index < parts.size()) {
            return parts.get(index);
        }
        return null;
    }

    @JsxFunction
    public Scriptable keys() {
        return JavaScriptEngine.newArrayIteratorTypeKeys(this.getParentScope(), this);
    }

    @Override
    public Object[] getIds() {
        Object[] normalIds = super.getIds();
        String value = this.getValue();
        if (StringUtils.isEmpty(value)) {
            return normalIds;
        }
        List<String> parts = DOMTokenList.split(this.getValue());
        Object[] ids = new Object[parts.size() + normalIds.length];
        for (int i = 0; i < parts.size(); ++i) {
            ids[i] = i;
        }
        System.arraycopy(normalIds, 0, ids, parts.size(), normalIds.length);
        return ids;
    }

    @JsxFunction
    @JsxSymbol(symbolName="iterator")
    public Scriptable values() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }

    @JsxFunction
    public Scriptable entries() {
        return JavaScriptEngine.newArrayIteratorTypeEntries(this.getParentScope(), this);
    }

    @JsxFunction
    public void forEach(Object callback) {
        if (!(callback instanceof Function)) {
            throw JavaScriptEngine.typeError("Foreach callback '" + JavaScriptEngine.toString(callback) + "' is not a function");
        }
        String value = this.getValue();
        if (StringUtils.isEmpty(value)) {
            return;
        }
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        ContextAction<Object> contextAction = cx -> {
            Function function = (Function)callback;
            Scriptable scope = this.getParentScope();
            List<String> parts = DOMTokenList.split(value);
            for (int i = 0; i < parts.size(); ++i) {
                function.call(cx, scope, this, new Object[]{parts.get(i), i, this});
            }
            return null;
        };
        cf.call(contextAction);
    }

    @Override
    public Object get(int index, Scriptable start) {
        Object value = this.item(index);
        if (value == null) {
            return JavaScriptEngine.UNDEFINED;
        }
        return value;
    }

    private void updateAttribute(String value) {
        DomElement domNode = (DomElement)this.getDomNodeOrDie();
        DomAttr attr = domNode.getPage().createAttribute(this.attributeName_);
        attr.setValue(value);
        domNode.setAttributeNode(attr);
    }

    private static List<String> split(String value) {
        if (StringUtils.isEmpty(value)) {
            return new ArrayList<String>();
        }
        String[] parts = StringUtils.split(value, WHITESPACE_CHARS);
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            if (result.contains(part)) continue;
            result.add(part);
        }
        return result;
    }
}

