/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmbed;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlFrameSet;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRb;
import org.htmlunit.html.HtmlRp;
import org.htmlunit.html.HtmlRt;
import org.htmlunit.html.HtmlRtc;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.HtmlSvg;
import org.htmlunit.html.HtmlUnknownElement;
import org.htmlunit.html.UnknownElementFactory;
import org.htmlunit.html.impl.SimpleRange;
import org.htmlunit.http.HttpUtils;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.FontFaceSet;
import org.htmlunit.javascript.host.Location;
import org.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.animations.AnimationEvent;
import org.htmlunit.javascript.host.css.StyleSheetList;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.DOMImplementation;
import org.htmlunit.javascript.host.dom.DocumentFragment;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.NodeIterator;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.dom.Range;
import org.htmlunit.javascript.host.dom.Selection;
import org.htmlunit.javascript.host.dom.TreeWalker;
import org.htmlunit.javascript.host.dom.XPathNSResolver;
import org.htmlunit.javascript.host.dom.XPathResult;
import org.htmlunit.javascript.host.event.BeforeUnloadEvent;
import org.htmlunit.javascript.host.event.CloseEvent;
import org.htmlunit.javascript.host.event.CompositionEvent;
import org.htmlunit.javascript.host.event.CustomEvent;
import org.htmlunit.javascript.host.event.DragEvent;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.FocusEvent;
import org.htmlunit.javascript.host.event.HashChangeEvent;
import org.htmlunit.javascript.host.event.KeyboardEvent;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.javascript.host.event.MutationEvent;
import org.htmlunit.javascript.host.event.PointerEvent;
import org.htmlunit.javascript.host.event.PopStateEvent;
import org.htmlunit.javascript.host.event.ProgressEvent;
import org.htmlunit.javascript.host.event.TextEvent;
import org.htmlunit.javascript.host.event.UIEvent;
import org.htmlunit.javascript.host.event.WheelEvent;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.javascript.host.html.HTMLAllCollection;
import org.htmlunit.javascript.host.html.HTMLBodyElement;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFrameSetElement;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.UrlUtils;
import org.htmlunit.xpath.xml.utils.PrefixResolver;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.traversal.NodeFilter;

@JsxClass
public class Document
extends Node {
    private static final Log LOG;
    private static final Pattern TAG_NAME_PATTERN;
    private static final Set<String> EXECUTE_CMDS_FF;
    private static final Set<String> EXECUTE_CMDS_CHROME;
    private static final DateTimeFormatter LAST_MODIFIED_DATE_FORMATTER;
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM2_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_DOM3_EVENT_TYPE_MAP;
    private static final Map<String, Class<? extends Event>> SUPPORTED_VENDOR_EVENT_TYPE_MAP;
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;
    private String compatMode_;
    private int documentMode_ = -1;
    private String domain_;
    private String lastModified_;
    private ScriptableObject currentScript_;
    private transient FontFaceSet fonts_;
    private transient StyleSheetList styleSheetList_;
    private final Map<String, Blob> blobUrl2Blobs_ = new HashMap<String, Blob>();

    @Override
    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.reportRuntimeError("Illegal constructor.");
    }

    public void setWindow(Window window) {
        this.window_ = window;
    }

    @JsxGetter
    public Location getLocation() {
        if (this.window_ == null) {
            return null;
        }
        return this.window_.getLocation();
    }

    @JsxSetter
    public void setLocation(String location) throws IOException {
        this.window_.setLocation(location);
    }

    @JsxGetter
    public String getReferrer() {
        String referrer = "";
        WebResponse webResponse = this.getPage().getWebResponse();
        if (webResponse != null && (referrer = webResponse.getWebRequest().getAdditionalHeaders().get("Referer")) == null) {
            referrer = "";
        }
        return referrer;
    }

    @JsxGetter
    public Element getDocumentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    @JsxGetter
    public Element getRootElement() {
        return null;
    }

    @JsxGetter
    public HtmlUnitScriptable getDoctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    @JsxGetter
    public String getDesignMode() {
        if (this.designMode_ == null) {
            this.designMode_ = "off";
        }
        return this.designMode_;
    }

    @JsxSetter
    public void setDesignMode(String mode) {
        if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page != null && page.isHtmlPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SELECTION_RANGE_COUNT)) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                DomNode rangeNode = child == null ? htmlPage.getBody() : child;
                htmlPage.setSelectionRange(new SimpleRange(rangeNode, 0));
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    public SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    @JsxGetter
    public Object getDefaultView() {
        return this.getWindow();
    }

    @JsxFunction
    public Object createDocumentFragment() {
        DomDocumentFragment fragment = this.getDomNodeOrDie().getPage().createDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    @JsxFunction
    public Attr createAttribute(String attributeName) {
        return (Attr)this.getPage().createAttribute(attributeName).getScriptableObject();
    }

    @JsxFunction
    public HtmlUnitScriptable importNode(Node importedNode, boolean deep) {
        DomNode domNode = importedNode.getDomNodeOrDie();
        domNode = domNode.cloneNode(deep);
        domNode.processImportNode(this);
        for (DomNode childNode : domNode.getDescendants()) {
            childNode.processImportNode(this);
        }
        return domNode.getScriptableObject();
    }

    @JsxFunction
    public Object adoptNode(Node externalNode) {
        externalNode.remove();
        return this.importNode(externalNode, true);
    }

    @JsxGetter
    public DOMImplementation getImplementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    @JsxFunction
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public Object createTextNode(String newData) {
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            HtmlUnitScriptable jsElement = this.makeScriptableFor(domNode);
            if (jsElement == NOT_FOUND && LOG.isDebugEnabled()) {
                LOG.debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
            }
            return jsElement;
        }
        catch (ElementNotFoundException elementNotFoundException) {
            return NOT_FOUND;
        }
    }

    @JsxFunction
    public Object createComment(String comment) {
        DomComment domNode = new DomComment(this.getDomNodeOrDie().getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    @JsxFunction
    public XPathResult evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        try {
            XPathResult xPathResult = null;
            if (result instanceof XPathResult) {
                xPathResult = (XPathResult)result;
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_EVALUATE_RECREATES_RESULT)) {
                    xPathResult = new XPathResult();
                    xPathResult.setParentScope(this.getParentScope());
                    xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
                }
            } else if (result == null || JavaScriptEngine.isUndefined(result) || result instanceof ScriptableObject) {
                xPathResult = new XPathResult();
                xPathResult.setParentScope(this.getParentScope());
                xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
            } else {
                throw JavaScriptEngine.typeError("Argument 5 of Document.evaluate has to be an XPathResult or null.");
            }
            PrefixResolver prefixResolver = null;
            if (resolver instanceof NativeFunction) {
                prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
            } else if (resolver instanceof PrefixResolver) {
                prefixResolver = (PrefixResolver)resolver;
            }
            xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
            return xPathResult;
        }
        catch (Exception e) {
            throw JavaScriptEngine.reportRuntimeError("Failed to execute 'evaluate': " + e.getMessage());
        }
    }

    @JsxFunction
    public Object createElement(String tagName) {
        try {
            Matcher matcher;
            if (tagName.contains("<") || tagName.contains(">")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character; '<' and '>' are not allowed"));
                }
                throw JavaScriptEngine.reportRuntimeError("String contains an invalid character");
            }
            if (tagName.length() > 0 && tagName.charAt(0) == '<' && tagName.endsWith(">") && !(matcher = TAG_NAME_PATTERN.matcher(tagName = tagName.substring(1, tagName.length() - 1))).matches()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character"));
                }
                throw JavaScriptEngine.reportRuntimeError("String contains an invalid character");
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            if (element instanceof HtmlImage) {
                ((HtmlImage)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRb) {
                ((HtmlRb)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRp) {
                ((HtmlRp)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRt) {
                ((HtmlRt)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRtc) {
                ((HtmlRtc)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlUnknownElement) {
                ((HtmlUnknownElement)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlSvg) {
                element = UnknownElementFactory.INSTANCE.createElementNS(page, "", "svg", null);
                ((HtmlUnknownElement)element).markAsCreatedByJavascript();
            }
            HtmlUnitScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND && LOG.isDebugEnabled()) {
                LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
            }
            return jsElement;
        }
        catch (ElementNotFoundException elementNotFoundException) {
            return NOT_FOUND;
        }
    }

    @JsxFunction
    public Object createElementNS(String namespaceURI, String qualifiedName) {
        if ("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI)) {
            throw JavaScriptEngine.reportRuntimeError("XUL not available");
        }
        org.w3c.dom.Element element = "http://www.w3.org/1999/xhtml".equals(namespaceURI) || "http://www.w3.org/2000/svg".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null);
        return this.getScriptableFor(element);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), false);
        if ("*".equals(tagName)) {
            collection.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> true);
        } else {
            collection.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> tagName.equalsIgnoreCase(node.getNodeName()));
        }
        return collection;
    }

    @JsxFunction
    public Object getElementsByTagNameNS(Object namespaceURI, String localName) {
        HTMLCollection elements = new HTMLCollection(this.getDomNodeOrDie(), false);
        elements.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> localName.equals(node.getLocalName()));
        return elements;
    }

    @JsxGetter
    public Object getActiveElement() {
        return null;
    }

    @JsxGetter
    public String getCharacterSet() {
        if (!(this.getPage() instanceof HtmlPage)) {
            return "";
        }
        return this.getPage().getCharset().name();
    }

    @JsxGetter
    public String getCharset() {
        if (!(this.getPage() instanceof HtmlPage)) {
            return "";
        }
        return this.getPage().getCharset().name();
    }

    @JsxGetter
    public HTMLCollection getAnchors() {
        HTMLCollection anchors = new HTMLCollection(this.getDomNodeOrDie(), true);
        anchors.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
            if (!(node instanceof HtmlAnchor)) {
                return false;
            }
            HtmlAnchor anchor = (HtmlAnchor)node;
            return anchor.hasAttribute("name");
        });
        anchors.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
            if ("name".equals(event.getName()) || "id".equals(event.getName())) {
                return AbstractList.EffectOnCache.RESET;
            }
            return AbstractList.EffectOnCache.NONE;
        });
        return anchors;
    }

    @JsxGetter
    public HTMLCollection getApplets() {
        return new HTMLCollection(this.getDomNodeOrDie(), false);
    }

    @JsxGetter
    public HTMLElement getBody() {
        SgmlPage page = this.getPage();
        if (page instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)page;
            HtmlBody body = htmlPage.getBody();
            if (body != null) {
                return (HTMLElement)body.getScriptableObject();
            }
            HtmlElement doc = htmlPage.getDocumentElement();
            if (doc != null) {
                for (DomNode node : doc.getChildren()) {
                    if (!(node instanceof HtmlFrameSet)) continue;
                    return (HTMLElement)node.getScriptableObject();
                }
            }
        }
        return null;
    }

    @JsxSetter
    public void setBody(HTMLElement htmlElement) {
        if (htmlElement instanceof HTMLBodyElement || htmlElement instanceof HTMLFrameSetElement) {
            HtmlBody body;
            SgmlPage page = this.getPage();
            if (page instanceof HtmlPage && (body = ((HtmlPage)page).getBody()) != null) {
                body.replace(htmlElement.getDomNodeOrDie());
            }
            return;
        }
        throw JavaScriptEngine.reportRuntimeError("Failed to set the 'body' property on 'Document': The new body element is of type '" + htmlElement.getTagName() + "'. It must be either a 'BODY' or 'FRAMESET' element.");
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void close() throws IOException {
    }

    @JsxGetter
    public String getCompatMode() {
        this.getDocumentMode();
        return this.compatMode_;
    }

    public int getDocumentMode() {
        if (this.documentMode_ != -1) {
            return this.documentMode_;
        }
        this.compatMode_ = "CSS1Compat";
        if (this.isQuirksDocType()) {
            this.compatMode_ = "BackCompat";
        }
        float version = this.getBrowserVersion().getBrowserVersionNumeric();
        this.documentMode_ = (int)Math.floor(version);
        return this.documentMode_;
    }

    private boolean isQuirksDocType() {
        DocumentType docType = this.getPage().getDoctype();
        if (docType != null) {
            String systemId = docType.getSystemId();
            if (systemId != null) {
                String publicId;
                if ("http://www.w3.org/TR/html4/strict.dtd".equals(systemId)) {
                    return false;
                }
                if ("http://www.w3.org/TR/html4/loose.dtd".equals(systemId) && "-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicId = docType.getPublicId())) {
                    return false;
                }
                if ("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(systemId) || "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd".equals(systemId)) {
                    return false;
                }
            } else if (docType.getPublicId() == null) {
                return docType.getName() == null;
            }
        }
        return true;
    }

    public void forceDocumentMode(int documentMode) {
        this.documentMode_ = documentMode;
        this.compatMode_ = documentMode == 5 ? "BackCompat" : "CSS1Compat";
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw JavaScriptEngine.constructError("SyntaxError", "An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw JavaScriptEngine.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public boolean queryCommandSupported(String cmd) {
        return this.hasCommand(cmd, true);
    }

    private boolean hasCommand(String cmd, boolean includeBold) {
        if (null == cmd) {
            return false;
        }
        String cmdLC = cmd.toLowerCase(Locale.ROOT);
        if (this.getBrowserVersion().isChrome() || this.getBrowserVersion().isEdge()) {
            return EXECUTE_CMDS_CHROME.contains(cmdLC) || includeBold && "bold".equalsIgnoreCase(cmd);
        }
        return EXECUTE_CMDS_FF.contains(cmdLC);
    }

    @JsxFunction
    public boolean queryCommandEnabled(String cmd) {
        return this.hasCommand(cmd, true);
    }

    @JsxFunction
    public boolean execCommand(String cmd, boolean userInterface, Object value) {
        if (!this.hasCommand(cmd, false)) {
            return false;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Nothing done for execCommand(" + cmd + ", ...) (feature not implemented)"));
        }
        return true;
    }

    @JsxGetter(propertyName="URL")
    public String getURL_js() {
        return this.getPage().getUrl().toExternalForm();
    }

    @JsxGetter
    public String getDocumentURI() {
        return this.getURL_js();
    }

    @JsxGetter
    public String getCookie() {
        SgmlPage sgmlPage = this.getPage();
        StringBuilder builder = new StringBuilder();
        Set<Cookie> cookies = sgmlPage.getWebClient().getCookies(sgmlPage.getUrl());
        for (Cookie cookie : cookies) {
            if (cookie.isHttpOnly()) continue;
            if (builder.length() != 0) {
                builder.append("; ");
            }
            if (!"HTMLUNIT_EMPTY_COOKIE".equals(cookie.getName())) {
                builder.append(cookie.getName()).append('=');
            }
            builder.append(cookie.getValue());
        }
        return builder.toString();
    }

    @JsxSetter
    public void setCookie(String newCookie) {
        SgmlPage sgmlPage = this.getPage();
        WebClient client = sgmlPage.getWebClient();
        if (StringUtils.isBlank(newCookie) && client.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COOKIES_IGNORE_BLANK)) {
            return;
        }
        client.addCookie(newCookie, sgmlPage.getUrl(), this);
    }

    @JsxFunction
    public Event createEvent(String eventType) throws DOMException {
        Class<? extends Event> clazz = SUPPORTED_DOM2_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null) {
            clazz = SUPPORTED_DOM3_EVENT_TYPE_MAP.get(eventType);
            if (CloseEvent.class == clazz && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLOSE_DOCUMENT_CREATE_NOT_SUPPORTED)) {
                clazz = null;
            } else if (TextEvent.class == clazz && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_TEXTEVENT)) {
                clazz = CompositionEvent.class;
            }
        }
        if (MutationEvent.class == clazz && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_MUTATIONEVENT)) {
            clazz = null;
        } else if (clazz == null && ("Events".equals(eventType) || "HashChangeEvent".equals(eventType) || "BeforeUnloadEvent".equals(eventType) || "PopStateEvent".equals(eventType) || "FocusEvent".equals(eventType) || "WheelEvent".equals(eventType) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_WHEELEVENT) || "AnimationEvent".equals(eventType))) {
            clazz = SUPPORTED_VENDOR_EVENT_TYPE_MAP.get(eventType);
            if (PopStateEvent.class == clazz && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONPOPSTATE_DOCUMENT_CREATE_NOT_SUPPORTED)) {
                clazz = null;
            }
            if (AnimationEvent.class == clazz && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONANIMATION_DOCUMENT_CREATE_NOT_SUPPORTED)) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(new DOMException(9, "Event Type is not supported: " + eventType));
        }
        try {
            Event event = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            event.setParentScope(this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            event.eventCreated();
            return event;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw JavaScriptEngine.reportRuntimeError("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage());
        }
    }

    @JsxFunction
    public NodeIterator createNodeIterator(Node root, int whatToShow, Scriptable filter) {
        NodeFilter filterWrapper = Document.createFilterWrapper(filter, false);
        NodeIterator iterator = new NodeIterator(root, whatToShow, filterWrapper);
        iterator.setParentScope(this.getParentScope());
        iterator.setPrototype(this.getPrototype(iterator.getClass()));
        return iterator;
    }

    private static NodeFilter createFilterWrapper(Scriptable filter, boolean filterFunctionOnly) {
        NodeFilter filterWrapper = null;
        if (filter != null) {
            filterWrapper = n -> {
                Object response;
                Object[] args = new Object[]{((DomNode)n).getScriptableObject()};
                if (filter instanceof Callable) {
                    response = ((Callable)((Object)filter)).call(Context.getCurrentContext(), filter, filter, args);
                } else {
                    if (filterFunctionOnly) {
                        throw JavaScriptEngine.reportRuntimeError("only a function is allowed as filter");
                    }
                    response = ScriptableObject.callMethod(filter, "acceptNode", args);
                }
                return (short)JavaScriptEngine.toNumber(response);
            };
        }
        return filterWrapper;
    }

    @JsxFunction
    public Object createTreeWalker(Node root, double whatToShow, Scriptable filter, boolean expandEntityReferences) throws DOMException {
        int whatToShowI = (int)Double.valueOf(whatToShow).longValue();
        expandEntityReferences = false;
        NodeFilter filterWrapper = Document.createFilterWrapper(filter, false);
        TreeWalker t = new TreeWalker(root, whatToShowI, filterWrapper, expandEntityReferences);
        t.setParentScope(Document.getWindow(this));
        t.setPrototype(Document.staticGetPrototype(Document.getWindow(this), TreeWalker.class));
        return t;
    }

    private static Scriptable staticGetPrototype(Window window, Class<? extends HtmlUnitScriptable> javaScriptClass) {
        Scriptable prototype = window.getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != HtmlUnitScriptable.class) {
            return Document.staticGetPrototype(window, javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @JsxFunction
    public Range createRange() {
        Range range = new Range(this);
        range.setParentScope(this.getWindow());
        range.setPrototype(this.getPrototype(Range.class));
        return range;
    }

    @JsxGetter
    public String getDomain() {
        if (this.domain_ == null && this.getPage().getWebResponse() != null) {
            URL url = this.getPage().getUrl();
            if (url == UrlUtils.URL_ABOUT_BLANK) {
                WebWindow w = this.getWindow().getWebWindow();
                if (w instanceof FrameWindow) {
                    url = ((FrameWindow)w).getEnclosingPage().getUrl();
                } else {
                    return null;
                }
            }
            this.domain_ = url.getHost().toLowerCase(Locale.ROOT);
        }
        return this.domain_;
    }

    @JsxSetter
    public void setDomain(String newDomain) {
        newDomain = newDomain.toLowerCase(Locale.ROOT);
        String currentDomain = this.getDomain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(46) == -1) {
            throw JavaScriptEngine.reportRuntimeError("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\" (new domain has to contain a dot).");
        }
        if (currentDomain.indexOf(46) > -1 && !currentDomain.toLowerCase(Locale.ROOT).endsWith("." + newDomain.toLowerCase(Locale.ROOT))) {
            throw JavaScriptEngine.reportRuntimeError("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\"");
        }
        this.domain_ = newDomain;
    }

    @JsxSetter
    public void setOnclick(Object handler) {
        this.setEventHandler("click", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOndblclick(Object handler) {
        this.setEventHandler("dblclick", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOnblur(Object handler) {
        this.setEventHandler("blur", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxSetter
    public void setOnfocus(Object handler) {
        this.setEventHandler("focus", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter
    public void setOnkeydown(Object handler) {
        this.setEventHandler("keydown", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeypress(Object handler) {
        this.setEventHandler("keypress", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeyup(Object handler) {
        this.setEventHandler("keyup", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnmousedown(Object handler) {
        this.setEventHandler("mousedown", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousemove(Object handler) {
        this.setEventHandler("mousemove", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmouseout(Object handler) {
        this.setEventHandler("mouseout", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseover(Object handler) {
        this.setEventHandler("mouseover", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseup(Object handler) {
        this.setEventHandler("mouseup", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOncontextmenu(Object handler) {
        this.setEventHandler("contextmenu", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter
    public void setOnresize(Object handler) {
        this.setEventHandler("resize", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnerror(Object handler) {
        this.setEventHandler("error", handler);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setEventHandler("input", oninput);
    }

    @JsxGetter
    public boolean getHidden() {
        return false;
    }

    @Override
    @JsxGetter
    public int getChildElementCount() {
        int counter = 0;
        if (this.getPage().getDocumentElement() != null) {
            ++counter;
        }
        return counter;
    }

    @JsxFunction
    public Object elementFromPoint(int x, int y) {
        return null;
    }

    @JsxGetter
    public HTMLCollection getForms() {
        HTMLCollection forms = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                throw JavaScriptEngine.typeError("document.forms is not a function");
            }
        };
        forms.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof HtmlForm && node.getPrefix() == null);
        return forms;
    }

    @JsxGetter
    public HTMLCollection getEmbeds() {
        HTMLCollection embeds = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                throw JavaScriptEngine.typeError("document.embeds is not a function");
            }
        };
        embeds.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof HtmlEmbed);
        return embeds;
    }

    @JsxGetter
    public HTMLCollection getImages() {
        HTMLCollection images = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                throw JavaScriptEngine.typeError("document.images is not a function");
            }
        };
        images.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof HtmlImage);
        return images;
    }

    @JsxGetter
    public HTMLCollection getScripts() {
        HTMLCollection scripts = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                throw JavaScriptEngine.typeError("document.scripts is not a function");
            }
        };
        scripts.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof HtmlScript);
        return scripts;
    }

    @JsxGetter
    public StyleSheetList getStyleSheets() {
        if (this.styleSheetList_ == null) {
            this.styleSheetList_ = new StyleSheetList(this);
        }
        return this.styleSheetList_;
    }

    @JsxGetter
    public HTMLCollection getPlugins() {
        return this.getEmbeds();
    }

    @JsxGetter
    public HTMLCollection getLinks() {
        HTMLCollection links = new HTMLCollection(this.getDomNodeOrDie(), true);
        links.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
            HtmlElement node = event.getHtmlElement();
            if ((node instanceof HtmlAnchor || node instanceof HtmlArea) && "href".equals(event.getName())) {
                return AbstractList.EffectOnCache.RESET;
            }
            return AbstractList.EffectOnCache.NONE;
        });
        links.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> (node instanceof HtmlAnchor || node instanceof HtmlArea) && ((HtmlElement)node).hasAttribute("href"));
        return links;
    }

    @JsxFunction
    public HTMLCollection getElementsByClassName(String className) {
        return null;
    }

    @JsxFunction
    public NodeList getElementsByName(String elementName) {
        return null;
    }

    @JsxFunction
    public boolean hasFocus() {
        return false;
    }

    @JsxGetter
    public String getTitle() {
        return "";
    }

    @JsxSetter
    public void setTitle(String title) {
    }

    @Override
    @JsxGetter
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxGetter
    public String getContentType() {
        return this.getPage().getContentType();
    }

    @JsxFunction
    public Selection getSelection() {
        return null;
    }

    @JsxGetter
    public Object getHead() {
        return null;
    }

    @JsxGetter
    public String getInputEncoding() {
        return this.getPage().getCharset().name();
    }

    @JsxGetter
    public String getLastModified() {
        if (this.lastModified_ == null) {
            Date lastModified;
            WebResponse webResponse = this.getPage().getWebResponse();
            if (webResponse != null) {
                String stringDate = webResponse.getResponseHeaderValue("Last-Modified");
                if (stringDate == null) {
                    stringDate = webResponse.getResponseHeaderValue("Date");
                }
                lastModified = Document.parseDateOrNow(stringDate);
            } else {
                lastModified = new Date();
            }
            ZoneId zoneid = Context.getCurrentContext().getTimeZone().toZoneId();
            this.lastModified_ = LAST_MODIFIED_DATE_FORMATTER.format(lastModified.toInstant().atZone(zoneid));
        }
        return this.lastModified_;
    }

    private static Date parseDateOrNow(String stringDate) {
        Date date = HttpUtils.parseDate(stringDate);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void releaseCapture() {
    }

    @JsxGetter
    public String getReadyState() {
        return this.getDomNodeOrDie().getReadyState();
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction
    public void releaseEvents(String type) {
    }

    @JsxGetter
    public String getAlinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            return ((HTMLBodyElement)body).getALink();
        }
        return null;
    }

    @JsxSetter
    public void setAlinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setALink(color);
        }
    }

    @JsxGetter
    public String getBgColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            return ((HTMLBodyElement)body).getBgColor();
        }
        return null;
    }

    @JsxSetter
    public void setBgColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setBgColor(color);
        }
    }

    @JsxGetter
    public String getFgColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            return ((HTMLBodyElement)body).getText();
        }
        return null;
    }

    @JsxSetter
    public void setFgColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setText(color);
        }
    }

    @JsxGetter
    public String getLinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            return ((HTMLBodyElement)body).getLink();
        }
        return null;
    }

    @JsxSetter
    public void setLinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setLink(color);
        }
    }

    @JsxGetter
    public String getVlinkColor() {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            return ((HTMLBodyElement)body).getVLink();
        }
        return null;
    }

    @JsxSetter
    public void setVlinkColor(String color) {
        HTMLElement body = this.getBody();
        if (body instanceof HTMLBodyElement) {
            ((HTMLBodyElement)body).setVLink(color);
        }
    }

    @Override
    @JsxGetter
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    @JsxGetter
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getXmlEncoding() {
        return this.getPage().getXmlEncoding();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public boolean isXmlStandalone() {
        return this.getPage().getXmlStandalone();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getXmlVersion() {
        return this.getPage().getXmlVersion();
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setEventHandler("abort", onabort);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnauxclick(Object onauxclick) {
        this.setEventHandler("auxclick", onauxclick);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnbeforecopy() {
        return this.getEventHandler("beforecopy");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecopy(Object onbeforecopy) {
        this.setEventHandler("beforecopy", onbeforecopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnbeforecut() {
        return this.getEventHandler("beforecut");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecut(Object onbeforecut) {
        this.setEventHandler("beforecut", onbeforecut);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnbeforepaste() {
        return this.getEventHandler("beforepaste");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforepaste(Object onbeforepaste) {
        this.setEventHandler("beforepaste", onbeforepaste);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncancel(Object oncancel) {
        this.setEventHandler("cancel", oncancel);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setEventHandler("canplay", oncanplay);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setEventHandler("canplaythrough", oncanplaythrough);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setEventHandler("change", onchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnclose(Object onclose) {
        this.setEventHandler("close", onclose);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncopy() {
        return this.getEventHandler("copy");
    }

    @JsxSetter
    public void setOncopy(Object oncopy) {
        this.setEventHandler("copy", oncopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncuechange(Object oncuechange) {
        this.setEventHandler("cuechange", oncuechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncut() {
        return this.getEventHandler("cut");
    }

    @JsxSetter
    public void setOncut(Object oncut) {
        this.setEventHandler("cut", oncut);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setEventHandler("drag", ondrag);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setEventHandler("dragend", ondragend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setEventHandler("dragenter", ondragenter);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setEventHandler("dragleave", ondragleave);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setEventHandler("dragover", ondragover);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setEventHandler("dragstart", ondragstart);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setEventHandler("drop", ondrop);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setEventHandler("durationchange", ondurationchange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setEventHandler("emptied", onemptied);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setEventHandler("ended", onended);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setEventHandler("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter
    public void setOninvalid(Object oninvalid) {
        this.setEventHandler("invalid", oninvalid);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setEventHandler("loadeddata", onloadeddata);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setEventHandler("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setEventHandler("loadstart", onloadstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setEventHandler("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter
    public void setOnmouseenter(Object onmouseenter) {
        this.setEventHandler("mouseenter", onmouseenter);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter
    public void setOnmouseleave(Object onmouseleave) {
        this.setEventHandler("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setEventHandler("mousewheel", onmousewheel);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpaste() {
        return this.getEventHandler("paste");
    }

    @JsxSetter
    public void setOnpaste(Object onpaste) {
        this.setEventHandler("paste", onpaste);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setEventHandler("pause", onpause);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setEventHandler("play", onplay);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setEventHandler("playing", onplaying);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointercancel(Object onpointercancel) {
        this.setEventHandler("pointercancel", onpointercancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerdown(Object onpointerdown) {
        this.setEventHandler("pointerdown", onpointerdown);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerenter(Object onpointerenter) {
        this.setEventHandler("pointerenter", onpointerenter);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerleave(Object onpointerleave) {
        this.setEventHandler("pointerleave", onpointerleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerlockchange() {
        return this.getEventHandler("pointerlockchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerlockchange(Object onpointerlockchange) {
        this.setEventHandler("pointerlockchange", onpointerlockchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerlockerror() {
        return this.getEventHandler("pointerlockerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerlockerror(Object onpointerlockerror) {
        this.setEventHandler("pointerlockerror", onpointerlockerror);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointermove(Object onpointermove) {
        this.setEventHandler("pointermove", onpointermove);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerout(Object onpointerout) {
        this.setEventHandler("pointerout", onpointerout);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerover(Object onpointerover) {
        this.setEventHandler("pointerover", onpointerover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerup(Object onpointerup) {
        this.setEventHandler("pointerup", onpointerup);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setEventHandler("progress", onprogress);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setEventHandler("ratechange", onratechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnreadystatechange() {
        return this.getEventHandler("readystatechange");
    }

    @JsxSetter
    public void setOnreadystatechange(Object onreadystatechange) {
        this.setEventHandler("readystatechange", onreadystatechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setEventHandler("reset", onreset);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setEventHandler("scroll", onscroll);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnsearch(Object onsearch) {
        this.setEventHandler("search", onsearch);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setEventHandler("seeked", onseeked);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setEventHandler("seeking", onseeking);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setEventHandler("select", onselect);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnselectionchange() {
        return this.getEventHandler("selectionchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnselectionchange(Object onselectionchange) {
        this.setEventHandler("selectionchange", onselectionchange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnselectstart() {
        return this.getEventHandler("selectstart");
    }

    @JsxSetter
    public void setOnselectstart(Object onselectstart) {
        this.setEventHandler("selectstart", onselectstart);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setEventHandler("stalled", onstalled);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandler("submit", onsubmit);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setEventHandler("suspend", onsuspend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setEventHandler("timeupdate", ontimeupdate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOntoggle(Object ontoggle) {
        this.setEventHandler("toggle", ontoggle);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setEventHandler("volumechange", onvolumechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setEventHandler("waiting", onwaiting);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkitfullscreenchange() {
        return this.getEventHandler("webkitfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenchange(Object onwebkitfullscreenchange) {
        this.setEventHandler("webkitfullscreenchange", onwebkitfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkitfullscreenerror() {
        return this.getEventHandler("webkitfullscreenerror");
    }

    @JsxSetter
    public void setOnwebkitfullscreenerror(Object onwebkitfullscreenerror) {
        this.setEventHandler("webkitfullscreenerror", onwebkitfullscreenerror);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    @JsxSetter
    public void setOnwheel(Object onwheel) {
        this.setEventHandler("wheel", onwheel);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnafterscriptexecute() {
        return this.getEventHandler("afterscriptexecute");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnafterscriptexecute(Object onafterscriptexecute) {
        this.setEventHandler("afterscriptexecute", onafterscriptexecute);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnbeforescriptexecute() {
        return this.getEventHandler("beforescriptexecute");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnbeforescriptexecute(Object onbeforescriptexecute) {
        this.setEventHandler("beforescriptexecute", onbeforescriptexecute);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setEventHandler("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setEventHandler("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter
    public ScriptableObject getCurrentScript() {
        return this.currentScript_;
    }

    public void setCurrentScript(ScriptableObject script) {
        this.currentScript_ = script;
    }

    @JsxGetter
    public ScriptableObject getFonts() {
        if (this.fonts_ == null) {
            FontFaceSet fonts = new FontFaceSet();
            fonts.setParentScope(this.getWindow());
            fonts.setPrototype(this.getPrototype(fonts.getClass()));
            this.fonts_ = fonts;
        }
        return this.fonts_;
    }

    @JsxGetter
    public HTMLCollection getAll() {
        HTMLAllCollection all = new HTMLAllCollection(this.getDomNodeOrDie());
        all.setAvoidObjectDetection(true);
        all.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> true);
        return all;
    }

    @JsxFunction
    public HtmlUnitScriptable getElementById(String id) {
        DomNode domNode = this.getDomNodeOrDie();
        Object domElement = domNode.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement != null) {
            return ((DomElement)domElement).getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object createProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getPage().createProcessingInstruction(target, data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public Object createCDATASection(String data) {
        CDATASection node = this.getPage().createCDATASection(data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public void clear() {
    }

    @Override
    @JsxFunction
    public boolean contains(Object element) {
        return this.getDocumentElement().contains(element);
    }

    public String generateBlobUrl(Blob blob) {
        URL url = this.getPage().getUrl();
        String origin = "null";
        if (!UrlUtils.URL_ABOUT_BLANK.equals(url)) {
            origin = url.getProtocol() + "://" + url.getAuthority();
        }
        String blobUrl = "blob:" + origin + "/" + UUID.randomUUID();
        this.blobUrl2Blobs_.put(blobUrl, blob);
        return blobUrl;
    }

    public Blob resolveBlobUrl(String url) {
        return this.blobUrl2Blobs_.get(url);
    }

    public void revokeBlobUrl(String url) {
        this.blobUrl2Blobs_.remove(url);
    }

    static {
        String[] cmds;
        LOG = LogFactory.getLog(Document.class);
        TAG_NAME_PATTERN = Pattern.compile("\\w+");
        EXECUTE_CMDS_FF = new HashSet<String>();
        EXECUTE_CMDS_CHROME = new HashSet<String>();
        LAST_MODIFIED_DATE_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
        HashMap<String, Class> dom2EventMap = new HashMap<String, Class>();
        dom2EventMap.put("HTMLEvents", Event.class);
        dom2EventMap.put("MouseEvents", MouseEvent.class);
        dom2EventMap.put("MutationEvents", MutationEvent.class);
        dom2EventMap.put("UIEvents", UIEvent.class);
        SUPPORTED_DOM2_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom2EventMap);
        HashMap<String, Class<TextEvent>> dom3EventMap = new HashMap<String, Class<TextEvent>>();
        dom3EventMap.put("Event", Event.class);
        dom3EventMap.put("KeyboardEvent", KeyboardEvent.class);
        dom3EventMap.put("MouseEvent", MouseEvent.class);
        dom3EventMap.put("MessageEvent", MessageEvent.class);
        dom3EventMap.put("MutationEvent", MutationEvent.class);
        dom3EventMap.put("UIEvent", UIEvent.class);
        dom3EventMap.put("CustomEvent", CustomEvent.class);
        dom3EventMap.put("CloseEvent", CloseEvent.class);
        dom3EventMap.put("CompositionEvent", CompositionEvent.class);
        dom3EventMap.put("DragEvent", DragEvent.class);
        dom3EventMap.put("TextEvent", TextEvent.class);
        SUPPORTED_DOM3_EVENT_TYPE_MAP = Collections.unmodifiableMap(dom3EventMap);
        HashMap<String, Class> additionalEventMap = new HashMap<String, Class>();
        additionalEventMap.put("BeforeUnloadEvent", BeforeUnloadEvent.class);
        additionalEventMap.put("Events", Event.class);
        additionalEventMap.put("HashChangeEvent", HashChangeEvent.class);
        additionalEventMap.put("KeyEvents", KeyboardEvent.class);
        additionalEventMap.put("PointerEvent", PointerEvent.class);
        additionalEventMap.put("PopStateEvent", PopStateEvent.class);
        additionalEventMap.put("ProgressEvent", ProgressEvent.class);
        additionalEventMap.put("FocusEvent", FocusEvent.class);
        additionalEventMap.put("WheelEvent", WheelEvent.class);
        additionalEventMap.put("AnimationEvent", AnimationEvent.class);
        SUPPORTED_VENDOR_EVENT_TYPE_MAP = Collections.unmodifiableMap(additionalEventMap);
        for (String cmd : cmds = new String[]{"BackColor", "BackgroundImageCache", "Bold", "CreateLink", "Delete", "FontName", "FontSize", "ForeColor", "FormatBlock", "Indent", "InsertHorizontalRule", "InsertImage", "InsertOrderedList", "InsertParagraph", "InsertUnorderedList", "Italic", "JustifyCenter", "JustifyFull", "JustifyLeft", "JustifyNone", "JustifyRight", "Outdent", "Print", "Redo", "RemoveFormat", "SelectAll", "StrikeThrough", "Subscript", "Superscript", "Underline", "Undo", "Unlink", "Unselect"}) {
            if ("Bold".equals(cmd)) continue;
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
        for (String cmd : cmds = new String[]{"backColor", "bold", "contentReadOnly", "copy", "createLink", "cut", "decreaseFontSize", "delete", "fontName", "fontSize", "foreColor", "formatBlock", "heading", "hiliteColor", "increaseFontSize", "indent", "insertHorizontalRule", "insertHTML", "insertImage", "insertOrderedList", "insertUnorderedList", "insertParagraph", "italic", "justifyCenter", "JustifyFull", "justifyLeft", "justifyRight", "outdent", "paste", "redo", "removeFormat", "selectAll", "strikeThrough", "subscript", "superscript", "underline", "undo", "unlink", "useCSS", "styleWithCSS"}) {
            EXECUTE_CMDS_FF.add(cmd.toLowerCase(Locale.ROOT));
            if ("bold".equals(cmd)) continue;
            EXECUTE_CMDS_CHROME.add(cmd.toLowerCase(Locale.ROOT));
        }
    }
}

