/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.HashSet;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.impl.SimpleRange;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.ClientRect;
import org.htmlunit.javascript.host.ClientRectList;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.AbstractRange;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass
public class Range
extends AbstractRange {
    @JsxConstant
    public static final int START_TO_START = 0;
    @JsxConstant
    public static final int START_TO_END = 1;
    @JsxConstant
    public static final int END_TO_END = 2;
    @JsxConstant
    public static final int END_TO_START = 3;

    public Range() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    public Range(Document document) {
        super(document, document, 0, 0);
    }

    Range(SimpleRange simpleRange) {
        super((Node)simpleRange.getStartContainer().getScriptableObject(), (Node)simpleRange.getEndContainer().getScriptableObject(), simpleRange.getStartOffset(), simpleRange.getEndOffset());
    }

    @JsxFunction
    public void setStart(Node refNode, int offset) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setStart() with a null node.");
        }
        this.internSetStartContainer(refNode);
        this.internSetStartOffset(offset);
    }

    @JsxFunction
    public void setStartAfter(Node refNode) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setStartAfter() with a null node.");
        }
        this.internSetStartContainer(refNode.getParent());
        this.internSetStartOffset(Range.getPositionInContainer(refNode) + 1);
    }

    @JsxFunction
    public void setStartBefore(Node refNode) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setStartBefore() with a null node.");
        }
        this.internSetStartContainer(refNode.getParent());
        this.internSetStartOffset(Range.getPositionInContainer(refNode));
    }

    private static int getPositionInContainer(Node refNode) {
        int i = 0;
        Node node = refNode;
        while (node.getPreviousSibling() != null) {
            node = node.getPreviousSibling();
            ++i;
        }
        return i;
    }

    @JsxFunction
    public void setEnd(Node refNode, int offset) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setEnd() with a null node.");
        }
        this.internSetEndContainer(refNode);
        this.internSetEndOffset(offset);
    }

    @JsxFunction
    public void setEndAfter(Node refNode) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setEndAfter() with a null node.");
        }
        this.internSetEndContainer(refNode.getParent());
        this.internSetEndOffset(Range.getPositionInContainer(refNode) + 1);
    }

    @JsxFunction
    public void setEndBefore(Node refNode) {
        if (refNode == null) {
            throw JavaScriptEngine.reportRuntimeError("It is illegal to call Range.setEndBefore() with a null node.");
        }
        this.internSetStartContainer(refNode.getParent());
        this.internSetStartOffset(Range.getPositionInContainer(refNode));
    }

    @JsxFunction
    public void selectNodeContents(Node refNode) {
        this.internSetStartContainer(refNode);
        this.internSetStartOffset(0);
        this.internSetEndContainer(refNode);
        this.internSetEndOffset(refNode.getChildNodes().getLength());
    }

    @JsxFunction
    public void selectNode(Node refNode) {
        this.setStartBefore(refNode);
        this.setEndAfter(refNode);
    }

    @JsxFunction
    public void collapse(boolean toStart) {
        if (toStart) {
            this.internSetEndContainer(this.internGetStartContainer());
            this.internSetEndOffset(this.internGetStartOffset());
        } else {
            this.internSetStartContainer(this.internGetEndContainer());
            this.internSetStartOffset(this.internGetEndOffset());
        }
    }

    @JsxGetter
    public Object getCommonAncestorContainer() {
        Node ancestor;
        HashSet<Node> startAncestors = new HashSet<Node>();
        for (ancestor = this.internGetStartContainer(); ancestor != null; ancestor = ancestor.getParent()) {
            startAncestors.add(ancestor);
        }
        for (ancestor = this.internGetEndContainer(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!startAncestors.contains(ancestor)) continue;
            return ancestor;
        }
        return JavaScriptEngine.UNDEFINED;
    }

    @JsxFunction
    public HtmlUnitScriptable createContextualFragment(String valueAsString) {
        SgmlPage page = this.internGetStartContainer().getDomNodeOrDie().getPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        try {
            page.getWebClient().getPageCreator().getHtmlParser().parseFragment(fragment, this.internGetStartContainer().getDomNodeOrDie(), valueAsString, false);
        }
        catch (Exception e) {
            LogFactory.getLog(Range.class).error((Object)"Unexpected exception occurred in createContextualFragment", (Throwable)e);
            throw JavaScriptEngine.reportRuntimeError("Unexpected exception occurred in createContextualFragment: " + e.getMessage());
        }
        return fragment.getScriptableObject();
    }

    @JsxFunction
    public HtmlUnitScriptable extractContents() {
        try {
            return this.getSimpleRange().extractContents().getScriptableObject();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public Object compareBoundaryPoints(int how, Range sourceRange) {
        int offsetForOther;
        Node nodeForOther;
        int containingMoficator;
        int offsetForThis;
        Node nodeForThis;
        if (0 == how || 3 == how) {
            nodeForThis = this.internGetStartContainer();
            offsetForThis = this.internGetStartOffset();
            containingMoficator = 1;
        } else {
            nodeForThis = this.internGetEndContainer();
            offsetForThis = this.internGetEndOffset();
            containingMoficator = -1;
        }
        if (1 == how || 0 == how) {
            nodeForOther = sourceRange.internGetStartContainer();
            offsetForOther = sourceRange.internGetStartOffset();
        } else {
            nodeForOther = sourceRange.internGetEndContainer();
            offsetForOther = sourceRange.internGetEndOffset();
        }
        if (nodeForThis == nodeForOther) {
            if (offsetForThis < offsetForOther) {
                return -1;
            }
            if (offsetForThis > offsetForOther) {
                return 1;
            }
            return 0;
        }
        byte nodeComparision = (byte)nodeForThis.compareDocumentPosition(nodeForOther);
        if ((nodeComparision & 0x10) != 0) {
            return -1 * containingMoficator;
        }
        if ((nodeComparision & 2) != 0) {
            return -1;
        }
        return 1;
    }

    @JsxFunction
    public HtmlUnitScriptable cloneContents() {
        try {
            return this.getSimpleRange().cloneContents().getScriptableObject();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public void deleteContents() {
        try {
            this.getSimpleRange().deleteContents();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public void insertNode(Node newNode) {
        try {
            this.getSimpleRange().insertNode(newNode.getDomNodeOrDie());
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public void surroundContents(Node newNode) {
        try {
            this.getSimpleRange().surroundContents(newNode.getDomNodeOrDie());
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public Object cloneRange() {
        try {
            return new Range(this.getSimpleRange().cloneRange());
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public void detach() {
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        try {
            return this.getSimpleRange().toString();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public ClientRectList getClientRects() {
        Window w = this.getWindow();
        ClientRectList rectList = new ClientRectList();
        rectList.setParentScope(w);
        rectList.setPrototype(this.getPrototype(rectList.getClass()));
        try {
            for (DomNode node : this.getSimpleRange().containedNodes()) {
                Object scriptable = node.getScriptableObject();
                if (!(scriptable instanceof HTMLElement)) continue;
                ClientRect rect = new ClientRect(0, 0, 1, 1);
                rect.setParentScope(w);
                rect.setPrototype(this.getPrototype(rect.getClass()));
                rectList.add(rect);
            }
            return rectList;
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }

    @JsxFunction
    public ClientRect getBoundingClientRect() {
        ClientRect rect = new ClientRect();
        rect.setParentScope(this.getWindow());
        rect.setPrototype(this.getPrototype(rect.getClass()));
        try {
            for (DomNode node : this.getSimpleRange().containedNodes()) {
                Object scriptable = node.getScriptableObject();
                if (!(scriptable instanceof HTMLElement)) continue;
                ClientRect childRect = ((HTMLElement)scriptable).getBoundingClientRect();
                rect.setTop(Math.min(rect.getTop(), childRect.getTop()));
                rect.setLeft(Math.min(rect.getLeft(), childRect.getLeft()));
                rect.setRight(Math.max(rect.getRight(), childRect.getRight()));
                rect.setBottom(Math.max(rect.getBottom(), childRect.getBottom()));
            }
            return rect;
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError(e.getMessage());
        }
    }
}

