/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.host.html.HTMLCollection;

@JsxClass
public class HTMLAllCollection
extends HTMLCollection {
    public HTMLAllCollection() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    public HTMLAllCollection(DomNode parentScope) {
        super(parentScope, false);
    }

    @Override
    public Object item(Object index) {
        double numb;
        if (index instanceof String) {
            String name = (String)index;
            Object result = this.namedItem(name);
            if (null != result && !JavaScriptEngine.isUndefined(result)) {
                return result;
            }
            numb = JavaScriptEngine.toNumber(index);
            if (Double.isNaN(numb)) {
                return null;
            }
        } else {
            numb = JavaScriptEngine.toNumber(index);
        }
        if (numb < 0.0) {
            return null;
        }
        if (Double.isInfinite(numb) || numb != Math.floor(numb)) {
            return null;
        }
        Object object = this.get((int)numb, (Scriptable)this);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @Override
    public final Object namedItem(String name) {
        List<DomNode> elements = this.getElements();
        ArrayList<DomElement> matching = new ArrayList<DomElement>();
        for (DomNode next : elements) {
            DomElement elem;
            if (!(next instanceof DomElement) || !name.equals((elem = (DomElement)next).getAttributeDirect("name")) && !name.equals(elem.getId())) continue;
            matching.add(elem);
        }
        if (matching.size() == 1) {
            return this.getScriptableForElement(matching.get(0));
        }
        if (matching.isEmpty()) {
            return null;
        }
        DomNode domNode = this.getDomNodeOrNull();
        ArrayList<DomNode> nodes = new ArrayList<DomNode>(matching);
        HTMLCollection collection = new HTMLCollection(domNode, nodes);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean nullIfNotFound = false;
        if (args[0] instanceof Number) {
            double val = ((Number)args[0]).doubleValue();
            if (val != (double)((int)val)) {
                return null;
            }
            if (val >= 0.0) {
                nullIfNotFound = true;
            }
        } else {
            String val = JavaScriptEngine.toString(args[0]);
            try {
                args[0] = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Object value = super.call(cx, scope, thisObj, args);
        if (nullIfNotFound && JavaScriptEngine.isUndefined(value)) {
            return null;
        }
        return value;
    }

    @Override
    protected boolean supportsParentheses() {
        return true;
    }
}

