/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.util.UrlUtils;

@JsxClass(domClass=HtmlAnchor.class)
public class HTMLAnchorElement
extends HTMLElement {
    private static final List<String> REFERRER_POLICIES = Arrays.asList("no-referrer", "origin", "unsafe-url");

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == hrefAttr) {
            return "";
        }
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return hrefAttr;
        }
    }

    @Override
    public void focus() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != hrefAttr) {
            anchor.focus();
        }
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttributeDirect("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getDomNodeOrDie().setAttribute("href", url.toString());
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter
    public String getReferrerPolicy() {
        String attrib = this.getDomNodeOrDie().getAttribute("referrerPolicy");
        if (StringUtils.isEmpty(attrib)) {
            return "";
        }
        if (REFERRER_POLICIES.contains(attrib = attrib.toLowerCase(Locale.ROOT))) {
            return attrib;
        }
        return "";
    }

    @JsxSetter
    public void setReferrerPolicy(String referrerPolicy) {
        this.getDomNodeOrDie().setAttribute("referrerPolicy", referrerPolicy);
    }

    @JsxGetter
    public String getSearch() {
        try {
            String query = this.getUrl().getQuery();
            if (query == null) {
                return "";
            }
            return "?" + query;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    @JsxGetter
    public String getHash() {
        try {
            String hash = this.getUrl().getRef();
            if (hash == null) {
                return "";
            }
            return "#" + hash;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    @JsxGetter
    public String getHost() {
        try {
            URL url = this.getUrl();
            int port = url.getPort();
            String host = url.getHost();
            if (port == -1) {
                return host;
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getHostname() {
        try {
            return UrlUtils.encodeAnchor(this.getUrl().getHost());
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_HOSTNAME_IGNORE_BLANK)) {
            if (!StringUtils.isBlank(hostname)) {
                this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
            }
        } else if (!StringUtils.isEmpty(hostname)) {
            this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
        }
    }

    @JsxGetter
    public String getPathname() {
        BrowserVersion browser = this.getBrowserVersion();
        try {
            HtmlAnchor anchor;
            String href;
            if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL_REPLACE)) {
                HtmlAnchor anchor2 = (HtmlAnchor)this.getDomNodeOrDie();
                String href2 = anchor2.getHrefAttribute();
                if (href2.length() > 1 && Character.isLetter(href2.charAt(0)) && ':' == href2.charAt(1)) {
                    if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_UPPER_CASE_DRIVE_LETTERS)) {
                        href2 = StringUtils.capitalize(href2);
                    }
                    if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_PREFIX_WIN_DRIVES_URL)) {
                        href2 = "/" + href2;
                    }
                    return href2;
                }
            } else if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute()).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
                return href.substring(2);
            }
            return this.getUrl().getPath();
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http")) {
                return "";
            }
            return "/";
        }
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() {
        try {
            int port = this.getUrl().getPort();
            if (port == -1) {
                return "";
            }
            return Integer.toString(port);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() {
        BrowserVersion browser = this.getBrowserVersion();
        try {
            HtmlAnchor anchor;
            String href;
            if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL_REPLACE) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute().toLowerCase(Locale.ROOT)).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
                return "file:";
            }
            return this.getUrl().getProtocol() + ":";
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http")) {
                return ":";
            }
            return StringUtils.substringBefore(anchor.getHrefAttribute(), "/");
        }
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        if (protocol.isEmpty()) {
            return;
        }
        String bareProtocol = StringUtils.substringBefore(protocol, ":").trim();
        if (!UrlUtils.isValidScheme(bareProtocol)) {
            return;
        }
        if (!UrlUtils.isSpecialScheme(bareProtocol)) {
            return;
        }
        try {
            URL url = UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol);
            url = UrlUtils.removeRedundantPort(url);
            this.setUrl(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    static String getDefaultValue(HtmlElement element) {
        String href = element.getAttributeDirect("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            return "";
        }
        href = href.trim();
        SgmlPage page = element.getPage();
        if (page == null || !page.isHtmlPage()) {
            return href;
        }
        try {
            return HtmlAnchor.getTargetUrl(href, (HtmlPage)page).toExternalForm();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        return htmlElement.asNormalizedText();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.setTextContent(text);
    }

    @JsxGetter
    public String getCharset() {
        return this.getDomNodeOrDie().getAttributeDirect("charset");
    }

    @JsxSetter
    public void setCharset(String charset) {
        this.getDomNodeOrDie().setAttribute("charset", charset);
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttributeDirect("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }

    @JsxGetter
    public String getHreflang() {
        return this.getDomNodeOrDie().getAttributeDirect("hreflang");
    }

    @JsxSetter
    public void setHreflang(String hreflang) {
        this.getDomNodeOrDie().setAttribute("hreflang", hreflang);
    }

    @JsxGetter
    public String getOrigin() {
        if (!this.getDomNodeOrDie().hasAttribute("href")) {
            return "";
        }
        try {
            return this.getUrl().getProtocol() + "://" + this.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsxGetter
    public String getUsername() {
        try {
            String userInfo = this.getUrl().getUserInfo();
            if (userInfo == null) {
                return "";
            }
            return StringUtils.substringBefore(userInfo, 58);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setUsername(String username) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserName(url, username));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter
    public String getPassword() {
        try {
            String userName = this.getUrl().getUserInfo();
            if (userName == null) {
                return "";
            }
            return StringUtils.substringAfter(userName, ":");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setPassword(String password) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserPassword(url, password));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter
    public String getDownload() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getDownloadAttribute();
    }

    @JsxSetter
    public void setDownload(String download) {
        this.getDomNodeOrDie().setAttribute("download", download);
    }

    @JsxGetter
    public String getPing() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getPingAttribute();
    }

    @JsxSetter
    public void setPing(String ping) {
        this.getDomNodeOrDie().setAttribute("ping", ping);
    }

    @JsxGetter
    public String getShape() {
        return this.getDomNodeOrDie().getAttribute("shape");
    }

    @JsxSetter
    public void setShape(String shape) {
        this.getDomNodeOrDie().setAttribute("shape", shape);
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttributeDirect("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @JsxSetter
    public void setRelList(Object rel) {
        this.setRel(JavaScriptEngine.toString(rel));
    }
}

