/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.xml;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.htmlunit.FormEncodingType;
import org.htmlunit.WebRequest;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.javascript.host.file.File;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.util.NameValuePair;

@JsxClass
public class FormData
extends HtmlUnitScriptable {
    public static final String FORM_DATA_TAG = "FormData";
    private final List<NameValuePair> requestParameters_ = new ArrayList<NameValuePair>();

    @JsxConstructor
    public void jsConstructor(Object formObj) {
        if (formObj instanceof HTMLFormElement) {
            HTMLFormElement form = (HTMLFormElement)formObj;
            this.requestParameters_.addAll(form.getHtmlForm().getParameterListForSubmit(null));
        }
    }

    @JsxFunction
    public void append(String name, Object value, Object filename) {
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            String fileName = "blob";
            if (value instanceof File) {
                fileName = null;
            }
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            this.requestParameters_.add(blob.getKeyDataPair(name, fileName));
            return;
        }
        this.requestParameters_.add(new NameValuePair(name, JavaScriptEngine.toString(value)));
    }

    @JsxFunction(functionName="delete")
    public void delete_js(String name) {
        if (StringUtils.isEmpty(name)) {
            return;
        }
        this.requestParameters_.removeIf(pair -> name.equals(pair.getName()));
    }

    @JsxFunction
    public String get(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return pair.getValue();
        }
        return null;
    }

    @JsxFunction
    public Scriptable getAll(String name) {
        if (StringUtils.isEmpty(name)) {
            return JavaScriptEngine.newArray((Scriptable)this, 0);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            values.add(pair.getValue());
        }
        Object[] stringValues = values.toArray(new Object[0]);
        return JavaScriptEngine.newArray((Scriptable)this, stringValues);
    }

    @JsxFunction
    public boolean has(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public void set(String name, Object value, Object filename) {
        if (StringUtils.isEmpty(name)) {
            return;
        }
        int pos = -1;
        Iterator<NameValuePair> iter = this.requestParameters_.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            NameValuePair pair = iter.next();
            if (name.equals(pair.getName())) {
                iter.remove();
                if (pos < 0) {
                    pos = idx;
                }
            }
            ++idx;
        }
        if (pos < 0) {
            pos = this.requestParameters_.size();
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            String fileName = "blob";
            if (value instanceof File) {
                fileName = null;
            }
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            this.requestParameters_.add(pos, blob.getKeyDataPair(name, fileName));
        } else {
            this.requestParameters_.add(pos, new NameValuePair(name, JavaScriptEngine.toString(value)));
        }
    }

    @JsxFunction
    @JsxSymbol(symbolName="iterator")
    public Scriptable entries() {
        return new FormDataIterator(this, "FormData Iterator", FormDataIterator.Type.BOTH, this.requestParameters_);
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setEncodingType(FormEncodingType.MULTIPART);
        webRequest.setRequestParameters(this.requestParameters_);
    }

    @JsxFunction
    public void forEach(Object callback) {
        if (!(callback instanceof Function)) {
            throw JavaScriptEngine.typeError("Foreach callback '" + JavaScriptEngine.toString(callback) + "' is not a function");
        }
        Function fun = (Function)callback;
        for (int i = 0; i < this.requestParameters_.size(); ++i) {
            NameValuePair param = this.requestParameters_.get(i);
            fun.call(Context.getCurrentContext(), this.getParentScope(), this, new Object[]{param.getValue(), param.getName(), this});
        }
    }

    @JsxFunction
    public Object keys() {
        return new FormDataIterator(this.getParentScope(), "FormData Iterator", FormDataIterator.Type.KEYS, this.requestParameters_);
    }

    @JsxFunction
    public Object values() {
        return new FormDataIterator(this.getParentScope(), "FormData Iterator", FormDataIterator.Type.VALUES, this.requestParameters_);
    }

    public static final class FormDataIterator
    extends ES6Iterator {
        private final Type type_;
        private final String className_;
        private final List<NameValuePair> nameValuePairList_;
        private int index_;

        public static void init(ScriptableObject scope, String className) {
            ES6Iterator.init(scope, false, new FormDataIterator(className), FormData.FORM_DATA_TAG);
        }

        public FormDataIterator(String className) {
            this.type_ = Type.BOTH;
            this.index_ = 0;
            this.nameValuePairList_ = Collections.emptyList();
            this.className_ = className;
        }

        public FormDataIterator(Scriptable scope, String className, Type type, List<NameValuePair> nameValuePairList) {
            super(scope, FormData.FORM_DATA_TAG);
            this.type_ = type;
            this.index_ = 0;
            this.nameValuePairList_ = nameValuePairList;
            this.className_ = className;
        }

        @Override
        public String getClassName() {
            return this.className_;
        }

        @Override
        protected boolean isDone(Context cx, Scriptable scope) {
            return this.index_ >= this.nameValuePairList_.size();
        }

        @Override
        protected Object nextValue(Context cx, Scriptable scope) {
            if (this.isDone(cx, scope)) {
                return Context.getUndefinedValue();
            }
            NameValuePair nextNameValuePair = this.nameValuePairList_.get(this.index_++);
            switch (this.type_) {
                case KEYS: {
                    return nextNameValuePair.getName();
                }
                case VALUES: {
                    return nextNameValuePair.getValue();
                }
                case BOTH: {
                    return cx.newArray(scope, new Object[]{nextNameValuePair.getName(), nextNameValuePair.getValue()});
                }
            }
            throw new AssertionError();
        }

        static enum Type {
            KEYS,
            VALUES,
            BOTH;

        }
    }
}

