/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.svg;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.ScriptElement;
import org.htmlunit.html.ScriptElementSupport;
import org.htmlunit.svg.SvgElement;

public class SvgScript
extends SvgElement
implements ScriptElement {
    public static final String TAG_NAME = "script";
    private boolean executed_;
    private boolean createdByDomParser_;

    SvgScript(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    public boolean isExecuted() {
        return this.executed_;
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed_ = executed;
    }

    @Override
    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    protected final String getSrcAttributeNormalized() {
        String attrib = this.getAttributeDirect("src");
        if (ATTRIBUTE_NOT_DEFINED == attrib) {
            return attrib;
        }
        return StringUtils.replaceChars(attrib, "\r\n", "");
    }

    @Override
    public final String getCharsetAttribute() {
        return this.getAttributeDirect("charset");
    }

    public final String getDeferAttribute() {
        return this.getAttributeDirect("defer");
    }

    @Override
    public boolean isDeferred() {
        return ATTRIBUTE_NOT_DEFINED != this.getDeferAttribute();
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        ScriptElementSupport.onAllChildrenAddedToPage(this, postponed);
    }

    @Override
    public void markAsCreatedByDomParser() {
        this.createdByDomParser_ = true;
    }

    @Override
    public boolean wasCreatedByDomParser() {
        return this.createdByDomParser_;
    }
}

