/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import hidden.jth.org.apache.commons.lang3.ArrayUtils;
import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.cyberneko.xerces.util.StandardEncodingTranslator;
import org.htmlunit.util.NameValuePair;

public final class EncodingSniffer {
    private static final Log LOG = LogFactory.getLog(EncodingSniffer.class);
    private static final byte[][] COMMENT_START = new byte[][]{{60}, {33}, {45}, {45}};
    private static final byte[][] META_START = new byte[][]{{60}, {109, 77}, {101, 69}, {116, 84}, {97, 65}, {9, 10, 12, 13, 32, 47}};
    private static final byte[][] OTHER_START = new byte[][]{{60}, {33, 47, 63}};
    private static final byte[][] CHARSET_START = new byte[][]{{99, 67}, {104, 72}, {97, 65}, {114, 82}, {115, 83}, {101, 69}, {116, 84}};
    private static final byte[] WHITESPACE = new byte[]{9, 10, 12, 13, 32, 62};
    private static final byte[] COMMENT_END = new byte[]{45, 45, 62};
    private static final byte[] XML_DECLARATION_PREFIX = "<?xml ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CSS_CHARSET_DECLARATION_PREFIX = "@charset \"".getBytes(StandardCharsets.US_ASCII);
    private static final int SIZE_OF_HTML_CONTENT_SNIFFED = 1024;
    private static final int SIZE_OF_XML_CONTENT_SNIFFED = 512;
    private static final int SIZE_OF_CSS_CONTENT_SNIFFED = 1024;

    private EncodingSniffer() {
    }

    @Deprecated
    public static Charset sniffEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        Charset charset = EncodingSniffer.isHtml(headers) ? EncodingSniffer.sniffHtmlEncoding(headers, content) : (EncodingSniffer.isXml(headers) ? EncodingSniffer.sniffXmlEncoding(headers, content) : (EncodingSniffer.contentTypeEndsWith(headers, "text/css") ? EncodingSniffer.sniffCssEncoding(headers, content) : EncodingSniffer.sniffUnknownContentTypeEncoding(headers, content)));
        return charset;
    }

    @Deprecated
    static boolean isHtml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/html");
    }

    @Deprecated
    static boolean isXml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/xml", "application/xml", "text/vnd.wap.wml", "+xml");
    }

    static boolean contentTypeEndsWith(List<NameValuePair> headers, String ... contentTypeEndings) {
        for (NameValuePair pair : headers) {
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name)) continue;
            String value = pair.getValue();
            int i = value.indexOf(59);
            if (i != -1) {
                value = value.substring(0, i);
            }
            value = value.trim().toLowerCase(Locale.ROOT);
            for (String ending : contentTypeEndings) {
                if (!value.endsWith(ending.toLowerCase(Locale.ROOT))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public static Charset sniffHtmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, 3);
        Charset encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 1024, bytes);
        encoding = EncodingSniffer.sniffEncodingFromMetaTag(bytes);
        return encoding;
    }

    @Deprecated
    public static Charset sniffXmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, 3);
        Charset encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 512, bytes);
        encoding = EncodingSniffer.sniffEncodingFromXmlDeclaration(bytes);
        return encoding;
    }

    @Deprecated
    private static Charset sniffCssEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, 3);
        Charset encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 1024, bytes);
        encoding = EncodingSniffer.sniffEncodingFromCssDeclaration(bytes);
        return encoding;
    }

    @Deprecated
    public static Charset sniffUnknownContentTypeEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, 3);
        Charset encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        return encoding;
    }

    @Deprecated
    public static Charset sniffEncodingFromHttpHeaders(List<NameValuePair> headers) {
        for (NameValuePair pair : headers) {
            Charset encoding;
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name) || (encoding = EncodingSniffer.extractEncodingFromContentType(pair.getValue())) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Encoding found in HTTP headers: '" + encoding + "'."));
            }
            return encoding;
        }
        return null;
    }

    static Charset sniffEncodingFromUnicodeBom(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Charset encoding = null;
        if (EncodingSniffer.startsWith(bytes, ByteOrderMark.UTF_8)) {
            encoding = StandardCharsets.UTF_8;
        } else if (EncodingSniffer.startsWith(bytes, ByteOrderMark.UTF_16BE)) {
            encoding = StandardCharsets.UTF_16BE;
        } else if (EncodingSniffer.startsWith(bytes, ByteOrderMark.UTF_16LE)) {
            encoding = StandardCharsets.UTF_16LE;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding found in Unicode Byte Order Mark: '" + encoding + "'."));
        }
        return encoding;
    }

    private static boolean startsWith(byte[] bytes, ByteOrderMark bom) {
        byte[] bomBytes = bom.getBytes();
        byte[] firstBytes = Arrays.copyOfRange(bytes, 0, Math.min(bytes.length, bomBytes.length));
        return Arrays.equals(firstBytes, bomBytes);
    }

    @Deprecated
    static Charset sniffEncodingFromMetaTag(byte[] bytes) throws IOException {
        return EncodingSniffer.sniffEncodingFromMetaTag(new ByteArrayInputStream(bytes));
    }

    public static Charset sniffEncodingFromMetaTag(InputStream is) throws IOException {
        byte[] bytes = EncodingSniffer.read(is, 1024);
        for (int i = 0; i < bytes.length; ++i) {
            Attribute att;
            block17: {
                if (EncodingSniffer.matches(bytes, i, COMMENT_START)) {
                    if ((i = EncodingSniffer.indexOfSubArray(bytes, COMMENT_END, i)) == -1) break;
                    i += 2;
                    continue;
                }
                if (!EncodingSniffer.matches(bytes, i, META_START)) break block17;
                att = EncodingSniffer.getAttribute(bytes, i += META_START.length);
                while (att != null) {
                    block18: {
                        Charset charset;
                        block20: {
                            String value;
                            String name;
                            block19: {
                                i = att.getUpdatedIndex();
                                name = att.getName().toLowerCase(Locale.ROOT);
                                value = att.getValue().toLowerCase(Locale.ROOT);
                                if (!"charset".equals(name) && !"content".equals(name)) break block18;
                                charset = null;
                                if (!"charset".equals(name)) break block19;
                                charset = EncodingSniffer.toCharset(value);
                                if (charset == null && "x-user-defined".equals(value)) {
                                    charset = Charset.forName("windows-1252");
                                }
                                break block20;
                            }
                            if (!"content".equals(name)) break block20;
                            charset = EncodingSniffer.extractEncodingFromContentType(value);
                            if (charset == null && value != null && value.contains("x-user-defined")) {
                                charset = Charset.forName("windows-1252");
                            }
                            if (charset == null) break block18;
                        }
                        if (StandardCharsets.UTF_16BE == charset || StandardCharsets.UTF_16LE == charset) {
                            charset = StandardCharsets.UTF_8;
                        }
                        if (charset != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Encoding found in meta tag: '" + charset + "'."));
                            }
                            return charset;
                        }
                    }
                    att = EncodingSniffer.getAttribute(bytes, i);
                }
                continue;
            }
            if (i + 1 < bytes.length && bytes[i] == 60 && Character.isLetter(bytes[i + 1])) {
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, WHITESPACE)) == -1) break;
                att = EncodingSniffer.getAttribute(bytes, i);
                while (att != null) {
                    i = att.getUpdatedIndex();
                    att = EncodingSniffer.getAttribute(bytes, i);
                }
                continue;
            }
            if (i + 2 < bytes.length && bytes[i] == 60 && bytes[i + 1] == 47 && Character.isLetter(bytes[i + 2])) {
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 62})) == -1) break;
                Attribute attribute = EncodingSniffer.getAttribute(bytes, i);
                while (attribute != null) {
                    i = attribute.getUpdatedIndex();
                    attribute = EncodingSniffer.getAttribute(bytes, i);
                }
                continue;
            }
            if (EncodingSniffer.matches(bytes, i, OTHER_START) && (i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{62})) == -1) break;
        }
        return null;
    }

    static Attribute getAttribute(byte[] bytes, int startFrom) {
        byte b;
        if (startFrom >= bytes.length) {
            return null;
        }
        int pos = startFrom;
        while (bytes[pos] == 9 || bytes[pos] == 10 || bytes[pos] == 12 || bytes[pos] == 13 || bytes[pos] == 32 || bytes[pos] == 47) {
            if (++pos < bytes.length) continue;
            return null;
        }
        if (bytes[pos] == 62) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (true) {
            if (pos >= bytes.length) {
                return new Attribute(name.toString(), value.toString(), pos);
            }
            if (bytes[pos] == 61 && name.length() != 0) {
                ++pos;
                break;
            }
            if (bytes[pos] == 9 || bytes[pos] == 10 || bytes[pos] == 12 || bytes[pos] == 13 || bytes[pos] == 32) {
                while (bytes[pos] == 9 || bytes[pos] == 10 || bytes[pos] == 12 || bytes[pos] == 13 || bytes[pos] == 32) {
                    if (++pos < bytes.length) continue;
                    return new Attribute(name.toString(), value.toString(), pos);
                }
                if (bytes[pos] != 61) {
                    return new Attribute(name.toString(), value.toString(), pos);
                }
                ++pos;
                break;
            }
            if (bytes[pos] == 47 || bytes[pos] == 62) {
                return new Attribute(name.toString(), value.toString(), pos);
            }
            name.append((char)bytes[pos]);
            ++pos;
        }
        if (pos >= bytes.length) {
            return new Attribute(name.toString(), value.toString(), pos);
        }
        while (bytes[pos] == 9 || bytes[pos] == 10 || bytes[pos] == 12 || bytes[pos] == 13 || bytes[pos] == 32) {
            if (++pos < bytes.length) continue;
            return new Attribute(name.toString(), value.toString(), pos);
        }
        if (bytes[pos] == 34 || bytes[pos] == 39) {
            byte b2 = bytes[pos];
            ++pos;
            while (pos < bytes.length) {
                if (bytes[pos] == b2) {
                    return new Attribute(name.toString(), value.toString(), ++pos);
                }
                if (bytes[pos] >= 65 && bytes[pos] <= 90) {
                    byte b22 = (byte)(bytes[pos] + 32);
                    value.append((char)b22);
                } else {
                    value.append((char)bytes[pos]);
                }
                ++pos;
            }
            return new Attribute(name.toString(), value.toString(), pos);
        }
        if (bytes[pos] == 62) {
            return new Attribute(name.toString(), value.toString(), pos);
        }
        if (bytes[pos] >= 65 && bytes[pos] <= 90) {
            b = (byte)(bytes[pos] + 32);
            value.append((char)b);
            ++pos;
        } else {
            value.append((char)bytes[pos]);
            ++pos;
        }
        while (pos < bytes.length) {
            if (bytes[pos] == 9 || bytes[pos] == 10 || bytes[pos] == 12 || bytes[pos] == 13 || bytes[pos] == 32 || bytes[pos] == 62) {
                return new Attribute(name.toString(), value.toString(), pos);
            }
            if (bytes[pos] >= 65 && bytes[pos] <= 90) {
                b = (byte)(bytes[pos] + 32);
                value.append((char)b);
            } else {
                value.append((char)bytes[pos]);
            }
            ++pos;
        }
        return new Attribute(name.toString(), value.toString(), pos);
    }

    public static Charset extractEncodingFromContentType(String s) {
        int i;
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < bytes.length; ++i) {
            if (!EncodingSniffer.matches(bytes, i, CHARSET_START)) continue;
            i += CHARSET_START.length;
            break;
        }
        if (i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] != 61) {
            return null;
        }
        if (++i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] == 34) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf(bytes, (byte)34, i + 1);
            if (index == -1) {
                return null;
            }
            String charsetName = new String(ArrayUtils.subarray(bytes, i + 1, index), StandardCharsets.US_ASCII);
            return EncodingSniffer.toCharset(charsetName);
        }
        if (bytes[i] == 39) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf(bytes, (byte)39, i + 1);
            if (index == -1) {
                return null;
            }
            String charsetName = new String(ArrayUtils.subarray(bytes, i + 1, index), StandardCharsets.US_ASCII);
            return EncodingSniffer.toCharset(charsetName);
        }
        int end = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 59});
        if (end == -1) {
            end = bytes.length;
        }
        String charsetName = new String(ArrayUtils.subarray(bytes, i, end), StandardCharsets.US_ASCII);
        return EncodingSniffer.toCharset(charsetName);
    }

    @Deprecated
    static Charset sniffEncodingFromXmlDeclaration(byte[] bytes) throws IOException {
        return EncodingSniffer.sniffEncodingFromXmlDeclaration(new ByteArrayInputStream(bytes));
    }

    public static Charset sniffEncodingFromXmlDeclaration(InputStream is) throws IOException {
        String declaration;
        int start;
        int index;
        byte[] bytes = EncodingSniffer.read(is, 512);
        Charset encoding = null;
        if (bytes.length > 5 && XML_DECLARATION_PREFIX[0] == bytes[0] && XML_DECLARATION_PREFIX[1] == bytes[1] && XML_DECLARATION_PREFIX[2] == bytes[2] && XML_DECLARATION_PREFIX[3] == bytes[3] && XML_DECLARATION_PREFIX[4] == bytes[4] && XML_DECLARATION_PREFIX[5] == bytes[5] && (index = ArrayUtils.indexOf(bytes, (byte)63, 2)) + 1 < bytes.length && bytes[index + 1] == 62 && (start = (declaration = new String(bytes, 0, index + 2, StandardCharsets.US_ASCII)).indexOf("encoding")) != -1) {
            char delimiter;
            start += 8;
            block3: while (true) {
                switch (declaration.charAt(start)) {
                    case '\"': 
                    case '\'': {
                        delimiter = declaration.charAt(start);
                        break block3;
                    }
                    default: {
                        ++start;
                        continue block3;
                    }
                }
                break;
            }
            int end = declaration.indexOf(delimiter, ++start);
            encoding = EncodingSniffer.toCharset(declaration.substring(start, end));
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding found in XML declaration: '" + encoding + "'."));
        }
        return encoding;
    }

    @Deprecated
    static Charset sniffEncodingFromCssDeclaration(byte[] bytes) throws IOException {
        return EncodingSniffer.sniffEncodingFromXmlDeclaration(new ByteArrayInputStream(bytes));
    }

    public static Charset sniffEncodingFromCssDeclaration(InputStream is) throws IOException {
        byte[] bytes = EncodingSniffer.read(is, 1024);
        if (bytes.length < CSS_CHARSET_DECLARATION_PREFIX.length) {
            return null;
        }
        for (int i = 0; i < CSS_CHARSET_DECLARATION_PREFIX.length; ++i) {
            if (bytes[i] == CSS_CHARSET_DECLARATION_PREFIX[i]) continue;
            return null;
        }
        Charset encoding = null;
        int index = ArrayUtils.indexOf(bytes, (byte)34, CSS_CHARSET_DECLARATION_PREFIX.length);
        if (index + 1 < bytes.length && bytes[index + 1] == 59 && ((encoding = EncodingSniffer.toCharset(new String(bytes, CSS_CHARSET_DECLARATION_PREFIX.length, index - CSS_CHARSET_DECLARATION_PREFIX.length, StandardCharsets.US_ASCII))) == StandardCharsets.UTF_16BE || encoding == StandardCharsets.UTF_16LE)) {
            encoding = StandardCharsets.UTF_8;
        }
        return encoding;
    }

    public static Charset toCharset(String charsetName) {
        String nameFromLabel = EncodingSniffer.translateEncodingLabel(charsetName);
        if (nameFromLabel == null) {
            return null;
        }
        try {
            return Charset.forName(nameFromLabel);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    static boolean matches(byte[] bytes, int i, byte[][] sought) {
        if (i + sought.length > bytes.length) {
            return false;
        }
        for (int x = 0; x < sought.length; ++x) {
            byte[] possibilities = sought[x];
            boolean match = false;
            for (byte possibility : possibilities) {
                if (bytes[i + x] != possibility) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    static int skipToAnyOf(byte[] bytes, int startFrom, byte[] targets) {
        int i;
        for (i = startFrom; i < bytes.length && !ArrayUtils.contains(targets, bytes[i]); ++i) {
        }
        if (i == bytes.length) {
            i = -1;
        }
        return i;
    }

    static int indexOfSubArray(byte[] array, byte[] subarray, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            boolean found = true;
            if (i + subarray.length > array.length) break;
            for (int j = 0; j < subarray.length; ++j) {
                byte a = array[i + j];
                byte b = subarray[j];
                if (a == b) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    static byte[] read(InputStream content, int size) throws IOException {
        byte[] bytes = new byte[size];
        int count = IOUtils.read((InputStream)content, (byte[])bytes);
        if (count < size) {
            byte[] smaller = new byte[count];
            System.arraycopy(bytes, 0, smaller, 0, count);
            bytes = smaller;
        }
        return bytes;
    }

    static byte[] readAndPrepend(InputStream content, int size, byte[] prefix) throws IOException {
        int prefixLength = prefix.length;
        byte[] joined = new byte[prefixLength + size];
        int count = IOUtils.read((InputStream)content, (byte[])joined, (int)prefixLength, (int)(joined.length - prefixLength));
        if (count < size) {
            byte[] smaller = new byte[prefixLength + count];
            System.arraycopy(prefix, 0, smaller, 0, prefix.length);
            System.arraycopy(joined, prefixLength, smaller, prefixLength, count);
            return smaller;
        }
        System.arraycopy(prefix, 0, joined, 0, prefix.length);
        return joined;
    }

    @Deprecated
    public static String translateEncodingLabel(Charset encodingLabel) {
        return EncodingSniffer.translateEncodingLabel(encodingLabel.name());
    }

    public static String translateEncodingLabel(String encodingLabel) {
        String enc;
        if (StringUtils.isEmpty(encodingLabel)) {
            return null;
        }
        String encLC = encodingLabel.toLowerCase(Locale.ROOT);
        if (encLC.equals(enc = StandardEncodingTranslator.INSTANCE.encodingNameFromLabel(encodingLabel))) {
            return encodingLabel;
        }
        return enc;
    }

    static class Attribute {
        private final String name_;
        private final String value_;
        private final int updatedIndex_;

        Attribute(String name, String value, int updatedIndex) {
            this.name_ = name;
            this.value_ = value;
            this.updatedIndex_ = updatedIndex;
        }

        String getName() {
            return this.name_;
        }

        String getValue() {
            return this.value_;
        }

        int getUpdatedIndex() {
            return this.updatedIndex_;
        }
    }
}

