/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class OrderedFastHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final Object FREE_KEY_ = null;
    private static final Object REMOVED_KEY_ = new Object();
    private static final double FILLFACTOR_ = 0.7;
    private Object[] mapData_;
    private int mapThreshold_;
    private int mapSize_;
    private int[] orderedList_;
    private int orderedListSize_;

    public OrderedFastHashMap() {
        this(8);
    }

    public OrderedFastHashMap(int size) {
        if (size > 0) {
            int capacity = OrderedFastHashMap.arraySize(size, 0.7);
            this.mapData_ = new Object[capacity << 1];
            this.mapThreshold_ = (int)((double)capacity * 0.7);
            this.orderedList_ = new int[capacity];
        } else {
            this.mapData_ = new Object[0];
            this.mapThreshold_ = 0;
            this.orderedList_ = new int[0];
        }
    }

    @Override
    public V get(Object key) {
        int length = this.mapData_.length;
        if (length == 0) {
            return null;
        }
        int ptr = (key.hashCode() & (length >> 1) - 1) << 1;
        Object k = this.mapData_[ptr];
        if (k == FREE_KEY_) {
            return null;
        }
        if (k.hashCode() == key.hashCode() && k.equals(key)) {
            return (V)this.mapData_[ptr + 1];
        }
        int originalPtr = ptr;
        do {
            if (originalPtr == (ptr = ptr + 2 & length - 1)) {
                return null;
            }
            k = this.mapData_[ptr];
            if (k != FREE_KEY_) continue;
            return null;
        } while (k == REMOVED_KEY_ || k.hashCode() != key.hashCode() || !k.equals(key));
        return (V)this.mapData_[ptr + 1];
    }

    private V put(K key, V value, Position listPosition) {
        int ptr;
        Object k;
        if (this.mapSize_ >= this.mapThreshold_) {
            this.rehash(this.mapData_.length == 0 ? 4 : this.mapData_.length << 1);
        }
        if ((k = this.mapData_[ptr = this.getStartIndex(key) << 1]) == FREE_KEY_) {
            this.mapData_[ptr] = key;
            this.mapData_[ptr + 1] = value;
            this.orderedListAdd(listPosition, ptr);
            ++this.mapSize_;
            return null;
        }
        if (k.equals(key)) {
            Object ret = this.mapData_[ptr + 1];
            this.mapData_[ptr + 1] = value;
            return (V)ret;
        }
        int firstRemoved = -1;
        if (k == REMOVED_KEY_) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.mapData_[ptr = ptr + 2 & this.mapData_.length - 1]) == FREE_KEY_) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.mapData_[ptr] = key;
                this.mapData_[ptr + 1] = value;
                this.orderedListAdd(listPosition, ptr);
                ++this.mapSize_;
                return null;
            }
            if (k.equals(key)) {
                Object ret = this.mapData_[ptr + 1];
                this.mapData_[ptr + 1] = value;
                return (V)ret;
            }
            if (k != REMOVED_KEY_ || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    @Override
    public V remove(Object key) {
        int length = this.mapData_.length;
        if (length == 0) {
            return null;
        }
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.mapData_[ptr];
        if (k == FREE_KEY_) {
            return null;
        }
        if (k.equals(key)) {
            --this.mapSize_;
            this.mapData_[ptr] = this.mapData_[ptr + 2 & length - 1] == FREE_KEY_ ? FREE_KEY_ : REMOVED_KEY_;
            Object ret = this.mapData_[ptr + 1];
            this.mapData_[ptr + 1] = null;
            this.orderedListRemove(ptr);
            return (V)ret;
        }
        do {
            if ((k = this.mapData_[ptr = ptr + 2 & length - 1]) != FREE_KEY_) continue;
            return null;
        } while (!k.equals(key));
        --this.mapSize_;
        this.mapData_[ptr] = this.mapData_[ptr + 2 & length - 1] == FREE_KEY_ ? FREE_KEY_ : REMOVED_KEY_;
        Object ret = this.mapData_[ptr + 1];
        this.mapData_[ptr + 1] = null;
        this.orderedListRemove(ptr);
        return (V)ret;
    }

    @Override
    public int size() {
        return this.mapSize_;
    }

    private void rehash(int newCapacity) {
        this.mapThreshold_ = (int)((double)(newCapacity / 2) * 0.7);
        Object[] oldData = this.mapData_;
        this.mapData_ = new Object[newCapacity];
        int[] oldOrderedList = this.orderedList_;
        int oldOrderedListSize = this.orderedListSize_;
        this.orderedList_ = new int[newCapacity];
        this.mapSize_ = 0;
        this.orderedListSize_ = 0;
        for (int i = 0; i < oldOrderedListSize; ++i) {
            int pos = oldOrderedList[i];
            Object key = oldData[pos];
            Object value = oldData[pos + 1];
            this.put(key, value, Position.LAST);
        }
    }

    public List<K> keys() {
        ArrayList<Object> result = new ArrayList<Object>(this.orderedListSize_);
        for (int i = 0; i < this.orderedListSize_; ++i) {
            int pos = this.orderedList_[i];
            Object o = this.mapData_[pos];
            result.add(o);
        }
        return result;
    }

    @Override
    public List<V> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.orderedListSize_);
        for (int i = 0; i < this.orderedListSize_; ++i) {
            int pos = this.orderedList_[i];
            Object o = this.mapData_[pos + 1];
            result.add(o);
        }
        return result;
    }

    @Override
    public void clear() {
        this.mapSize_ = 0;
        this.orderedListSize_ = 0;
        Arrays.fill(this.mapData_, FREE_KEY_);
    }

    private int getStartIndex(Object key) {
        return key.hashCode() & (this.mapData_.length >> 1) - 1;
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        long r = x - 1L;
        r |= r >> 1;
        r |= r >> 2;
        r |= r >> 4;
        r |= r >> 8;
        r |= r >> 16;
        return (r | r >> 32) + 1L;
    }

    private static int arraySize(int expected, double f) {
        long s = Math.max(2L, OrderedFastHashMap.nextPowerOfTwo((long)Math.ceil((double)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    public Entry<K, V> getEntry(int index) {
        if (index < 0 || index >= this.orderedListSize_) {
            throw new IndexOutOfBoundsException(String.format("Index: %s, Size: %s", index, this.orderedListSize_));
        }
        int pos = this.orderedList_[index];
        return new Entry<Object, Object>(this.mapData_[pos], this.mapData_[pos + 1]);
    }

    public K getKey(int index) {
        if (index < 0 || index >= this.orderedListSize_) {
            throw new IndexOutOfBoundsException(String.format("Index: %s, Size: %s", index, this.orderedListSize_));
        }
        int pos = this.orderedList_[index];
        return (K)this.mapData_[pos];
    }

    public V getValue(int index) {
        if (index < 0 || index >= this.orderedListSize_) {
            throw new IndexOutOfBoundsException(String.format("Index: %s, Size: %s", index, this.orderedListSize_));
        }
        int pos = this.orderedList_[index];
        return (V)this.mapData_[pos + 1];
    }

    public V remove(int index) {
        if (index < 0 || index >= this.orderedListSize_) {
            throw new IndexOutOfBoundsException(String.format("Index: %s, Size: %s", index, this.orderedListSize_));
        }
        int pos = this.orderedList_[index];
        Object key = this.mapData_[pos];
        return this.remove(key);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, Position.LAST);
    }

    public V addFirst(K key, V value) {
        return this.put(key, value, Position.FIRST);
    }

    public V add(K key, V value) {
        return this.put(key, value, Position.LAST);
    }

    public V addLast(K key, V value) {
        return this.put(key, value, Position.LAST);
    }

    public V getFirst() {
        return this.getValue(0);
    }

    public V getLast() {
        return this.getValue(this.orderedListSize_ - 1);
    }

    public V removeFirst() {
        if (this.orderedListSize_ > 0) {
            int pos = this.orderedList_[0];
            Object key = this.mapData_[pos];
            return this.remove(key);
        }
        return null;
    }

    public V removeLast() {
        if (this.orderedListSize_ > 0) {
            int pos = this.orderedList_[this.orderedListSize_ - 1];
            Object key = this.mapData_[pos];
            return this.remove(key);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.orderedListSize_; ++i) {
            int pos = this.orderedList_[i] + 1;
            Object v = this.mapData_[pos];
            if (v != value && !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.mapSize_ == 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new OrderedEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        return new OrderedKeySet(this);
    }

    public void reverse() {
        int to = this.orderedListSize_ / 2;
        for (int i = 0; i < to; ++i) {
            int j = this.orderedList_[i];
            this.orderedList_[i] = this.orderedList_[this.orderedListSize_ - i - 1];
            this.orderedList_[this.orderedListSize_ - i - 1] = j;
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        Object[] srcData = Arrays.copyOf(this.mapData_, this.mapData_.length);
        int[] srcIndex = Arrays.copyOf(this.orderedList_, this.orderedList_.length);
        int orderedListSize = this.orderedListSize_;
        this.clear();
        for (int i = 0; i < orderedListSize; ++i) {
            int pos = srcIndex[i];
            Object key = srcData[pos];
            Object value = srcData[pos + 1];
            this.put(key, value);
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        for (int i = 0; i < this.mapData_.length; ++i) {
            Object entry = this.mapData_[i];
            if (entry != FREE_KEY_ && entry != REMOVED_KEY_) continue;
            this.mapData_[i] = null;
        }
        aOutputStream.defaultWriteObject();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> src) {
        if (src == this) {
            throw new IllegalArgumentException("Cannot add myself");
        }
        for (Map.Entry<K, V> entry : src.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), Position.LAST);
        }
    }

    private void orderedListAdd(Position listPosition, int position) {
        if (listPosition == Position.FIRST) {
            System.arraycopy(this.orderedList_, 0, this.orderedList_, 1, this.orderedList_.length - 1);
            this.orderedList_[0] = position;
            ++this.orderedListSize_;
        } else if (listPosition == Position.LAST) {
            this.orderedList_[this.orderedListSize_] = position;
            ++this.orderedListSize_;
        }
    }

    private void orderedListRemove(int position) {
        int i;
        for (i = 0; i < this.orderedListSize_; ++i) {
            if (this.orderedList_[i] != position) continue;
            this.orderedList_[i] = -1;
            if (i < this.orderedListSize_) {
                System.arraycopy(this.orderedList_, i + 1, this.orderedList_, i, this.orderedListSize_ - i);
            }
            --this.orderedListSize_;
            return;
        }
        if (i == this.orderedListSize_) {
            throw new IllegalArgumentException(String.format("Position %s was not in order list", position));
        }
    }

    public String toString() {
        int maxLen = 10;
        return String.format("mapData=%s, mapFillFactor=%s, mapThreshold=%s, mapSize=%s,%norderedList=%s, orderedListSize=%s", this.mapData_ != null ? Arrays.asList(this.mapData_).subList(0, Math.min(this.mapData_.length, 10)) : null, 0.7, this.mapThreshold_, this.mapSize_, this.orderedList_ != null ? Arrays.toString(Arrays.copyOf(this.orderedList_, Math.min(this.orderedList_.length, 10))) : null, this.orderedListSize_);
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key_;
        private final V value_;

        Entry(K key, V value) {
            this.key_ = key;
            this.value_ = value;
        }

        @Override
        public K getKey() {
            return this.key_;
        }

        @Override
        public V getValue() {
            return this.value_;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("This map does not support write-through via an entry");
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key_) ^ Objects.hashCode(this.value_);
        }

        public String toString() {
            return this.key_ + "=" + this.value_;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.key_, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value_, e.getValue());
        }
    }

    private static enum Position {
        NONE,
        FIRST,
        LAST;

    }

    static class OrderedKeySet<K, V>
    implements Set<K> {
        private final OrderedFastHashMap<K, V> backingMap_;

        OrderedKeySet(OrderedFastHashMap<K, V> backingMap) {
            this.backingMap_ = backingMap;
        }

        @Override
        public int size() {
            return this.backingMap_.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap_.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingMap_.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[((OrderedFastHashMap)this.backingMap_).orderedListSize_];
            return this.toArray(array);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] array = a.length >= ((OrderedFastHashMap)this.backingMap_).orderedListSize_ ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), ((OrderedFastHashMap)this.backingMap_).orderedListSize_);
            for (int i = 0; i < ((OrderedFastHashMap)this.backingMap_).orderedListSize_; ++i) {
                array[i] = this.backingMap_.getKey(i);
            }
            return array;
        }

        @Override
        public Iterator<K> iterator() {
            return new OrderedKeyIterator();
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        class OrderedKeyIterator
        implements Iterator<K> {
            private int pos_ = 0;

            OrderedKeyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.pos_ < OrderedKeySet.this.backingMap_.orderedListSize_;
            }

            @Override
            public K next() {
                if (this.pos_ < OrderedKeySet.this.backingMap_.orderedListSize_) {
                    return OrderedKeySet.this.backingMap_.getKey(this.pos_++);
                }
                throw new NoSuchElementException();
            }
        }
    }

    static class OrderedEntrySet<K, V>
    implements Set<Map.Entry<K, V>> {
        private final OrderedFastHashMap<K, V> backingMap_;

        OrderedEntrySet(OrderedFastHashMap<K, V> backingMap) {
            this.backingMap_ = backingMap;
        }

        @Override
        public int size() {
            return this.backingMap_.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap_.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry ose = (Map.Entry)o;
                Object k = ose.getKey();
                Object v = ose.getValue();
                V value = this.backingMap_.get(k);
                if (value != null) {
                    return v.equals(value);
                }
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[((OrderedFastHashMap)this.backingMap_).orderedListSize_];
            return this.toArray(array);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] array = a.length >= ((OrderedFastHashMap)this.backingMap_).orderedListSize_ ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), ((OrderedFastHashMap)this.backingMap_).orderedListSize_);
            for (int i = 0; i < ((OrderedFastHashMap)this.backingMap_).orderedListSize_; ++i) {
                array[i] = this.backingMap_.getEntry(i);
            }
            return array;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new OrderedEntryIterator();
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        class OrderedEntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private int pos_ = 0;

            OrderedEntryIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.pos_ < OrderedEntrySet.this.backingMap_.orderedListSize_;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.pos_ < OrderedEntrySet.this.backingMap_.orderedListSize_) {
                    return OrderedEntrySet.this.backingMap_.getEntry(this.pos_++);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

