/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.utils;

import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public class DefaultErrorHandler
implements ErrorListener {
    PrintWriter m_pw;
    final boolean m_throwExceptionOnError;

    public DefaultErrorHandler() {
        this(true);
    }

    public DefaultErrorHandler(boolean throwExceptionOnError) {
        this.m_throwExceptionOnError = throwExceptionOnError;
    }

    public PrintWriter getErrorWriter() {
        if (this.m_pw == null) {
            this.m_pw = new PrintWriter(System.err, true);
        }
        return this.m_pw;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        PrintWriter pw = this.getErrorWriter();
        pw.println(exception.getMessage());
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        if (this.m_throwExceptionOnError) {
            throw exception;
        }
        PrintWriter pw = this.getErrorWriter();
        pw.println(exception.getMessage());
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        if (this.m_throwExceptionOnError) {
            throw exception;
        }
        PrintWriter pw = this.getErrorWriter();
        pw.println(exception.getMessage());
    }
}

