/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;

public class XMLSerializer {
    private boolean preserveWhiteSpace_;

    public XMLSerializer(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    public String serializeToString(XMLDOMNode root) {
        if (root == null) {
            return "";
        }
        if (root instanceof XMLDOMDocument) {
            root = ((XMLDOMDocument)root).getDocumentElement();
        } else if (root instanceof XMLDOMDocumentFragment) {
            root = root.getFirstChild();
        }
        if (root instanceof XMLDOMElement) {
            StringBuilder buffer = new StringBuilder();
            DomNode node = root.getDomNodeOrDie();
            this.toXml(1, node, buffer);
            buffer.append("\r\n");
            return buffer.toString();
        }
        return root.getDomNodeOrDie().asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder buffer) {
        String nodeName = node.getNodeName();
        buffer.append('<').append(nodeName);
        String optionalPrefix = "";
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (namespaceURI != null && prefix != null) {
            boolean sameNamespace = false;
            DomNode parentNode = node.getParentNode();
            while (parentNode instanceof DomElement) {
                if (namespaceURI.equals(parentNode.getNamespaceURI())) {
                    sameNamespace = true;
                }
                parentNode = parentNode.getParentNode();
            }
            if (node.getParentNode() == null || !sameNamespace) {
                ((DomElement)node).setAttribute("xmlns:" + prefix, namespaceURI);
            }
        }
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        block7: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                buffer.append("").append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    value = com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(value);
                    if (this.preserveWhiteSpace_) {
                        buffer.append(value.replace("\n", "\r\n"));
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)value)) {
                        buffer.append("\r\n");
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block7;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block7;
                    }
                    buffer.append(value.replace("\n", "\r\n"));
                    break;
                }
                case 4: 
                case 8: {
                    if (!this.preserveWhiteSpace_ && buffer.charAt(buffer.length() - 1) == '\n') {
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                    }
                    buffer.append(child.asXml());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            buffer.append("").append("/>");
        } else {
            if (!this.preserveWhiteSpace_ && buffer.charAt(buffer.length() - 1) == '\n') {
                for (int i = 0; i < indent - 1; ++i) {
                    buffer.append('\t');
                }
            }
            buffer.append('<').append('/').append(nodeName).append('>');
        }
    }
}

